/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.walkers;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.walkmod.exceptions.WalkModException;
import org.walkmod.javalang.ast.CompilationUnit;
import org.walkmod.javalang.ast.PackageDeclaration;
import org.walkmod.javalang.ast.body.TypeDeclaration;
import org.walkmod.javalang.ast.expr.NameExpr;
import org.walkmod.javalang.util.FileUtils;
import org.walkmod.javalang.walkers.ChangeLogVisitor;
import org.walkmod.walkers.AbstractWalker;
import org.walkmod.walkers.ChangeLogPrinter;
import org.walkmod.walkers.Parser;
import org.walkmod.walkers.VisitorContext;

public class DefaultJavaWalker
extends AbstractWalker {
    private File originalFile;
    public static final String ORIGINAL_FILE_KEY = "original_file_key";
    private static Logger log = Logger.getLogger(DefaultJavaWalker.class);
    private boolean reportChanges = true;
    private boolean onlyWriteChanges = true;
    private Map<String, Integer> added = new HashMap<String, Integer>();
    private Map<String, Integer> deleted = new HashMap<String, Integer>();
    private Map<String, Integer> updated = new HashMap<String, Integer>();
    private Map<String, Integer> unmodified = new HashMap<String, Integer>();
    private String encoding = "UTF-8";
    private Parser<CompilationUnit> parser;

    public void accept(File file) throws Exception {
        this.originalFile = file;
        this.visit(file);
    }

    public void visit(File file) throws Exception {
        if (file.getName().endsWith(".java")) {
            CompilationUnit cu = null;
            try {
                cu = (CompilationUnit)this.parser.parse(file, this.encoding);
            }
            catch (Exception e) {
                throw new WalkModException("The file " + file.getPath() + " has an invalid java format", (Throwable)e);
            }
            if (this.getRootNamespace() != null && !"".equals(this.getRootNamespace())) {
                String qualifiedName = this.getResource().getNearestNamespace((Object)file, "::");
                if (this.getRootNamespace().startsWith(qualifiedName)) {
                    return;
                }
            }
            if (cu != null) {
                log.debug((Object)(file.getPath() + " [ visiting ]"));
                this.visit(cu);
                log.debug((Object)(file.getPath() + " [ visited ]"));
            } else {
                log.warn((Object)"Empty compilation unit");
            }
        }
    }

    private void mapSum(Map<String, Integer> op1, Map<String, Integer> op2) {
        Set<String> keys = op2.keySet();
        for (String key : keys) {
            Integer aux = op1.get(key);
            if (aux == null) {
                op1.put(key, op2.get(key));
                continue;
            }
            op1.put(key, op2.get(key) + aux);
        }
    }

    protected void write(Object element) throws Exception {
        if (element != null && element instanceof CompilationUnit) {
            VisitorContext vc = new VisitorContext(this.getChainConfig());
            vc.put(ORIGINAL_FILE_KEY, (Object)this.originalFile);
            if (this.reportChanges) {
                CompilationUnit returningCU = (CompilationUnit)element;
                CompilationUnit cu = null;
                try {
                    cu = (CompilationUnit)this.parser.parse(this.originalFile, this.encoding);
                }
                catch (Exception e) {
                    throw new WalkModException("Exception writing results of " + this.originalFile.getPath(), (Throwable)e);
                }
                if (cu != null) {
                    boolean samePackage = cu.getPackage() == null && returningCU.getPackage() == null;
                    samePackage = samePackage || cu.getPackage() != null && returningCU.getPackage() != null && cu.getPackage().equals((Object)returningCU.getPackage());
                    boolean sameType = cu.getTypes() == null && returningCU.getTypes() == null;
                    sameType = sameType || cu.getTypes() != null && returningCU.getTypes() != null && ((TypeDeclaration)cu.getTypes().get(0)).getName().equals(((TypeDeclaration)returningCU.getTypes().get(0)).getName());
                    boolean resolveWrite = false;
                    if (samePackage && sameType) {
                        ChangeLogVisitor clv = new ChangeLogVisitor();
                        VisitorContext ctx = new VisitorContext();
                        ctx.put("node_to_compare_key", (Object)cu);
                        clv.visit((CompilationUnit)element, ctx);
                        if (clv.isUpdated()) {
                            log.debug((Object)(this.originalFile.getPath() + " [with changes]"));
                            String name = "";
                            if (cu.getPackage() != null) {
                                name = cu.getPackage().getName().toString();
                            }
                            if (cu.getTypes() != null && !cu.getTypes().isEmpty()) {
                                if (cu.getPackage() != null) {
                                    name = name + ".";
                                }
                                name = name + ((TypeDeclaration)cu.getTypes().get(0)).getName();
                            }
                            Map<String, Integer> auxAdded = clv.getAddedNodes();
                            Map<String, Integer> auxUpdated = clv.getUpdatedNodes();
                            Map<String, Integer> auxDeleted = clv.getDeletedNodes();
                            Map<String, Integer> auxUnmodified = clv.getUnmodifiedNodes();
                            if (this.added.isEmpty()) {
                                this.added = auxAdded;
                            } else {
                                this.mapSum(this.added, auxAdded);
                            }
                            if (this.updated.isEmpty()) {
                                this.updated = auxUpdated;
                            } else {
                                this.mapSum(this.updated, auxUpdated);
                            }
                            if (this.deleted.isEmpty()) {
                                this.deleted = auxDeleted;
                            } else {
                                this.mapSum(this.deleted, auxDeleted);
                            }
                            if (this.unmodified.isEmpty()) {
                                this.unmodified = auxUnmodified;
                            } else {
                                this.mapSum(this.unmodified, auxUnmodified);
                            }
                            log.info((Object)(">> " + name));
                            ChangeLogPrinter printer = new ChangeLogPrinter(auxAdded, auxUpdated, auxDeleted, auxUnmodified);
                            printer.print();
                            this.write(element, vc);
                            log.debug((Object)(this.originalFile.getPath() + " [ written ]"));
                        } else {
                            log.debug((Object)(this.originalFile.getPath() + " [ without changes ] "));
                            resolveWrite = true;
                        }
                    } else {
                        resolveWrite = true;
                    }
                    if (resolveWrite) {
                        String name = null;
                        if (returningCU.getTypes() != null) {
                            name = ((TypeDeclaration)returningCU.getTypes().get(0)).getName();
                            if (returningCU.getPackage() != null) {
                                String aux = returningCU.getPackage().getName().toString();
                                name = aux + "." + name;
                            }
                            if (name != null) {
                                File outputDir = FileUtils.getSourceFile((File)new File(this.getChainConfig().getWriterConfig().getPath()), (PackageDeclaration)returningCU.getPackage(), (TypeDeclaration)((TypeDeclaration)returningCU.getTypes().get(0)));
                                log.debug((Object)(outputDir.getPath() + " [ output file ]"));
                                if (!outputDir.exists()) {
                                    log.info((Object)("++ " + name));
                                    vc.remove((Object)ORIGINAL_FILE_KEY);
                                    this.write(element, vc);
                                    log.debug((Object)(outputDir.getPath() + " [ created ]"));
                                    log.debug((Object)(outputDir.getPath() + " [ written ]"));
                                } else if (!outputDir.equals(this.originalFile)) {
                                    vc.put(ORIGINAL_FILE_KEY, (Object)outputDir);
                                    this.write(element, vc);
                                    log.debug((Object)(outputDir.getPath() + " [ overwritten ]"));
                                } else if (!this.onlyWriteChanges) {
                                    vc.put(ORIGINAL_FILE_KEY, (Object)outputDir);
                                    this.write(element, vc);
                                    log.debug((Object)(outputDir.getPath() + " [ overwritten ]"));
                                } else {
                                    log.debug((Object)(this.originalFile.getPath() + " [not written] "));
                                }
                            }
                        }
                    }
                }
            } else {
                log.warn((Object)"report changes options is not active");
                this.write(element, vc);
                log.debug((Object)(this.originalFile.getPath() + " [ written ]"));
            }
        }
    }

    protected String getLocation(VisitorContext ctx) {
        return ((File)ctx.get((Object)ORIGINAL_FILE_KEY)).getAbsolutePath();
    }

    protected void visit(Object element) throws Exception {
        VisitorContext context = new VisitorContext(this.getChainConfig());
        context.put(ORIGINAL_FILE_KEY, (Object)this.originalFile);
        this.visit(element, context);
        this.addVisitorMessages(context);
    }

    public int getNumModifications() {
        Integer aux = this.updated.get(CompilationUnit.class.getSimpleName());
        if (aux == null) {
            return 0;
        }
        return aux;
    }

    public int getNumAdditions() {
        Integer aux = this.added.get(CompilationUnit.class.getSimpleName());
        if (aux == null) {
            return 0;
        }
        return aux;
    }

    public int getNumDeletions() {
        Integer aux = this.deleted.get(CompilationUnit.class.getSimpleName());
        if (aux == null) {
            return 0;
        }
        return aux;
    }

    public boolean reportChanges() {
        return this.reportChanges;
    }

    public void setReportChanges(boolean reportChanges) {
        this.reportChanges = reportChanges;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected Object getSourceNode(Object targetNode) {
        Object result = null;
        if (targetNode instanceof CompilationUnit) {
            CompilationUnit targetCU = (CompilationUnit)targetNode;
            String path = this.getChainConfig().getWriterConfig().getPath() + File.separator;
            if (targetCU.getPackage() != null) {
                NameExpr packageName = targetCU.getPackage().getName();
                String packPath = packageName.toString().replace('.', File.separatorChar);
                path = path + packPath + File.separator + this.getPublicTypeDeclaration(targetCU) + ".java";
            } else {
                path = path + this.getPublicTypeDeclaration(targetCU) + ".java";
            }
            File sourceFile = new File(path);
            if (sourceFile.exists()) {
                try {
                    result = this.parser.parse(sourceFile);
                }
                catch (Exception e) {
                    throw new WalkModException((Throwable)e);
                }
            } else {
                result = targetNode;
            }
        }
        return result;
    }

    private String getPublicTypeDeclaration(CompilationUnit cu) {
        for (TypeDeclaration td : cu.getTypes()) {
            if (td.getModifiers() != 1) continue;
            return td.getName();
        }
        throw new WalkModException("Illegal typeDeclaration list, for compilationUnit. No public type found");
    }

    public void setParser(Parser<?> parser) {
        this.parser = parser;
    }

    public Parser<?> getParser() {
        return this.parser;
    }
}

