/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.visitors;

import java.util.HashMap;
import java.util.LinkedList;
import org.walkmod.exceptions.WalkModException;
import org.walkmod.javalang.visitors.VoidVisitorAdapter;
import org.walkmod.query.QueryEngine;
import org.walkmod.query.QueryEngineAware;
import org.walkmod.walkers.VisitorContext;

public abstract class VisitorSupport<A>
extends VoidVisitorAdapter<A>
implements QueryEngineAware {
    private QueryEngine queryEngine;

    public void initialize(VisitorContext context, Object rootNode) {
        if (this.queryEngine == null) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("language", "groovy");
            LinkedList<String> includes = new LinkedList<String>();
            includes.add("query.alias.groovy");
            parameters.put("includes", includes);
            Object bean = context.getBean("org.walkmod.query.ScriptingQueryEngine", parameters);
            if (bean != null) {
                if (bean instanceof QueryEngine) {
                    this.queryEngine = (QueryEngine)bean;
                }
            } else {
                throw new WalkModException("Query Engine not found");
            }
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("node", rootNode);
        this.queryEngine.initialize(context, params);
    }

    public void setQueryEngine(QueryEngine queryEngine) {
        this.queryEngine = queryEngine;
    }

    public QueryEngine getQueryEngine() {
        return this.queryEngine;
    }

    public Object query(String query) {
        if (this.queryEngine != null) {
            return this.queryEngine.resolve(query);
        }
        return null;
    }

    public Object query(Object context, String query) {
        if (this.queryEngine != null) {
            return this.queryEngine.resolve(context, query);
        }
        return null;
    }
}

