/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.utils;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.voltdb.PrivateVoltTableFactory;
import org.voltdb.VoltTable;
import org.voltdb.types.GeographyPointValue;
import org.voltdb.types.GeographyValue;
import org.voltdb.types.TimestampType;
import org.voltdb.types.VoltDecimalHelper;

public class SerializationHelper {
    private SerializationHelper() {
    }

    public static String getString(ByteBuffer buf) throws IOException {
        byte[] strbytes = SerializationHelper.getVarbinary(buf);
        return strbytes == null ? null : new String(strbytes, StandardCharsets.UTF_8);
    }

    public static String getString(ByteBuf buf) throws IOException {
        byte[] strbytes = SerializationHelper.getVarbinary(buf);
        return strbytes == null ? null : new String(strbytes, StandardCharsets.UTF_8);
    }

    public static byte[] getVarbinary(ByteBuffer buf) throws IOException {
        int len = buf.getInt();
        if (len == -1) {
            return null;
        }
        if (len < -1) {
            throw new IOException("Value length is negative " + len);
        }
        if (len > buf.remaining()) {
            throw new IOException("Value length is bigger than total buffer " + len);
        }
        byte[] retval = new byte[len];
        buf.get(retval);
        return retval;
    }

    public static byte[] getVarbinary(ByteBuf buf) throws IOException {
        int len = buf.readInt();
        if (len == -1) {
            return null;
        }
        if (len < -1) {
            throw new IOException("Value length is negative " + len);
        }
        if (len > buf.readableBytes()) {
            throw new IOException("Value length is bigger than total buffer " + len);
        }
        byte[] retval = new byte[len];
        buf.readBytes(retval);
        return retval;
    }

    public static BigDecimal getBigDecimal(ByteBuffer buf) {
        return VoltDecimalHelper.deserializeBigDecimal(buf);
    }

    public static Object readArray(Class<?> type, ByteBuffer buf) throws IOException {
        int count;
        int n = count = type == Byte.TYPE ? buf.getInt() : (int)buf.getShort();
        if (count < 0) {
            throw new IOException("Array length is negative " + count);
        }
        if (type == Byte.TYPE) {
            if (count > 0x100000) {
                throw new IOException("Array length is greater then the max of 1 megabyte " + count);
            }
            if (count > buf.remaining()) {
                throw new IOException("Array length is greater than total buffer " + count);
            }
            byte[] retval = new byte[count];
            buf.get(retval);
            return retval;
        }
        if (type == byte[].class) {
            byte[][] retval = new byte[count][];
            for (int i = 0; i < count; ++i) {
                int size = buf.getInt();
                if (size == -1) {
                    retval[i] = null;
                    continue;
                }
                retval[i] = new byte[size];
                buf.get(retval[i]);
            }
            return retval;
        }
        if (type == Short.TYPE) {
            short[] retval = new short[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = buf.getShort();
            }
            return retval;
        }
        if (type == Integer.TYPE) {
            int[] retval = new int[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = buf.getInt();
            }
            return retval;
        }
        if (type == Long.TYPE) {
            long[] retval = new long[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = buf.getLong();
            }
            return retval;
        }
        if (type == Long.class) {
            Long[] retval = new Long[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = buf.getLong();
            }
            return retval;
        }
        if (type == String.class) {
            String[] retval = new String[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = SerializationHelper.getString(buf);
            }
            return retval;
        }
        if (type == Double.TYPE) {
            double[] retval = new double[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = buf.getDouble();
            }
            return retval;
        }
        if (type == Double.class) {
            Double[] retval = new Double[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = buf.getDouble();
            }
            return retval;
        }
        if (type == TimestampType.class) {
            TimestampType[] retval = new TimestampType[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = new TimestampType(buf.getLong());
            }
            return retval;
        }
        if (type == BigDecimal.class) {
            BigDecimal[] retval = new BigDecimal[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = SerializationHelper.getBigDecimal(buf);
            }
            return retval;
        }
        if (type == GeographyPointValue.class) {
            GeographyPointValue[] retval = new GeographyPointValue[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = GeographyPointValue.unflattenFromBuffer(buf);
            }
            return retval;
        }
        if (type == GeographyValue.class) {
            GeographyValue[] retval = new GeographyValue[count];
            for (int i = 0; i < count; ++i) {
                int len = buf.getInt();
                retval[i] = len == -1 ? null : GeographyValue.unflattenFromBuffer(buf);
            }
            return retval;
        }
        if (type == VoltTable.class) {
            VoltTable[] retval = new VoltTable[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = PrivateVoltTableFactory.createVoltTableFromSharedBuffer(buf.slice());
                buf.position(buf.position() + retval[i].getSerializedSize());
            }
            return retval;
        }
        throw new RuntimeException("SerializationHelper.readArray called with unhandled type: " + type.getName());
    }

    public static int calculateSerializedSize(String value) {
        return 4 + (value == null ? 0 : value.getBytes(StandardCharsets.UTF_8).length);
    }

    public static void writeString(String value, ByteBuffer buf) {
        if (value == null) {
            buf.putInt(-1);
            return;
        }
        byte[] strbytes = value.getBytes(StandardCharsets.UTF_8);
        int len = strbytes.length;
        buf.putInt(len);
        buf.put(strbytes);
    }

    public static int calculateSerializedSize(byte[] bytes) {
        return 4 + (bytes == null ? 0 : bytes.length);
    }

    public static void writeVarbinary(byte[] bytes, ByteBuffer buf) {
        if (bytes == null) {
            buf.putInt(-1);
            return;
        }
        buf.putInt(bytes.length);
        buf.put(bytes);
    }

    public static void writeVarbinary(Byte[] bytes, ByteBuffer buf) {
        byte[] unboxedBytes = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            unboxedBytes[i] = bytes[i];
        }
        SerializationHelper.writeVarbinary(unboxedBytes, buf);
    }

    public static Byte[] boxUpByteArray(byte[] bytes) {
        Byte[] retval = new Byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            retval[i] = bytes[i];
        }
        return retval;
    }

    public static void writeArray(byte[] values, ByteBuffer buf) {
        buf.putInt(values.length);
        buf.put(values);
    }

    public static void writeArray(short[] values, ByteBuffer buf) throws IOException {
        if (values.length > Short.MAX_VALUE) {
            throw new IOException("Array exceeds maximum length of 32767 bytes");
        }
        buf.putShort((short)values.length);
        for (int i = 0; i < values.length; ++i) {
            buf.putShort(values[i]);
        }
    }

    public static void writeArray(int[] values, ByteBuffer buf) throws IOException {
        if (values.length > Short.MAX_VALUE) {
            throw new IOException("Array exceeds maximum length of 32767 bytes");
        }
        buf.putShort((short)values.length);
        for (int i = 0; i < values.length; ++i) {
            buf.putInt(values[i]);
        }
    }

    public static void writeArray(long[] values, ByteBuffer buf) throws IOException {
        if (values.length > Short.MAX_VALUE) {
            throw new IOException("Array exceeds maximum length of 32767 bytes");
        }
        buf.putShort((short)values.length);
        for (int i = 0; i < values.length; ++i) {
            buf.putLong(values[i]);
        }
    }

    public static void writeArray(double[] values, ByteBuffer buf) throws IOException {
        if (values.length > Short.MAX_VALUE) {
            throw new IOException("Array exceeds maximum length of 32767 bytes");
        }
        buf.putShort((short)values.length);
        for (int i = 0; i < values.length; ++i) {
            buf.putDouble(values[i]);
        }
    }

    public static void writeArray(TimestampType[] values, ByteBuffer buf) throws IOException {
        if (values.length > Short.MAX_VALUE) {
            throw new IOException("Array exceeds maximum length of 32767 bytes");
        }
        buf.putShort((short)values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                buf.putLong(Long.MIN_VALUE);
                continue;
            }
            buf.putLong(values[i].getTime());
        }
    }

    public static void writeArray(BigDecimal[] values, ByteBuffer buf) throws IOException {
        if (values.length > Short.MAX_VALUE) {
            throw new IOException("Array exceeds maximum length of 32767 bytes");
        }
        buf.putShort((short)values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                VoltDecimalHelper.serializeNull(buf);
                continue;
            }
            VoltDecimalHelper.serializeBigDecimal(values[i], buf);
        }
    }

    public static void writeArray(VoltTable[] values, ByteBuffer buf) throws IOException {
        if (values.length > Short.MAX_VALUE) {
            throw new IOException("Array exceeds maximum length of 32767 bytes");
        }
        buf.putShort((short)values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                throw new IOException("Array being fastserialized can't contain null values (position " + i + ")");
            }
            values[i].flattenToBuffer(buf);
        }
    }

    public static void writeArray(byte[][] values, ByteBuffer buf) throws IOException {
        if (values.length > 0x100000) {
            throw new IOException("Array exceeds maximum length of 1048576 bytes");
        }
        buf.putShort((short)values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                buf.putInt(-1);
                continue;
            }
            SerializationHelper.writeArray(values[i], buf);
        }
    }

    public static void writeArray(GeographyPointValue[] values, ByteBuffer buf) throws IOException {
        if (values.length > 0x100000) {
            throw new IOException("Array exceeds maximum length of 1048576 bytes");
        }
        buf.putShort((short)values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                GeographyPointValue.serializeNull(buf);
                continue;
            }
            values[i].flattenToBuffer(buf);
        }
    }

    public static void writeArray(GeographyValue[] values, ByteBuffer buf) throws IOException {
        if (values.length > 0x100000) {
            throw new IOException("Array exceeds maximum length of 1048576 bytes");
        }
        buf.putShort((short)values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                buf.putInt(-1);
                continue;
            }
            buf.putInt(values[i].getLengthInBytes());
            values[i].flattenToBuffer(buf);
        }
    }
}

