/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.utils;

import java.io.FileDescriptor;
import org.voltcore.logging.VoltLogger;
import org.voltdb.utils.PosixAdviseNative;

public class PosixAdvise {
    private static final VoltLogger hostLog = new VoltLogger("HOST");
    public static final boolean FALLOCATE_SUPPORTED;
    public static final boolean SYNC_FILE_RANGE_SUPPORTED;
    public static final boolean ENABLE_FADVISE_DONTNEED;
    public static final int POSIX_FADV_NORMAL = 0;
    public static final int POSIX_FADV_RANDOM = 1;
    public static final int POSIX_FADV_SEQUENTIAL = 2;
    public static final int POSIX_FADV_WILLNEED = 3;
    public static final int POSIX_FADV_DONTNEED = 4;
    public static final int SYNC_FILE_RANGE_WAIT_BEFORE = 1;
    public static final int SYNC_FILE_RANGE_WRITE = 2;
    public static final int SYNC_FILE_RANGE_WAIT_AFTER = 4;
    public static final int SYNC_FILE_RANGE_SYNC = 7;

    public static long fadvise(FileDescriptor fd, long offset, long size, int advice) {
        if (advice == 4 && !ENABLE_FADVISE_DONTNEED) {
            return 0L;
        }
        return PosixAdviseNative.nativeFadvise(fd, offset, size, advice);
    }

    static {
        SYNC_FILE_RANGE_SUPPORTED = System.getProperty("os.name").equalsIgnoreCase("linux");
        FALLOCATE_SUPPORTED = System.getProperty("os.name").equalsIgnoreCase("linux");
        ENABLE_FADVISE_DONTNEED = Boolean.getBoolean("ENABLE_FADVISE_DONTNEED");
    }
}

