/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.utils;

import com.google_voltpatches.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.voltcore.logging.VoltLogger;
import org.voltcore.utils.CoreUtils;
import org.voltdb.ClientResponseImpl;
import org.voltdb.VoltTable;
import org.voltdb.VoltType;
import org.voltdb.client.Client;
import org.voltdb.client.ClientResponse;
import org.voltdb.client.NoConnectionsException;
import org.voltdb.client.ProcCallException;
import org.voltdb.client.ProcedureCallback;
import org.voltdb.client.VoltBulkLoader.BulkLoaderSuccessCallback;
import org.voltdb.utils.BulkLoaderErrorHandler;
import org.voltdb.utils.CSVDataLoader;
import org.voltdb.utils.RowWithMetaData;

public class CSVTupleDataLoader
implements CSVDataLoader {
    private static final VoltLogger m_log = new VoltLogger("CSVLOADER");
    private final Client m_client;
    private final String m_insertProcedure;
    private final VoltType[] m_columnTypes;
    private final BulkLoaderErrorHandler m_errHandler;
    private final ExecutorService m_callbackExecutor;
    private final ExecutorService m_reinsertExecutor;
    private final boolean m_autoReconnect;
    final AtomicLong m_processedCount = new AtomicLong(0L);
    final AtomicLong m_failedCount = new AtomicLong(0L);
    final AtomicLong m_totalRowCount = new AtomicLong(0L);
    final int m_reportEveryNRows = 10000;
    final BulkLoaderSuccessCallback m_successCallback;

    @Override
    public void setFlushInterval(int delay, int seconds) {
    }

    @Override
    public void flush() {
        if (this.m_client != null) {
            try {
                this.m_client.drain();
            }
            catch (NoConnectionsException ex) {
                m_log.info("Failed to flush: " + ex);
            }
            catch (InterruptedException ex) {
                m_log.info("Failed to flush: " + ex);
            }
        }
    }

    public CSVTupleDataLoader(Client client, String procName, BulkLoaderErrorHandler errHandler) throws IOException, ProcCallException {
        this(client, procName, errHandler, null, null);
    }

    public CSVTupleDataLoader(Client client, String procName, BulkLoaderErrorHandler errHandler, ExecutorService callbackExecutor) throws IOException, ProcCallException {
        this(client, procName, errHandler, callbackExecutor, null);
    }

    public CSVTupleDataLoader(Client client, String procName, BulkLoaderErrorHandler errHandler, ExecutorService callbackExecutor, BulkLoaderSuccessCallback successCallback) throws IOException, ProcCallException {
        this.m_client = client;
        this.m_insertProcedure = procName;
        this.m_errHandler = errHandler;
        this.m_callbackExecutor = callbackExecutor;
        this.m_successCallback = successCallback;
        this.m_autoReconnect = client.isAutoReconnectEnabled();
        this.m_reinsertExecutor = this.m_autoReconnect ? CoreUtils.getSingleThreadExecutor(procName) : null;
        ArrayList<VoltType> typeList = Lists.newArrayList();
        VoltTable procInfo = client.callProcedure("@SystemCatalog", "PROCEDURECOLUMNS").getResults()[0];
        while (procInfo.advanceRow()) {
            if (!this.m_insertProcedure.equalsIgnoreCase(procInfo.getString("PROCEDURE_NAME"))) continue;
            String typeStr = (String)procInfo.get("TYPE_NAME", VoltType.STRING);
            typeList.add(VoltType.typeFromString(typeStr));
        }
        if (typeList.isEmpty()) {
            throw new RuntimeException("No matching insert procedure available");
        }
        this.m_columnTypes = typeList.toArray(new VoltType[0]);
        if (!this.m_client.waitForTopology(60000L)) {
            throw new RuntimeException("Unable to start due to uninitialized Client.");
        }
    }

    @Override
    public VoltType[] getColumnTypes() {
        return this.m_columnTypes;
    }

    @Override
    public void insertRow(RowWithMetaData metaData, Object[] values) throws InterruptedException {
        this.m_totalRowCount.incrementAndGet();
        this.insert(metaData, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(RowWithMetaData metaData, Object[] values) throws InterruptedException {
        block13: {
            if (this.m_autoReconnect) {
                while (true) {
                    Object response;
                    try {
                        PartitionSingleExecuteProcedureCallback cbmt = new PartitionSingleExecuteProcedureCallback(metaData, values);
                        if (!this.m_client.callProcedure(cbmt, this.m_insertProcedure, values)) {
                            m_log.fatal("Failed to send CSV insert to the cluster.");
                            response = new ClientResponseImpl(-5, new VoltTable[0], "Failed to call procedure.", 0L);
                            this.m_errHandler.handleError(metaData, (ClientResponse)response, "Failed to call procedure.");
                        }
                        break block13;
                    }
                    catch (IOException e) {
                        response = this;
                        synchronized (response) {
                            this.wait();
                            continue;
                        }
                    }
                    catch (Exception e) {
                        this.m_errHandler.handleError(metaData, null, e.toString());
                        continue;
                    }
                    break;
                }
            }
            try {
                PartitionSingleExecuteProcedureCallback cbmt = new PartitionSingleExecuteProcedureCallback(metaData, values);
                if (!this.m_client.callProcedure(cbmt, this.m_insertProcedure, values)) {
                    m_log.fatal("Failed to send CSV insert to the cluster.");
                    ClientResponseImpl response = new ClientResponseImpl(-5, new VoltTable[0], "Failed to call procedure.", 0L);
                    this.m_errHandler.handleError(metaData, response, "Failed to call procedure.");
                }
            }
            catch (IOException e) {
                ClientResponseImpl response = new ClientResponseImpl(-5, new VoltTable[0], "Failed to call procedure.", 0L);
                this.m_errHandler.handleError(metaData, response, "Failed to call procedure.");
            }
            catch (Exception e) {
                this.m_errHandler.handleError(metaData, null, e.toString());
            }
        }
    }

    @Override
    public void close() throws InterruptedException, NoConnectionsException {
        while (this.m_processedCount.get() != this.m_totalRowCount.get()) {
            this.m_client.drain();
            Thread.yield();
        }
        if (this.m_reinsertExecutor != null) {
            this.m_reinsertExecutor.shutdown();
            this.m_reinsertExecutor.awaitTermination(365L, TimeUnit.DAYS);
        }
    }

    @Override
    public long getProcessedRows() {
        return this.m_processedCount.get();
    }

    @Override
    public long getFailedRows() {
        return this.m_failedCount.get();
    }

    @Override
    public Map<Integer, String> getColumnNames() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeLoading() {
        CSVTupleDataLoader cSVTupleDataLoader = this;
        synchronized (cSVTupleDataLoader) {
            this.notifyAll();
        }
    }

    private class PartitionSingleExecuteProcedureCallback
    implements ProcedureCallback {
        final RowWithMetaData m_csvLine;
        final Object[] m_values;

        public PartitionSingleExecuteProcedureCallback(RowWithMetaData csvLine, Object[] values) {
            this.m_csvLine = csvLine;
            this.m_values = values;
        }

        @Override
        public void clientCallback(final ClientResponse response) throws Exception {
            long currentCount;
            byte status = response.getStatus();
            if (status == 1) {
                if (CSVTupleDataLoader.this.m_callbackExecutor != null && CSVTupleDataLoader.this.m_successCallback != null) {
                    CSVTupleDataLoader.this.m_callbackExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            CSVTupleDataLoader.this.m_successCallback.success(PartitionSingleExecuteProcedureCallback.this.m_csvLine, response);
                        }
                    });
                }
            } else {
                if (status == -4 && CSVTupleDataLoader.this.m_autoReconnect) {
                    CSVTupleDataLoader.this.m_reinsertExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                CSVTupleDataLoader.this.insert(PartitionSingleExecuteProcedureCallback.this.m_csvLine, PartitionSingleExecuteProcedureCallback.this.m_values);
                            }
                            catch (InterruptedException e) {
                                m_log.error("CSVLoader interrupted: " + e);
                            }
                        }
                    });
                    return;
                }
                CSVTupleDataLoader.this.m_failedCount.incrementAndGet();
                CSVTupleDataLoader.this.m_errHandler.handleError(this.m_csvLine, response, response.getStatusString());
            }
            if ((currentCount = CSVTupleDataLoader.this.m_processedCount.incrementAndGet()) % 10000L == 0L) {
                m_log.info("Inserted " + (currentCount - CSVTupleDataLoader.this.m_failedCount.get()) + " rows");
            }
        }
    }
}

