/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.parser;

import org.voltdb.parser.SQLPatternPart;
import org.voltdb.parser.SQLPatternPartElement;

public class SQLPatternFactory {
    static int GROUP = 1;
    static int CAPTURE = 2;
    static int OPTIONAL = 4;
    static int CASE_SENSITIVE = 8;
    static int IGNORE_NEW_LINE = 16;
    static int SINGLE_LINE = 32;
    static int LEADING_SPACE = 64;
    static int CHILD_SPACE_SEPARATOR = 128;
    static int ADD_LEADING_SPACE_TO_CHILD = 256;

    private static SQLPatternPart makeGroup(boolean capture, String captureLabel, SQLPatternPart part) {
        SQLPatternPart retPart;
        boolean alreadyGroup = (part.m_flags & (GROUP | CAPTURE)) != 0;
        SQLPatternPart sQLPatternPart = retPart = alreadyGroup ? new SQLPatternPartElement(part) : part;
        if (capture) {
            retPart.m_flags |= CAPTURE;
            retPart.setCaptureLabel(captureLabel);
        } else {
            retPart.m_flags |= GROUP;
        }
        return retPart;
    }

    private static SQLPatternPartElement makeStatementPart(boolean beginLine, boolean endLine, boolean terminated, boolean terminatorRequired, SQLPatternPart ... parts) {
        SQLPatternPartElement retElem = new SQLPatternPartElement(parts);
        retElem.m_leader = beginLine ? "\\A\\s*" : "\\A.*?";
        retElem.m_trailer = endLine ? (terminated ? (terminatorRequired ? "\\s*;\\s*\\z" : "\\s*;?\\s*\\z") : "\\s*\\z") : ".*\\z";
        retElem.m_flags |= CHILD_SPACE_SEPARATOR;
        return retElem;
    }

    public static class SPF {
        public static SQLPatternPart statement(SQLPatternPart ... parts) {
            return SQLPatternFactory.makeStatementPart(true, true, true, true, parts);
        }

        public static SQLPatternPart statementLeader(SQLPatternPart ... parts) {
            return SQLPatternFactory.makeStatementPart(true, false, false, false, parts);
        }

        public static SQLPatternPart statementTrailer(SQLPatternPart ... parts) {
            return SQLPatternFactory.makeStatementPart(false, true, true, false, parts);
        }

        public static SQLPatternPart clause(SQLPatternPart ... parts) {
            SQLPatternPartElement retElem = new SQLPatternPartElement(parts);
            retElem.m_flags |= GROUP;
            retElem.m_flags |= CHILD_SPACE_SEPARATOR;
            return retElem;
        }

        public static SQLPatternPart anyClause() {
            return new SQLPatternPartElement(".+");
        }

        public static SQLPatternPart group(SQLPatternPart part) {
            return SQLPatternFactory.makeGroup(false, null, part);
        }

        public static SQLPatternPart group(boolean capture, SQLPatternPart part) {
            return SQLPatternFactory.makeGroup(capture, null, part);
        }

        public static SQLPatternPart group(boolean capture, String captureLabel, SQLPatternPart part) {
            return SQLPatternFactory.makeGroup(capture, captureLabel, part);
        }

        public static SQLPatternPart capture(SQLPatternPart part) {
            return SQLPatternFactory.makeGroup(true, null, part);
        }

        public static SQLPatternPart capture(String captureLabel, SQLPatternPart part) {
            return SQLPatternFactory.makeGroup(true, captureLabel, part);
        }

        public static SQLPatternPart optional(SQLPatternPart ... parts) {
            return SPF.optional(SPF.clause(parts));
        }

        public static SQLPatternPart optional(SQLPatternPart part) {
            part.m_flags |= OPTIONAL;
            return part;
        }

        public static SQLPatternPart optionalCapture(String label, SQLPatternPart ... parts) {
            return SPF.optional(SPF.capture(label, parts.length == 1 ? parts[0] : SPF.clause(parts)));
        }

        public static SQLPatternPart oneOf(SQLPatternPart ... parts) {
            SQLPatternPartElement retElem = new SQLPatternPartElement(parts);
            retElem.m_flags |= GROUP;
            retElem.m_separator = "|";
            return retElem;
        }

        public static SQLPatternPart oneOf(String ... strs) {
            SQLPatternPartElement retElem = new SQLPatternPartElement(strs);
            retElem.m_flags |= GROUP;
            retElem.m_separator = "|";
            return retElem;
        }

        public static SQLPatternPart token(String str) {
            return new SQLPatternPartElement(str);
        }

        public static SQLPatternPart dot() {
            return new SQLPatternPartElement("\\.");
        }

        public static SQLPatternPart tokenAlternatives(String ... strs) {
            return SPF.oneOf(strs);
        }

        public static SQLPatternPart databaseObjectName() {
            return new SQLPatternPartElement("[\\w$]+");
        }

        public static SQLPatternPart databaseObjectTypeName() {
            return new SQLPatternPartElement("[a-z][a-z]*");
        }

        public static SQLPatternPart procedureName() {
            return new SQLPatternPartElement("[\\w.$]+");
        }

        public static SQLPatternPart functionName() {
            return new SQLPatternPartElement("[\\w$]+");
        }

        public static SQLPatternPart classPath() {
            return new SQLPatternPartElement("(?:\\w+\\.)*\\w+");
        }

        public static SQLPatternPart languageName() {
            return new SQLPatternPartElement("[\\w.$]+");
        }

        public static SQLPatternPart userName() {
            return new SQLPatternPartElement("[\\w.$]+");
        }

        public static SQLPatternPart className() {
            return new SQLPatternPartElement("[\\w.$]+");
        }

        public static SQLPatternPart databaseTrigger() {
            return new SQLPatternPartElement("[\\w.$]+");
        }

        public static SQLPatternPart anythingOrNothing() {
            return new SQLPatternPartElement(".*");
        }

        public static SQLPatternPart integer() {
            return new SQLPatternPartElement("\\d+");
        }

        public static SQLPatternPart ifExists() {
            return SPF.optional(SPF.capture("ifExists", SPF.clause(SPF.token("if"), SPF.token("exists"))));
        }

        public static SQLPatternPart commaList(SQLPatternPart part) {
            String itemExpr = part.generateExpression(0);
            String listExpr = String.format("%s(?:\\s*,\\s*%s)*", itemExpr, itemExpr);
            return new SQLPatternPartElement(listExpr);
        }

        public static SQLPatternPart delimitedCaptureBlock(String delimiter, String captureLabel) {
            return new SQLPatternPartElement(new SQLPatternPartElement(delimiter), SQLPatternFactory.makeGroup(true, captureLabel, SPF.anyClause()), new SQLPatternPartElement(delimiter));
        }

        public static SQLPatternPart repeat(SQLPatternPart part) {
            return SPF.repeat(0, null, part);
        }

        public static SQLPatternPart repeat(int minCount, Integer maxCount, SQLPatternPart part) {
            SQLPatternPartElement retElem;
            assert (minCount >= 0);
            assert (maxCount == null || maxCount > 0 && maxCount >= minCount);
            SQLPatternPartElement retPart = retElem = new SQLPatternPartElement(part);
            retElem.m_flags |= GROUP;
            retElem.m_trailer = maxCount != null ? String.format("{%d,%d}", minCount, maxCount) : (minCount <= 0 ? String.format("*", minCount) : (minCount == 1 ? String.format("+", minCount) : String.format("{%d,}", minCount)));
            return retPart;
        }

        public static SQLPatternPart anyColumnFields() {
            return new SQLPatternPartElement("\\((?:.+?)\\)");
        }
    }
}

