/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.messaging;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.voltcore.memory.DBBPool;
import org.voltdb.ParameterSet;
import org.voltdb.VoltTable;
import org.voltdb.messaging.FastSerializable;
import org.voltdb.types.TimestampType;
import org.voltdb.types.VoltDecimalHelper;
import org.voltdb.utils.Encoder;
import org.voltdb.utils.SerializationHelper;

public class FastSerializer
extends OutputStream
implements DataOutput {
    public static final int INITIAL_ALLOCATION = 2048;
    private DBBPool.BBContainer buffer;
    private final BufferGrowCallback callback;
    private final boolean isDirect;

    public FastSerializer() {
        this(true, false);
    }

    public FastSerializer(int initialAllocation) {
        this(true, false, null, initialAllocation);
    }

    public FastSerializer(boolean bigEndian, boolean isDirect) {
        this(bigEndian, isDirect, null, 2048);
    }

    public FastSerializer(boolean bigEndian, BufferGrowCallback callback) {
        this(bigEndian, true, callback, 2048);
    }

    public FastSerializer(boolean bigEndian, boolean isDirect, BufferGrowCallback callback, int initialAllocation) {
        assert (initialAllocation > 0);
        this.isDirect = isDirect;
        this.buffer = isDirect ? DBBPool.allocateDirect(initialAllocation) : DBBPool.wrapBB(ByteBuffer.allocate(initialAllocation));
        this.callback = callback;
        this.buffer.b().order(bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
    }

    public int size() {
        return this.buffer.b().position();
    }

    public void clear() {
        this.buffer.b().clear();
    }

    private final void growIfNeeded(int minimumDesired) {
        if (this.buffer.b().remaining() < minimumDesired) {
            int newCapacity = this.buffer.b().capacity();
            int newRemaining = newCapacity - this.buffer.b().position();
            while (newRemaining < minimumDesired) {
                newRemaining += newCapacity;
                newCapacity *= 2;
            }
            DBBPool.BBContainer next = this.isDirect ? DBBPool.allocateDirect(newCapacity) : DBBPool.wrapBB(ByteBuffer.allocate(newCapacity));
            next.b().order(this.buffer.b().order());
            this.buffer.b().flip();
            next.b().put(this.buffer.b());
            assert (next.b().remaining() == newRemaining);
            this.buffer.discard();
            this.buffer = next;
            if (this.callback != null) {
                this.callback.onBufferGrow(this);
            }
        }
    }

    public static byte[] serialize(FastSerializable object) throws IOException {
        FastSerializer out = new FastSerializer();
        object.writeExternal(out);
        return out.getBBContainer().b().array();
    }

    public DBBPool.BBContainer getBBContainer() {
        this.buffer.b().flip();
        return this.buffer;
    }

    public byte[] getBytes() {
        ByteBuffer b = this.buffer.b();
        int position = b.position();
        byte[] retval = new byte[position];
        b.rewind();
        b.get(retval);
        assert (position == b.position());
        return retval;
    }

    public ByteBuffer getBuffer() {
        assert (!this.isDirect);
        assert (this.buffer.b().hasArray());
        assert (!this.buffer.b().isDirect());
        this.buffer.b().flip();
        return this.buffer.b().asReadOnlyBuffer().order(this.buffer.b().order());
    }

    public DBBPool.BBContainer getContainerNoFlip() {
        return this.buffer;
    }

    public String getHexEncodedBytes() {
        this.buffer.b().flip();
        byte[] bytes = new byte[this.buffer.b().remaining()];
        this.buffer.b().get(bytes);
        String hex = Encoder.hexEncode(bytes);
        this.buffer.discard();
        return hex;
    }

    public void writeObject(FastSerializable obj) throws IOException {
        obj.writeExternal(this);
    }

    public static void writeString(String string, ByteBuffer buffer) {
        if (string == null) {
            buffer.putInt(-1);
            return;
        }
        byte[] strbytes = string.getBytes(StandardCharsets.UTF_8);
        int len = strbytes.length;
        buffer.putInt(len);
        buffer.put(strbytes);
    }

    public void writeString(String string) {
        if (string == null) {
            this.writeInt(-1);
            return;
        }
        byte[] strbytes = string.getBytes(StandardCharsets.UTF_8);
        int len = strbytes.length;
        this.writeInt(len);
        this.write(strbytes);
    }

    public void writeVarbinary(byte[] bin) throws IOException {
        if (bin == null) {
            this.writeInt(-1);
            return;
        }
        if (bin.length > 0x100000) {
            throw new IOException("Varbinary exceeds maximum length of 1048576 bytes.");
        }
        this.writeInt(bin.length);
        this.write(bin);
    }

    public void writeTable(VoltTable table) {
        int len = table.getSerializedSize();
        this.growIfNeeded(len);
        table.flattenToBuffer(this.buffer.b());
    }

    public void writeParameterSet(ParameterSet params) throws IOException {
        int len = params.getSerializedSize();
        this.growIfNeeded(len);
        params.flattenToBuffer(this.buffer.b());
    }

    public void writeBigDecimal(BigDecimal bigDecimal) {
        this.growIfNeeded(16);
        if (bigDecimal == null) {
            VoltDecimalHelper.serializeNull(this.buffer.b());
        } else {
            VoltDecimalHelper.serializeBigDecimal(bigDecimal, this.buffer.b());
        }
    }

    public static void writeArray(VoltTable[] values, ByteBuffer buf) throws IOException {
        if (values.length > Short.MAX_VALUE) {
            throw new IOException("Array exceeds maximum length of 32767 bytes");
        }
        buf.putShort((short)values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                throw new IOException("Array being fastserialized can't contain null values (position " + i + ")");
            }
            values[i].flattenToBuffer(buf);
        }
    }

    public static void writeArray(byte[][] values, ByteBuffer buf) throws IOException {
        if (values.length > Short.MAX_VALUE) {
            throw new IOException("Array exceeds maximum length of 32767 bytes");
        }
        buf.putShort((short)values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                buf.putInt(-1);
                continue;
            }
            SerializationHelper.writeArray(values[i], buf);
        }
    }

    public void writeArray(FastSerializable[] values) throws IOException {
        if (values.length > Short.MAX_VALUE) {
            throw new IOException("Array exceeds maximum length of 32767 bytes");
        }
        this.writeShort(values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                throw new IOException("Array being fastserialized can't contain null values (position " + i + ")");
            }
            this.writeObject(values[i]);
        }
    }

    public void writeArray(byte[][] values) throws IOException {
        if (values.length > 0x100000) {
            throw new IOException("Array exceeds maximum length of 1048576 bytes");
        }
        this.writeShort(values.length);
        for (int i = 0; i < values.length; ++i) {
            this.writeArray(values[i]);
        }
    }

    public void writeArray(byte[] values) throws IOException {
        if (values == null) {
            this.writeInt(-1);
        } else {
            if (values.length > 0x100000) {
                throw new IOException("Array exceeds maximum length of 1048576 bytes");
            }
            this.writeInt(values.length);
            this.write(values);
        }
    }

    public void writeArray(short[] values) throws IOException {
        if (values.length > Short.MAX_VALUE) {
            throw new IOException("Array exceeds maximum length of 32767 bytes");
        }
        this.writeShort(values.length);
        for (int i = 0; i < values.length; ++i) {
            this.writeShort(values[i]);
        }
    }

    public void writeArray(int[] values) throws IOException {
        if (values.length > Short.MAX_VALUE) {
            throw new IOException("Array exceeds maximum length of 32767 bytes");
        }
        this.writeShort(values.length);
        for (int i = 0; i < values.length; ++i) {
            this.writeInt(values[i]);
        }
    }

    public void writeArray(long[] values) throws IOException {
        if (values.length > Short.MAX_VALUE) {
            throw new IOException("Array exceeds maximum length of 32767 bytes");
        }
        this.writeShort(values.length);
        for (int i = 0; i < values.length; ++i) {
            this.writeLong(values[i]);
        }
    }

    public void writeArray(double[] values) throws IOException {
        if (values.length > Short.MAX_VALUE) {
            throw new IOException("Array exceeds maximum length of 32767 bytes");
        }
        this.writeShort(values.length);
        for (int i = 0; i < values.length; ++i) {
            this.writeDouble(values[i]);
        }
    }

    public void writeArray(String[] values) throws IOException {
        if (values.length > Short.MAX_VALUE) {
            throw new IOException("Array exceeds maximum length of 32767 bytes");
        }
        this.writeShort(values.length);
        for (int i = 0; i < values.length; ++i) {
            this.writeString(values[i]);
        }
    }

    public void writeArray(TimestampType[] values) throws IOException {
        if (values.length > Short.MAX_VALUE) {
            throw new IOException("Array exceeds maximum length of 32767 bytes");
        }
        this.writeShort(values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                this.writeLong(Long.MIN_VALUE);
                continue;
            }
            this.writeLong(values[i].getTime());
        }
    }

    public void writeArray(BigDecimal[] values) throws IOException {
        if (values.length > Short.MAX_VALUE) {
            throw new IOException("Array exceeds maximum length of 32767 bytes");
        }
        this.writeShort(values.length);
        for (int i = 0; i < values.length; ++i) {
            this.writeBigDecimal(values[i]);
        }
    }

    @Override
    public void write(int b) {
        this.writeByte((byte)b);
    }

    @Override
    public void write(byte[] b) {
        this.growIfNeeded(b.length);
        this.buffer.b().put(b);
    }

    public void write(ByteBuffer b) {
        this.growIfNeeded(b.limit() - b.position());
        this.buffer.b().put(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.growIfNeeded(len);
        this.buffer.b().put(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) {
        this.writeByte((byte)(v ? 1 : 0));
    }

    @Override
    public void writeByte(int v) {
        this.growIfNeeded(1);
        this.buffer.b().put((byte)v);
    }

    @Override
    public void writeBytes(String s) {
        throw new UnsupportedOperationException("FastSerializer.writeBytes() not supported.");
    }

    @Override
    public void writeChar(int v) {
        this.growIfNeeded(2);
        this.buffer.b().putChar((char)v);
    }

    @Override
    public void writeChars(String s) {
        throw new UnsupportedOperationException("FastSerializer.writeChars() not supported.");
    }

    @Override
    public void writeDouble(double v) {
        this.growIfNeeded(8);
        this.buffer.b().putDouble(v);
    }

    @Override
    public void writeFloat(float v) {
        this.growIfNeeded(4);
        this.buffer.b().putFloat(v);
    }

    @Override
    public void writeInt(int v) {
        this.growIfNeeded(4);
        this.buffer.b().putInt(v);
    }

    @Override
    public void writeLong(long v) {
        this.growIfNeeded(8);
        this.buffer.b().putLong(v);
    }

    @Override
    public void writeShort(int v) {
        this.growIfNeeded(2);
        this.buffer.b().putShort((short)v);
    }

    @Override
    public void writeUTF(String str) {
        throw new UnsupportedOperationException("FastSerializer.writeChars() not supported.");
    }

    public int getPosition() {
        return this.buffer.b().position();
    }

    public void setPosition(int pos) {
        int currentPosition = this.getPosition();
        if (currentPosition < pos) {
            this.growIfNeeded(pos - currentPosition);
        }
        this.buffer.b().position(pos);
    }

    public static void writeString(byte[] m_procNameBytes, ByteBuffer buf) {
        if (m_procNameBytes == null) {
            buf.putInt(-1);
            return;
        }
        buf.putInt(m_procNameBytes.length);
        buf.put(m_procNameBytes);
    }

    public void discard() {
        this.buffer.discard();
    }

    @Override
    public void close() throws IOException {
        this.discard();
    }

    public static interface BufferGrowCallback {
        public void onBufferGrow(FastSerializer var1);
    }
}

