/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.messaging;

import java.io.DataInput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.voltdb.messaging.FastSerializable;
import org.voltdb.types.TimestampType;
import org.voltdb.types.VoltDecimalHelper;

public class FastDeserializer
implements DataInput {
    private final ByteBuffer buffer;

    public FastDeserializer(byte[] in) {
        this.buffer = ByteBuffer.wrap(in);
        assert (this.buffer.order() == ByteOrder.BIG_ENDIAN);
    }

    public FastDeserializer(byte[] in, ByteOrder order) {
        this.buffer = ByteBuffer.wrap(in);
        this.buffer.order(order);
    }

    public FastDeserializer(ByteBuffer in) {
        this.buffer = in;
        assert (this.buffer.order() == ByteOrder.BIG_ENDIAN);
    }

    public void clear() {
        this.buffer.clear();
        this.buffer.putInt(0, 0);
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    public ByteBuffer remainder() {
        return this.buffer.slice();
    }

    public static final <T extends FastSerializable> T deserialize(byte[] data, Class<T> expectedType) throws IOException {
        FastDeserializer in = new FastDeserializer(data);
        return in.readObject(expectedType);
    }

    public <T extends FastSerializable> T readObject(Class<T> expectedType) throws IOException {
        assert (expectedType != null);
        FastSerializable obj = null;
        try {
            obj = (FastSerializable)expectedType.newInstance();
            obj.readExternal(this);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return (T)obj;
    }

    public FastSerializable readObject(FastSerializable obj, DeserializationMonitor monitor) throws IOException {
        int startPosition = this.buffer.position();
        obj.readExternal(this);
        int endPosition = this.buffer.position();
        if (monitor != null) {
            monitor.deserializedBytes(endPosition - startPosition);
        }
        return obj;
    }

    public static String readString(ByteBuffer buffer) throws IOException {
        int NULL_STRING_INDICATOR = -1;
        int len = buffer.getInt();
        if (len == -1) {
            return null;
        }
        assert (len >= 0);
        if (len > 0x100000) {
            throw new IOException("Serializable strings cannot be longer then 1048576 bytes");
        }
        if (len < -1) {
            throw new IOException("String length is negative " + len);
        }
        byte[] strbytes = new byte[len];
        buffer.get(strbytes);
        return new String(strbytes, StandardCharsets.UTF_8);
    }

    public String readString() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        if (len < -1) {
            throw new IOException("String length is negative " + len);
        }
        if (len > this.buffer.remaining()) {
            throw new IOException("String length is bigger than total buffer " + len);
        }
        byte[] strbytes = new byte[len];
        this.readFully(strbytes);
        return new String(strbytes, StandardCharsets.UTF_8);
    }

    public byte[] readVarbinary() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        assert (len >= 0);
        if (len < -1) {
            throw new IOException("Varbinary length is negative " + len);
        }
        if (len > this.buffer.remaining()) {
            throw new IOException("Varbinary length is bigger than total buffer " + len);
        }
        byte[] retval = new byte[len];
        this.readFully(retval);
        return retval;
    }

    public BigDecimal readBigDecimal() throws IOException {
        return VoltDecimalHelper.deserializeBigDecimal(this.buffer);
    }

    public BigDecimal readBigDecimalFromString() throws IOException {
        return VoltDecimalHelper.deserializeBigDecimalFromString(this.readString());
    }

    public Object readArray(Class<?> type) throws IOException {
        int count;
        int n = count = type == Byte.TYPE ? this.readInt() : (int)this.readShort();
        if (count < 0) {
            throw new IOException("Array length is negative " + count);
        }
        if (type == Byte.TYPE && count > 0x100000) {
            throw new IOException("Array length is greater then the max of 1 megabyte " + count);
        }
        if (type == Byte.TYPE) {
            byte[] retval = new byte[count];
            this.readFully(retval);
            return retval;
        }
        if (type == byte[].class) {
            byte[][] retval = new byte[count][];
            for (int i = 0; i < count; ++i) {
                int size = this.readInt();
                if (size == -1) {
                    retval[i] = null;
                    continue;
                }
                retval[i] = new byte[size];
                this.readFully(retval[i]);
            }
            return retval;
        }
        if (type == Short.TYPE) {
            short[] retval = new short[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = this.readShort();
            }
            return retval;
        }
        if (type == Integer.TYPE) {
            int[] retval = new int[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = this.readInt();
            }
            return retval;
        }
        if (type == Long.TYPE) {
            long[] retval = new long[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = this.readLong();
            }
            return retval;
        }
        if (type == Long.class) {
            Long[] retval = new Long[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = this.readLong();
            }
            return retval;
        }
        if (type == String.class) {
            String[] retval = new String[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = this.readString();
            }
            return retval;
        }
        if (type == Double.TYPE) {
            double[] retval = new double[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = this.readDouble();
            }
            return retval;
        }
        if (type == Double.class) {
            Double[] retval = new Double[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = this.readDouble();
            }
            return retval;
        }
        if (type == TimestampType.class) {
            TimestampType[] retval = new TimestampType[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = new TimestampType(this.readLong());
            }
            return retval;
        }
        if (type == BigDecimal.class) {
            BigDecimal[] retval = new BigDecimal[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = this.readBigDecimal();
            }
            return retval;
        }
        Class<?> cls = type;
        FastSerializable[] retval = (FastSerializable[])Array.newInstance(type, count);
        for (int i = 0; i < count; ++i) {
            retval[i] = this.readObject(cls);
        }
        return retval;
    }

    public ByteBuffer readBuffer(int byteLen) {
        byte[] data = new byte[byteLen];
        this.buffer.get(data);
        return ByteBuffer.wrap(data);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.buffer.get() > 0;
    }

    @Override
    public byte readByte() throws IOException {
        return this.buffer.get();
    }

    @Override
    public char readChar() throws IOException {
        return this.buffer.getChar();
    }

    @Override
    public double readDouble() throws IOException {
        return this.buffer.getDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.buffer.getFloat();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.buffer.get(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.buffer.get(b, off, len);
    }

    @Override
    public int readInt() throws IOException {
        return this.buffer.getInt();
    }

    @Override
    public String readLine() throws IOException {
        throw new RuntimeException("FastDeserializer.readLine() not supported.");
    }

    @Override
    public long readLong() throws IOException {
        return this.buffer.getLong();
    }

    @Override
    public short readShort() throws IOException {
        return this.buffer.getShort();
    }

    @Override
    public String readUTF() throws IOException {
        throw new RuntimeException("FastDeserializer.readUTF() not supported.");
    }

    @Override
    public int readUnsignedByte() throws IOException {
        throw new RuntimeException("FastDeserializer.readUnsignedByte() not supported.");
    }

    @Override
    public int readUnsignedShort() throws IOException {
        throw new RuntimeException("FastDeserializer.readUnsignedShort() not supported.");
    }

    @Override
    public int skipBytes(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.readByte();
        }
        return n;
    }

    public int getPosition() {
        return this.buffer.position();
    }

    public void setPosition(int pos) {
        this.buffer.position(pos);
    }

    public static interface DeserializationMonitor {
        public void deserializedBytes(int var1);
    }
}

