/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import org.voltdb.VoltTable;
import org.voltdb.VoltType;
import org.voltdb.jdbc.JDBC4NClob;
import org.voltdb.jdbc.JDBC4ResultSetMetaData;
import org.voltdb.jdbc.SQLError;
import org.voltdb.utils.Encoder;

public class JDBC4ResultSet
implements ResultSet {
    private final Statement statement;
    protected VoltTable table;
    protected int columnCount;
    private int fetchDirection = 1000;
    private int fetchSize = 0;
    private int rowCount;
    private Position cursorPosition = Position.beforeFirst;

    public JDBC4ResultSet(Statement sourceStatement, VoltTable sourceTable) throws SQLException {
        this.statement = sourceStatement;
        this.table = sourceTable;
        this.rowCount = this.table.getRowCount();
        try {
            this.columnCount = this.table.getColumnCount();
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    protected final void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw SQLError.get("08003");
        }
    }

    protected final synchronized void checkColumnBounds(int columnIndex) throws SQLException {
        this.checkClosed();
        if (columnIndex < 1 || columnIndex > this.columnCount) {
            throw SQLError.get("42S22", columnIndex, this.columnCount);
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkClosed();
        if (this.rowCount == 0) {
            return row == 0;
        }
        if (row == 0) {
            this.beforeFirst();
            return true;
        }
        if (this.rowCount + row < 0) {
            this.beforeFirst();
            return false;
        }
        if (row > this.rowCount) {
            this.cursorPosition = Position.afterLast;
            return row == this.rowCount + 1;
        }
        try {
            if (row < 0) {
                row += this.rowCount;
                ++row;
            }
            if (this.table.getActiveRowIndex() > row || this.cursorPosition != Position.middle) {
                this.table.resetRowPosition();
                this.table.advanceToRow(0);
            }
            this.cursorPosition = Position.middle;
            return this.table.advanceToRow(row - 1);
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkClosed();
        this.cursorPosition = Position.afterLast;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkClosed();
        this.cursorPosition = Position.beforeFirst;
        this.table.resetRowPosition();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void close() throws SQLException {
        this.table = null;
    }

    @Override
    public void deleteRow() throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkClosed();
        try {
            return this.table.getColumnIndex(columnLabel) + 1;
        }
        catch (IllegalArgumentException iax) {
            throw SQLError.get(iax, "42S22", columnLabel);
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public boolean first() throws SQLException {
        this.checkClosed();
        if (this.rowCount == 0) {
            return false;
        }
        if (this.cursorPosition != Position.middle) {
            this.cursorPosition = Position.middle;
        }
        try {
            if (this.table.getActiveRowIndex() != 0) {
                this.table.resetRowPosition();
            }
            return this.table.advanceToRow(0);
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        throw SQLError.noSupport();
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        try {
            return new ByteArrayInputStream(this.table.getStringAsBytes(columnIndex - 1));
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        try {
            VoltType type = this.table.getColumnType(columnIndex - 1);
            BigDecimal decimalValue = null;
            switch (type) {
                case TINYINT: {
                    decimalValue = new BigDecimal(this.table.getLong(columnIndex - 1));
                    break;
                }
                case SMALLINT: {
                    decimalValue = new BigDecimal(this.table.getLong(columnIndex - 1));
                    break;
                }
                case INTEGER: {
                    decimalValue = new BigDecimal(this.table.getLong(columnIndex - 1));
                    break;
                }
                case BIGINT: {
                    decimalValue = new BigDecimal(this.table.getLong(columnIndex - 1));
                    break;
                }
                case FLOAT: {
                    decimalValue = new BigDecimal(this.table.getDouble(columnIndex - 1));
                    break;
                }
                case DECIMAL: {
                    decimalValue = this.table.getDecimalAsBigDecimal(columnIndex - 1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot get BigDecimal value for column type '" + type + "'");
                }
            }
            return this.table.wasNull() ? null : decimalValue;
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.checkColumnBounds(columnIndex);
        throw SQLError.noSupport();
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        try {
            return new ByteArrayInputStream(this.table.getStringAsBytes(columnIndex - 1));
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        try {
            return new SerialBlob(this.table.getStringAsBytes(columnIndex - 1));
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    private Long getPrivateInteger(int columnIndex) throws SQLException {
        VoltType type = this.table.getColumnType(columnIndex - 1);
        Long longValue = null;
        switch (type) {
            case TINYINT: {
                longValue = this.table.getLong(columnIndex - 1);
                break;
            }
            case SMALLINT: {
                longValue = this.table.getLong(columnIndex - 1);
                break;
            }
            case INTEGER: {
                longValue = this.table.getLong(columnIndex - 1);
                break;
            }
            case BIGINT: {
                longValue = this.table.getLong(columnIndex - 1);
                break;
            }
            case FLOAT: {
                Double retDouble = this.table.getDouble(columnIndex - 1);
                if (retDouble.equals(Math.ceil(retDouble))) {
                    longValue = retDouble.longValue();
                    break;
                }
                throw new IllegalArgumentException("Cannot get integer value from: " + retDouble);
            }
            case DECIMAL: {
                BigDecimal retDec = this.table.getDecimalAsBigDecimal(columnIndex - 1);
                if (retDec == null) break;
                try {
                    longValue = retDec.longValueExact();
                    break;
                }
                catch (ArithmeticException e) {
                    throw new IllegalArgumentException("Cannot get integer value from: " + retDec.toString());
                }
            }
            default: {
                throw new IllegalArgumentException("Cannot get integer value for column type '" + type + "'");
            }
        }
        return this.table.wasNull() ? 0L : longValue;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        try {
            return Long.valueOf(this.table.getLong(columnIndex - 1)).intValue() == 1;
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        try {
            Long longValue = this.getPrivateInteger(columnIndex);
            if (longValue > 127L || longValue < -128L) {
                throw new SQLException("Value out of byte range");
            }
            return longValue.byteValue();
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        try {
            if (this.table.getColumnType(columnIndex - 1) == VoltType.STRING) {
                return this.table.getStringAsBytes(columnIndex - 1);
            }
            if (this.table.getColumnType(columnIndex - 1) == VoltType.VARBINARY) {
                return this.table.getVarbinary(columnIndex - 1);
            }
            throw SQLError.get("42S72", new Object[]{this.table.getColumnType(columnIndex - 1), "byte[]"});
        }
        catch (SQLException x) {
            throw x;
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        try {
            String value = this.table.getString(columnIndex - 1);
            if (!this.wasNull()) {
                return new StringReader(value);
            }
            return null;
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        try {
            return new SerialClob(this.table.getString(columnIndex - 1).toCharArray());
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.findColumn(columnLabel));
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public String getCursorName() throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        try {
            Timestamp ts = this.table.getTimestampAsSqlTimestamp(columnIndex - 1);
            Date result = null;
            if (ts != null) {
                result = new Date(ts.getTime());
            }
            return result;
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.checkColumnBounds(columnIndex);
        throw SQLError.noSupport();
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        try {
            VoltType type = this.table.getColumnType(columnIndex - 1);
            Double doubleValue = null;
            switch (type) {
                case TINYINT: {
                    doubleValue = this.table.getLong(columnIndex - 1);
                    break;
                }
                case SMALLINT: {
                    doubleValue = this.table.getLong(columnIndex - 1);
                    break;
                }
                case INTEGER: {
                    doubleValue = this.table.getLong(columnIndex - 1);
                    break;
                }
                case BIGINT: {
                    doubleValue = this.table.getLong(columnIndex - 1);
                    break;
                }
                case FLOAT: {
                    doubleValue = this.table.getDouble(columnIndex - 1);
                    break;
                }
                case DECIMAL: {
                    doubleValue = this.table.getDecimalAsBigDecimal(columnIndex - 1).doubleValue();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot get double value for column type '" + type + "'");
                }
            }
            return this.table.wasNull() ? 0.0 : doubleValue;
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        try {
            VoltType type = this.table.getColumnType(columnIndex - 1);
            Double doubleValue = null;
            switch (type) {
                case TINYINT: {
                    doubleValue = this.table.getLong(columnIndex - 1);
                    break;
                }
                case SMALLINT: {
                    doubleValue = this.table.getLong(columnIndex - 1);
                    break;
                }
                case INTEGER: {
                    doubleValue = this.table.getLong(columnIndex - 1);
                    break;
                }
                case BIGINT: {
                    doubleValue = this.table.getLong(columnIndex - 1);
                    break;
                }
                case FLOAT: {
                    doubleValue = this.table.getDouble(columnIndex - 1);
                    break;
                }
                case DECIMAL: {
                    doubleValue = this.table.getDecimalAsBigDecimal(columnIndex - 1).doubleValue();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot get float value for column type '" + type + "'");
                }
            }
            if (this.table.wasNull()) {
                doubleValue = 0.0;
            } else if (Math.abs(doubleValue) > 3.4028234663852886E38) {
                throw new SQLException("Value out of float range");
            }
            return doubleValue.floatValue();
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public int getHoldability() throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        try {
            Long longValue = this.getPrivateInteger(columnIndex);
            if (longValue > Integer.MAX_VALUE || longValue < Integer.MIN_VALUE) {
                throw new SQLException("Value out of int range");
            }
            return longValue.intValue();
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        try {
            Long longValue = this.getPrivateInteger(columnIndex);
            return longValue;
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new JDBC4ResultSetMetaData(this);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        try {
            String value = this.table.getString(columnIndex - 1);
            if (!this.wasNull()) {
                return new StringReader(value);
            }
            return null;
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getNCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        try {
            return new JDBC4NClob(this.table.getString(columnIndex - 1).toCharArray());
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getNClob(this.findColumn(columnLabel));
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        try {
            return this.table.getString(columnIndex - 1);
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getNString(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        try {
            VoltType type = this.table.getColumnType(columnIndex - 1);
            if (type == VoltType.TIMESTAMP) {
                return this.getTimestamp(columnIndex);
            }
            return this.table.get(columnIndex - 1, type);
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        this.checkColumnBounds(columnIndex);
        return this.getObject(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), map);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        throw SQLError.noSupport();
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return this.getRef(this.findColumn(columnLabel));
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClosed();
        if (this.cursorPosition != Position.middle) {
            return 0;
        }
        try {
            return this.table.getActiveRowIndex() + 1;
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        throw SQLError.noSupport();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.getRowId(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        try {
            Long longValue = this.getPrivateInteger(columnIndex);
            if (longValue > 32767L || longValue < -32768L) {
                throw new SQLException("Value out of short range");
            }
            return longValue.shortValue();
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        throw SQLError.noSupport();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.getSQLXML(this.findColumn(columnLabel));
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        try {
            VoltType type = this.table.getColumnType(columnIndex - 1);
            if (type == VoltType.STRING) {
                return this.table.getString(columnIndex - 1);
            }
            if (type == VoltType.TIMESTAMP) {
                return this.getTimestamp(columnIndex).toString();
            }
            if (type == VoltType.VARBINARY) {
                return Encoder.hexEncode(this.table.getVarbinary(columnIndex - 1));
            }
            return this.table.get(columnIndex - 1, type).toString();
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        try {
            Timestamp ts = this.table.getTimestampAsSqlTimestamp(columnIndex - 1);
            Time result = null;
            if (ts != null) {
                result = new Time(ts.getTime());
            }
            return result;
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.checkColumnBounds(columnIndex);
        throw SQLError.noSupport();
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        try {
            Timestamp result = this.table.getTimestampAsSqlTimestamp(columnIndex - 1);
            return result;
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.checkColumnBounds(columnIndex);
        throw SQLError.noSupport();
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public int getType() throws SQLException {
        return 1004;
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        throw SQLError.noSupport();
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        try {
            return new URL(this.table.getString(columnIndex - 1));
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.findColumn(columnLabel));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void insertRow() throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClosed();
        return this.cursorPosition == Position.afterLast;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        return this.cursorPosition == Position.beforeFirst;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.table == null;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClosed();
        if (this.cursorPosition != Position.middle) {
            return false;
        }
        try {
            return this.table.getActiveRowIndex() == 0;
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClosed();
        if (this.cursorPosition != Position.middle) {
            return false;
        }
        try {
            return this.table.getActiveRowIndex() == this.rowCount - 1;
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public boolean last() throws SQLException {
        this.checkClosed();
        if (this.rowCount == 0) {
            return false;
        }
        try {
            if (this.cursorPosition != Position.middle) {
                this.cursorPosition = Position.middle;
                this.table.resetRowPosition();
                this.table.advanceToRow(0);
            }
            return this.table.advanceToRow(this.rowCount - 1);
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        if (this.cursorPosition == Position.afterLast || this.table.getActiveRowIndex() == this.rowCount - 1) {
            this.cursorPosition = Position.afterLast;
            return false;
        }
        if (this.cursorPosition == Position.beforeFirst) {
            this.cursorPosition = Position.middle;
        }
        try {
            return this.table.advanceRow();
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClosed();
        if (this.cursorPosition == Position.afterLast) {
            return this.last();
        }
        if (this.cursorPosition == Position.beforeFirst || this.table.getActiveRowIndex() <= 0) {
            this.beforeFirst();
            return false;
        }
        try {
            int tempRowIndex = this.table.getActiveRowIndex();
            this.table.resetRowPosition();
            this.table.advanceToRow(0);
            return this.table.advanceToRow(tempRowIndex - 1);
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkClosed();
        if (this.rowCount == 0) {
            return false;
        }
        if (this.cursorPosition == Position.afterLast && rows > 0) {
            return false;
        }
        if (this.cursorPosition == Position.beforeFirst && rows <= 0) {
            return false;
        }
        if (this.table.getActiveRowIndex() + rows >= this.rowCount) {
            this.cursorPosition = Position.afterLast;
            return this.table.getActiveRowIndex() + rows == this.rowCount;
        }
        try {
            int rowsToMove = this.table.getActiveRowIndex() + rows;
            if (this.cursorPosition == Position.beforeFirst || rows < 0) {
                rowsToMove = this.cursorPosition == Position.afterLast ? this.rowCount + rows : (this.cursorPosition == Position.beforeFirst ? rows - 1 : this.table.getActiveRowIndex() + rows);
                if (rowsToMove < 0) {
                    this.beforeFirst();
                    return false;
                }
                this.table.resetRowPosition();
                this.table.advanceToRow(0);
            }
            this.cursorPosition = Position.middle;
            return this.table.advanceToRow(rowsToMove);
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw SQLError.get("s1010", direction);
        }
        this.fetchDirection = direction;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw SQLError.get("s1010", rows);
        }
        this.fetchSize = rows;
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateRow() throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        try {
            return this.table.wasNull();
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw SQLError.get("s1009", iface.toString());
        }
    }

    public VoltTable getVoltTable() {
        return this.table;
    }

    public Object[] getRowData() throws SQLException {
        Object[] row = new Object[this.columnCount];
        for (int i = 1; i < this.columnCount + 1; ++i) {
            row[i - 1] = this.getObject(i);
        }
        return row;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw SQLError.noSupport();
    }

    private static enum Position {
        beforeFirst,
        middle,
        afterLast;

    }
}

