/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.jdbc;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.voltdb.jdbc.SQLError;

public class JDBC4ParameterMetaData
implements ParameterMetaData {
    private final Statement owner;
    private final int parameterCount;

    JDBC4ParameterMetaData(Statement owner, int parameterCount) throws SQLException {
        this.owner = owner;
        this.parameterCount = parameterCount;
    }

    private void checkClosed() throws SQLException {
        if (this.owner.isClosed()) {
            throw SQLError.get("08003");
        }
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public int getParameterCount() throws SQLException {
        this.checkClosed();
        return this.parameterCount;
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        this.checkClosed();
        return 1;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public int getScale(int param) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public int isNullable(int param) throws SQLException {
        this.checkClosed();
        return 1;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw SQLError.get("s1009", iface.toString());
        }
    }
}

