/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.jdbc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.voltdb.client.ClientSslSetup;
import org.voltdb.jdbc.JDBC4ClientConnectionPool;
import org.voltdb.jdbc.JDBC4Connection;
import org.voltdb.jdbc.SQLError;

public class Driver
implements java.sql.Driver {
    public static final String JDBC_PROP_FILE_ENV = "VOLTDB_JDBC_PROPERTIES";
    public static final String JDBC_PROP_FILE_PROP = "voltdb.jdbcproperties";
    public static final String DEFAULT_PROP_FILENAME = "voltdb.properties";
    public static final String SSL_PROP = "ssl";
    public static final String TRUSTSTORE_CONFIG_PROP = "truststore";
    public static final String TRUSTSTORE_PASSWORD_PROP = "truststorepassword";
    public static final String KERBEROS_CONFIG_PROP = "kerberos";
    public static final String TOPOLOGY_CHANGE_AWARE_PROP = "topologychangeaware";
    public static final String RECONNECT_ON_CONNECTION_LOSS_PROP = "autoreconnect";
    public static final String MAX_OUTSTANDING_TXNS_PROP = "maxoutstandingtxns";
    public static final String HEAVYWEIGHT_PROP = "heavyweight";
    public static final String USER_PROP = "user";
    public static final String PASSWORD_PROP = "password";
    public static final String PRIORITY_PROP = "priority";
    private static final String URL_PREFIX = "jdbc:voltdb:";
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 0;

    static String[] getServersFromURL(String url) {
        String prefix = "jdbc:voltdb://";
        int end = url.length();
        if (url.indexOf("?") > 0) {
            end = url.indexOf("?");
        }
        String servstring = url.substring(prefix.length(), end);
        return servstring.split(",");
    }

    static Map<String, String> getPropsFromURL(String url) {
        HashMap<String, String> results = new HashMap<String, String>();
        if (url.indexOf("?") > 0) {
            String[] props;
            String propstring = url.substring(url.indexOf("?") + 1);
            for (String prop : props = propstring.split("&")) {
                if (prop.indexOf("=") <= 0) continue;
                String[] comps = prop.split("=");
                results.put(comps[0], comps[1]);
            }
        }
        return results;
    }

    @Override
    public Connection connect(String url, Properties props) throws SQLException {
        if (this.acceptsURL(url)) {
            try {
                Properties fileprops = this.tryToFindPropsFile();
                Properties info = (Properties)props.clone();
                String prefix = "jdbc:voltdb://";
                if (!url.startsWith(prefix)) {
                    throw SQLError.get("s1009");
                }
                String[] servers = Driver.getServersFromURL(url);
                Map<String, String> urlprops = Driver.getPropsFromURL(url);
                for (Map.Entry<String, String> e : urlprops.entrySet()) {
                    info.setProperty(e.getKey(), e.getValue());
                }
                Enumeration<?> e = fileprops.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    info.setProperty(key, fileprops.getProperty(key));
                }
                String user = "";
                String password = "";
                boolean heavyweight = false;
                int maxoutstandingtxns = 0;
                boolean enableSSL = false;
                String truststorePath = null;
                String truststorePassword = null;
                String kerberosConfig = null;
                boolean topologyChangeAware = false;
                int priority = -1;
                Enumeration<?> e2 = info.propertyNames();
                while (e2.hasMoreElements()) {
                    String key = (String)e2.nextElement();
                    String value = info.getProperty(key);
                    if (key.equalsIgnoreCase(USER_PROP)) {
                        user = value;
                        continue;
                    }
                    if (key.equalsIgnoreCase(PASSWORD_PROP)) {
                        password = value;
                        continue;
                    }
                    if (key.equalsIgnoreCase(HEAVYWEIGHT_PROP)) {
                        heavyweight = value.equalsIgnoreCase("true") || value.toLowerCase().equals("yes") || value.equalsIgnoreCase("1");
                        continue;
                    }
                    if (key.equalsIgnoreCase(MAX_OUTSTANDING_TXNS_PROP)) {
                        maxoutstandingtxns = Integer.parseInt(value);
                        continue;
                    }
                    if (RECONNECT_ON_CONNECTION_LOSS_PROP.equals(key)) {
                        boolean rc = "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "1".equals(value);
                        if (!rc) continue;
                        throw SQLError.get("s1009");
                    }
                    if (key.equalsIgnoreCase(SSL_PROP)) {
                        enableSSL = value.equalsIgnoreCase("true");
                        continue;
                    }
                    if (key.equalsIgnoreCase(TRUSTSTORE_CONFIG_PROP)) {
                        if (value == null || value.trim().length() <= 0) continue;
                        truststorePath = value.trim();
                        continue;
                    }
                    if (key.equalsIgnoreCase(TRUSTSTORE_PASSWORD_PROP)) {
                        truststorePassword = value;
                        continue;
                    }
                    if (key.equalsIgnoreCase(KERBEROS_CONFIG_PROP)) {
                        if (value == null || value.trim().length() <= 0) continue;
                        kerberosConfig = value.trim();
                        continue;
                    }
                    if (key.equalsIgnoreCase(TOPOLOGY_CHANGE_AWARE_PROP)) {
                        topologyChangeAware = Boolean.valueOf(value);
                        continue;
                    }
                    if (!key.equalsIgnoreCase(PRIORITY_PROP) || (priority = Integer.valueOf(value).intValue()) >= 1 && priority <= 8) continue;
                    throw SQLError.get("s1009");
                }
                ClientSslSetup.SslConfig sslConfig = null;
                if (enableSSL) {
                    sslConfig = ClientSslSetup.createSslConfig(truststorePath, truststorePassword);
                }
                return new JDBC4Connection(JDBC4ClientConnectionPool.get(servers, user, password, heavyweight, maxoutstandingtxns, sslConfig, kerberosConfig, topologyChangeAware, priority), info);
            }
            catch (SQLException x) {
                throw x;
            }
            catch (Exception x) {
                throw SQLError.get(x, "08001");
            }
        }
        return null;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return Pattern.compile("^jdbc:voltdb://.+", 2).matcher(url).matches();
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties loginProps) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties tryToFindPropsFile() {
        File propfile;
        Properties fileprops = new Properties();
        String filename = null;
        filename = System.getenv(JDBC_PROP_FILE_ENV);
        if (filename == null) {
            filename = System.getProperty(JDBC_PROP_FILE_PROP);
        }
        if (filename == null) {
            URL pathToJar = this.getClass().getProtectionDomain().getCodeSource().getLocation();
            String tmp = null;
            try {
                tmp = new File(pathToJar.toURI()).getParent() + File.separator + DEFAULT_PROP_FILENAME;
            }
            catch (Exception e) {
                tmp = null;
            }
            filename = tmp;
        }
        if (filename != null && (propfile = new File(filename)).exists() && propfile.isFile()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(propfile);
                fileprops.load(in);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return fileprops;
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

