/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client.exampleutils;

import java.util.ArrayList;
import org.voltdb.client.exampleutils.IRateLimiter;
import org.voltdb.client.exampleutils.MathEx;

public class RateLimiter
implements IRateLimiter {
    private long SleepTime;
    private int StepCount;
    private Long[] CycleStepDuration;
    private Long[] CycleStepMaxCount;
    private Long[] CycleStepCount;
    private Long[] CycleStepEndTime;
    private long MaxProcessPerSecond = 0L;
    private long CycleAdjustment = Long.MIN_VALUE;
    private long LastCycleCount = Long.MAX_VALUE;

    public RateLimiter(long maxProcessPerSecond) {
        this.set(maxProcessPerSecond, 0L, false);
    }

    @Override
    public void throttle() {
        this.throttle(this.MaxProcessPerSecond);
    }

    public void throttle(long maxProcessPerSecond) {
        long adjustment = 0L;
        boolean forceSet = false;
        if (this.CycleAdjustment <= System.currentTimeMillis()) {
            if (this.MaxProcessPerSecond == maxProcessPerSecond && this.LastCycleCount != Long.MAX_VALUE) {
                if (this.MaxProcessPerSecond > this.LastCycleCount) {
                    adjustment = this.MaxProcessPerSecond - this.LastCycleCount;
                } else {
                    forceSet = true;
                }
            }
            this.CycleAdjustment = System.currentTimeMillis() + 1000L;
            this.LastCycleCount = 0L;
        }
        this.set(maxProcessPerSecond, adjustment, forceSet);
        try {
            if (this.SleepTime > 0L) {
                Thread.sleep(this.SleepTime);
            }
            for (int i = 0; i < this.StepCount; ++i) {
                Long[] longArray = this.CycleStepCount;
                int n = i;
                Long l = longArray[n];
                longArray[n] = longArray[n] + 1L;
                if (this.CycleStepCount[i] < this.CycleStepMaxCount[i]) continue;
                long sleepDuration = this.CycleStepEndTime[i] - System.currentTimeMillis() - 1L;
                if (sleepDuration > 0L) {
                    Thread.sleep(sleepDuration);
                }
                while (System.currentTimeMillis() < this.CycleStepEndTime[i]) {
                }
                this.CycleStepEndTime[i] = System.currentTimeMillis() + this.CycleStepDuration[i];
                this.CycleStepCount[i] = 0L;
            }
            ++this.LastCycleCount;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void set(long maxProcessPerSecond, long adjustment, boolean forceSet) {
        if (this.MaxProcessPerSecond != maxProcessPerSecond || adjustment != 0L || forceSet) {
            this.MaxProcessPerSecond = maxProcessPerSecond;
            if (0L == (maxProcessPerSecond += adjustment)) {
                maxProcessPerSecond = 1000L;
            }
            this.SleepTime = 1000L / maxProcessPerSecond - 1L;
            long gcd = MathEx.gcd(maxProcessPerSecond, 1000L);
            double cycleMaxCount = maxProcessPerSecond / gcd;
            ArrayList<Long> cycleStepDuration = new ArrayList<Long>();
            ArrayList<Long> cycleStepMaxCount = new ArrayList<Long>();
            ArrayList<Long> cycleStepCount = new ArrayList<Long>();
            for (double cycleDuration = (double)(1000L / gcd); cycleDuration >= 1.0 && cycleMaxCount > 0.0; cycleDuration /= 10.0) {
                cycleStepDuration.add((long)cycleDuration);
                cycleStepMaxCount.add((long)cycleMaxCount);
                cycleStepCount.add(0L);
                cycleMaxCount = Math.ceil(cycleMaxCount / 10.0);
            }
            this.StepCount = cycleStepCount.size();
            this.CycleStepDuration = cycleStepDuration.toArray(new Long[this.StepCount]);
            this.CycleStepMaxCount = cycleStepMaxCount.toArray(new Long[this.StepCount]);
            this.CycleStepCount = cycleStepCount.toArray(new Long[this.StepCount]);
            this.CycleStepEndTime = cycleStepCount.toArray(new Long[this.StepCount]);
            for (int i = 0; i < this.StepCount; ++i) {
                this.CycleStepEndTime[i] = System.currentTimeMillis() + this.CycleStepDuration[i];
            }
        }
    }
}

