/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client.exampleutils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.voltdb.client.ClientResponse;
import org.voltdb.client.exampleutils.PerfCounter;

public class PerfCounterMap {
    private final ConcurrentHashMap<String, PerfCounter> Counters = new ConcurrentHashMap();

    public PerfCounter get(String counter) {
        if (!this.Counters.containsKey(counter)) {
            this.Counters.put(counter, new PerfCounter(false));
        }
        return this.Counters.get(counter);
    }

    public void update(String counter, ClientResponse response) {
        this.get(counter).update(response);
    }

    public void update(String counter, long executionDuration) {
        this.get(counter).update(executionDuration);
    }

    public void update(String counter, long executionDuration, boolean success) {
        this.get(counter).update(executionDuration, success);
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean useSimpleFormat) {
        StringBuilder result = new StringBuilder();
        for (String counter : this.Counters.keySet()) {
            if (useSimpleFormat) {
                result.append(String.format("%1$-24s:", counter));
            } else {
                result.append(String.format("---- %1$-24s -------------------------------------------------------\n", counter));
            }
            result.append(this.Counters.get(counter).toString(useSimpleFormat));
            result.append("\n\n");
        }
        return result.toString();
    }

    public String toRawString(char delimiter) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, PerfCounter> e : this.Counters.entrySet()) {
            result.append(e.getKey()).append(delimiter).append(e.getValue().toRawString(delimiter)).append('\n');
        }
        return result.toString();
    }
}

