/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client.exampleutils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.voltdb.client.exampleutils.ClientConnection;
import org.voltdb.client.exampleutils.ClientConnectionPool;
import org.voltdb.client.exampleutils.IRateLimiter;
import org.voltdb.client.exampleutils.PerfCounter;
import org.voltdb.client.exampleutils.RateLimiter;

public class LatencyLimiter
implements IRateLimiter {
    private final ClientConnection Connection;
    private final double TargetLatency;
    private final String Procedure;
    private PerfCounter Start;
    private PerfCounter End;
    private long Rate;
    private final RateLimiter Limiter;
    private long LastCheck;
    private final SimpleDateFormat DateFormat;
    private final long StartTime;

    public LatencyLimiter(ClientConnection connection, String procedure, double targetLatency, long initialMaxProcessPerSecond) {
        this.Connection = connection;
        this.TargetLatency = targetLatency;
        this.Procedure = procedure;
        this.Start = ClientConnectionPool.getStatistics(this.Connection).get(this.Procedure).clone();
        this.End = ClientConnectionPool.getStatistics(this.Connection).get(this.Procedure);
        this.Rate = initialMaxProcessPerSecond;
        this.Limiter = new RateLimiter(this.Rate);
        this.LastCheck = System.currentTimeMillis();
        this.DateFormat = new SimpleDateFormat("HH:mm:ss");
        this.DateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.StartTime = System.currentTimeMillis();
    }

    @Override
    public void throttle() {
        this.throttle(true);
    }

    public void throttle(boolean verbose) {
        if (System.currentTimeMillis() - this.LastCheck > 5000L) {
            if (this.End.getExecutionCount() - this.Start.getExecutionCount() > 0L) {
                double observedLatency;
                double tuningLatency = observedLatency = (double)(this.End.getTotalExecutionDuration() - this.Start.getTotalExecutionDuration()) / (double)(this.End.getExecutionCount() - this.Start.getExecutionCount());
                long[] el = this.End.getLatencyBuckets();
                long[] sl = this.Start.getLatencyBuckets();
                long ec = this.End.getExecutionCount() - this.Start.getExecutionCount();
                long elsum = 0L;
                for (int i = 0; i < 25; ++i) {
                    elsum += el[i];
                }
                long slsum = 0L;
                for (int i = 0; i < 25; ++i) {
                    slsum += sl[i];
                }
                if ((double)(elsum - slsum) / (double)ec > 0.97) {
                    long outlierExecutionDuration = 0L;
                    long outlierExecutionCount = 0L;
                    for (int i = 25; i < 109; ++i) {
                        outlierExecutionCount += el[i] - sl[i];
                        if (i >= 100) {
                            outlierExecutionDuration += (el[i] - sl[i]) * 50L;
                            continue;
                        }
                        outlierExecutionDuration += el[i] - sl[i];
                    }
                    tuningLatency = (double)(this.End.getTotalExecutionDuration() - this.Start.getTotalExecutionDuration() - outlierExecutionDuration) / (double)(this.End.getExecutionCount() - this.Start.getExecutionCount() - outlierExecutionCount);
                }
                long oldRate = this.Rate;
                if (tuningLatency > this.TargetLatency * 2.0) {
                    this.Rate = (long)((double)this.Rate * 0.8);
                } else if (tuningLatency > this.TargetLatency * 1.25) {
                    this.Rate = (long)((double)this.Rate * 0.95);
                } else if (tuningLatency > this.TargetLatency * 1.1) {
                    this.Rate = (long)((double)this.Rate * 0.999);
                } else if (tuningLatency < this.TargetLatency * 0.5) {
                    this.Rate = (long)((double)this.Rate * 1.1);
                } else if (tuningLatency < this.TargetLatency * 0.75) {
                    this.Rate = (long)((double)this.Rate * 1.01);
                } else if (tuningLatency < this.TargetLatency * 0.9) {
                    this.Rate = (long)((double)this.Rate * 1.001);
                }
                if (verbose && oldRate != this.Rate) {
                    System.out.printf("%8s | Adjusting %s to:  %,11.1f TPS | Recent Latency :  %7.2f\n", this.DateFormat.format(new Date(Math.round((double)(System.currentTimeMillis() - this.StartTime) / 1000.0) * 1000L)), oldRate < this.Rate ? " UP " : "DOWN", (double)this.Rate, tuningLatency);
                }
            }
            this.Start = this.End.clone();
            this.End = ClientConnectionPool.getStatistics(this.Connection).get(this.Procedure);
            this.LastCheck = System.currentTimeMillis();
        }
        this.Limiter.throttle(this.Rate);
    }
}

