/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client.exampleutils;

import java.io.Closeable;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.Future;
import org.voltdb.client.Client;
import org.voltdb.client.ClientConfig;
import org.voltdb.client.ClientFactory;
import org.voltdb.client.ClientResponse;
import org.voltdb.client.NoConnectionsException;
import org.voltdb.client.ProcCallException;
import org.voltdb.client.ProcedureCallback;
import org.voltdb.client.exampleutils.ClientConnectionPool;
import org.voltdb.client.exampleutils.ExecutionFuture;
import org.voltdb.client.exampleutils.PerfCounter;
import org.voltdb.client.exampleutils.PerfCounterMap;

public class ClientConnection
implements Closeable {
    private final PerfCounterMap Statistics;
    private final Client Client;
    protected final String KeyBase;
    protected final String Key;
    protected short Users;
    public long DefaultAsyncTimeout = 60000L;

    protected ClientConnection(String clientConnectionKeyBase, String clientConnectionKey, String[] servers, int port, String user, String password, boolean isHeavyWeight, int maxOutstandingTxns) throws Exception {
        this.KeyBase = clientConnectionKeyBase;
        this.Key = clientConnectionKey;
        this.Statistics = ClientConnectionPool.getStatistics(clientConnectionKeyBase);
        ClientConfig config = new ClientConfig(user, password);
        config.setHeavyweight(isHeavyWeight);
        if (maxOutstandingTxns > 0) {
            config.setMaxOutstandingTxns(maxOutstandingTxns);
        }
        Client client = ClientFactory.createClient(config);
        for (String server : servers) {
            if (server.trim().length() <= 0) continue;
            client.createConnection(server.trim(), port);
        }
        this.Client = client;
        this.Users = 0;
    }

    protected ClientConnection use() {
        this.Users = (short)(this.Users + 1);
        return this;
    }

    protected void dispose() {
        this.Users = (short)(this.Users - 1);
        if (this.Users == 0) {
            try {
                this.Client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() {
        ClientConnectionPool.dispose(this);
    }

    public ClientResponse execute(String procedure, Object ... parameters) throws Exception {
        long start = System.currentTimeMillis();
        try {
            ClientResponse response = this.Client.callProcedure(procedure, parameters);
            this.Statistics.update(procedure, response);
            return response;
        }
        catch (ProcCallException pce) {
            this.Statistics.update(procedure, System.currentTimeMillis() - start, false);
            throw pce;
        }
        catch (Exception x) {
            throw x;
        }
    }

    public boolean executeAsync(ProcedureCallback callback, String procedure, Object ... parameters) throws Exception {
        return this.Client.callProcedure(new TrackingCallback(this, procedure, callback), procedure, parameters);
    }

    public Future<ClientResponse> executeAsync(String procedure, Object ... parameters) throws Exception {
        final ExecutionFuture future = new ExecutionFuture(this.DefaultAsyncTimeout);
        this.Client.callProcedure(new TrackingCallback(this, procedure, new ProcedureCallback(){
            final ExecutionFuture result;
            {
                this.result = future;
            }

            @Override
            public void clientCallback(ClientResponse response) throws Exception {
                future.set(response);
            }
        }), procedure, parameters);
        return future;
    }

    public PerfCounterMap getStatistics() {
        return ClientConnectionPool.getStatistics(this);
    }

    public PerfCounter getStatistics(String procedure) {
        return ClientConnectionPool.getStatistics(this).get(procedure);
    }

    public PerfCounter getStatistics(String ... procedures) {
        PerfCounterMap map = ClientConnectionPool.getStatistics(this);
        PerfCounter result = new PerfCounter(false);
        for (String procedure : procedures) {
            result.merge(map.get(procedure));
        }
        return result;
    }

    public void saveStatistics(String file) throws IOException {
        if (file != null && !file.trim().isEmpty()) {
            FileWriter fw = new FileWriter(file);
            fw.write(this.getStatistics().toRawString(','));
            fw.flush();
            fw.close();
        }
    }

    public void drain() throws NoConnectionsException, InterruptedException {
        this.Client.drain();
    }

    public void backpressureBarrier() throws InterruptedException {
        this.Client.backpressureBarrier();
    }

    private static class TrackingCallback
    implements ProcedureCallback {
        private final ClientConnection Owner;
        private final String Procedure;
        private final ProcedureCallback UserCallback;

        public TrackingCallback(ClientConnection owner, String procedure, ProcedureCallback userCallback) {
            this.Owner = owner;
            this.Procedure = procedure;
            this.UserCallback = userCallback;
        }

        @Override
        public void clientCallback(ClientResponse response) throws Exception {
            this.Owner.Statistics.update(this.Procedure, response);
            if (this.UserCallback != null) {
                this.UserCallback.clientCallback(response);
            }
        }
    }
}

