/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client.VoltBulkLoader;

import com.google_voltpatches.common.collect.ImmutableSortedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.voltcore.logging.VoltLogger;
import org.voltcore.utils.CoreUtils;
import org.voltdb.ClientResponseImpl;
import org.voltdb.VoltTable;
import org.voltdb.VoltTableRow;
import org.voltdb.VoltType;
import org.voltdb.VoltTypeException;
import org.voltdb.client.VoltBulkLoader.BulkLoaderFailureCallBack;
import org.voltdb.client.VoltBulkLoader.BulkLoaderState;
import org.voltdb.client.VoltBulkLoader.BulkLoaderSuccessCallback;
import org.voltdb.client.VoltBulkLoader.Client1LoaderAdapter;
import org.voltdb.client.VoltBulkLoader.Client2LoaderAdapter;
import org.voltdb.client.VoltBulkLoader.LoaderAdapter;
import org.voltdb.client.VoltBulkLoader.PerPartitionTable;
import org.voltdb.client.VoltBulkLoader.VoltBulkLoaderRow;

public class VoltBulkLoader {
    private static final VoltLogger loaderLog = new VoltLogger("LOADER");
    final BulkLoaderState m_vblGlobals;
    final LoaderAdapter m_client;
    final int m_maxBatchSize;
    final boolean m_upsert;
    final BulkLoaderFailureCallBack m_notificationCallBack;
    PerPartitionTable[] m_partitionTable = null;
    final int m_firstPartitionTable;
    final int m_lastPartitionTable;
    final String m_procName;
    String m_tableName;
    VoltType m_partitionColumnType = VoltType.NULL;
    VoltTable.ColumnInfo[] m_colInfo;
    TreeMap<Integer, VoltType> m_mappedColumnTypes;
    final VoltType[] m_columnTypes;
    int m_partitionedColumnIndex = -1;
    Map<Integer, String> m_colNames;
    int m_columnCnt = 0;
    private boolean m_isMP = false;
    private int m_maxPartitionProcessors = -1;
    private final ScheduledThreadPoolExecutor m_ses = CoreUtils.getScheduledThreadPoolExecutor("Periodic-Flush", 1, 262144);
    private ScheduledFuture<?> m_flush = null;
    final AtomicLong m_outstandingRowCount = new AtomicLong(0L);
    final AtomicLong m_loaderCompletedCnt = new AtomicLong(0L);

    public VoltBulkLoader(BulkLoaderState vblGlobals, String tableName, int maxBatchSize, BulkLoaderFailureCallBack failureCallback) throws Exception {
        this(vblGlobals, tableName, maxBatchSize, false, failureCallback, null);
    }

    public VoltBulkLoader(BulkLoaderState vblGlobals, String tableName, int maxBatchSize, boolean upsertMode, BulkLoaderFailureCallBack failureCallback) throws Exception {
        this(vblGlobals, tableName, maxBatchSize, upsertMode, failureCallback, null);
    }

    public VoltBulkLoader(BulkLoaderState vblGlobals, String tableName, int maxBatchSize, boolean upsertMode, BulkLoaderFailureCallBack failureCallback, BulkLoaderSuccessCallback successCallback) throws Exception {
        this.m_vblGlobals = vblGlobals;
        this.m_client = this.m_vblGlobals.m_client2Impl != null ? new Client2LoaderAdapter(this.m_vblGlobals.m_client2Impl) : new Client1LoaderAdapter(this.m_vblGlobals.m_clientImpl);
        this.m_maxBatchSize = maxBatchSize;
        this.m_notificationCallBack = failureCallback;
        this.m_upsert = upsertMode;
        this.m_tableName = tableName;
        VoltTable procInfo = this.m_client.callProcedure("@SystemCatalog", "COLUMNS").getResults()[0];
        this.m_mappedColumnTypes = new TreeMap();
        this.m_colNames = new TreeMap<Integer, String>();
        this.m_partitionedColumnIndex = -1;
        this.m_partitionColumnType = VoltType.NULL;
        VoltTableRow pkeyInfo = null;
        if (this.m_upsert) {
            pkeyInfo = this.m_client.callProcedure("@SystemCatalog", "PRIMARYKEYS").getResults()[0];
        }
        if (!this.m_client.waitForTopology()) {
            throw new IllegalStateException("VoltBulkLoader unable to start due to uninitialized Client.");
        }
        if (this.m_upsert) {
            boolean hasPkey = false;
            while (pkeyInfo.advanceRow()) {
                String table = pkeyInfo.getString("TABLE_NAME");
                if (!tableName.equalsIgnoreCase(table)) continue;
                hasPkey = true;
                break;
            }
            if (!hasPkey) {
                throw new IllegalArgumentException(String.format("The --update argument cannot be used because the table %s does not have a primary key. Either remove the --update argument or add a primary key to the table.", tableName));
            }
        }
        while (procInfo.advanceRow()) {
            String table = procInfo.getString("TABLE_NAME");
            if (!tableName.equalsIgnoreCase(table)) continue;
            VoltType vtype = VoltType.typeFromString(procInfo.getString("TYPE_NAME"));
            int idx = (int)procInfo.getLong("ORDINAL_POSITION") - 1;
            this.m_mappedColumnTypes.put(idx, vtype);
            this.m_colNames.put(idx, procInfo.getString("COLUMN_NAME"));
            String remarks = procInfo.getString("REMARKS");
            if (remarks == null || !remarks.equalsIgnoreCase("PARTITION_COLUMN")) continue;
            this.m_partitionColumnType = vtype;
            this.m_partitionedColumnIndex = idx;
        }
        this.m_columnCnt = this.m_mappedColumnTypes.size();
        if (this.m_columnCnt == 0) {
            throw new IllegalArgumentException("Table Name parameter does not match any known table.");
        }
        this.m_columnTypes = this.getColumnTypes();
        this.m_colInfo = new VoltTable.ColumnInfo[this.m_columnCnt];
        for (int i = 0; i < this.m_columnCnt; ++i) {
            VoltTable.ColumnInfo ci;
            VoltType type = this.m_columnTypes[i];
            String cname = this.m_colNames.get(i);
            this.m_colInfo[i] = ci = new VoltTable.ColumnInfo(cname, type);
        }
        int sitesPerHost = 1;
        int kfactor = 0;
        int hostcount = 1;
        procInfo = this.m_client.callProcedure("@SystemInformation", "deployment").getResults()[0];
        while (procInfo.advanceRow()) {
            String prop = procInfo.getString("PROPERTY");
            if (prop != null && prop.equalsIgnoreCase("sitesperhost")) {
                sitesPerHost = Integer.parseInt(procInfo.getString("VALUE"));
            }
            if (prop != null && prop.equalsIgnoreCase("hostcount")) {
                hostcount = Integer.parseInt(procInfo.getString("VALUE"));
            }
            if (prop == null || !prop.equalsIgnoreCase("kfactor")) continue;
            kfactor = Integer.parseInt(procInfo.getString("VALUE"));
        }
        this.m_isMP = this.m_partitionedColumnIndex == -1;
        this.m_maxPartitionProcessors = hostcount * sitesPerHost / (kfactor + 1) + 1;
        if (!this.m_isMP) {
            this.m_firstPartitionTable = 0;
            this.m_lastPartitionTable = this.m_maxPartitionProcessors - 2;
            this.m_procName = "@LoadSinglepartitionTable";
        } else {
            this.m_firstPartitionTable = this.m_maxPartitionProcessors - 1;
            this.m_lastPartitionTable = this.m_maxPartitionProcessors - 1;
            this.m_procName = "@LoadMultipartitionTable";
        }
        List<VoltBulkLoader> loaderList = this.m_vblGlobals.m_TableNameToLoader.get(this.m_tableName);
        if (loaderList == null) {
            this.m_partitionTable = new PerPartitionTable[this.m_maxPartitionProcessors];
            for (int i = this.m_firstPartitionTable; i <= this.m_lastPartitionTable; ++i) {
                this.m_partitionTable[i] = new PerPartitionTable(this.m_client, this.m_tableName, i, i == this.m_maxPartitionProcessors - 1, this, maxBatchSize, successCallback);
            }
            loaderList = new ArrayList<VoltBulkLoader>();
            loaderList.add(this);
            this.m_vblGlobals.m_TableNameToLoader.put(this.m_tableName, loaderList);
        } else {
            VoltBulkLoader primary = loaderList.get(0);
            this.m_partitionTable = primary.m_partitionTable;
            loaderList.add(this);
            for (int i = this.m_firstPartitionTable; i <= this.m_lastPartitionTable; ++i) {
                if (primary.m_maxBatchSize == maxBatchSize) continue;
                this.m_partitionTable[i].updateMinBatchTriggerSize(maxBatchSize);
            }
        }
    }

    public synchronized void setFlushInterval(long delay, long seconds) {
        if (this.m_flush != null) {
            this.m_flush.cancel(false);
            this.m_flush = null;
        }
        if (seconds > 0L) {
            this.m_flush = this.m_ses.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        VoltBulkLoader.this.flush();
                    }
                    catch (Exception e) {
                        loaderLog.error("Failed to flush loader buffer, some tuples may not be inserted.", e);
                    }
                }
            }, delay, seconds, TimeUnit.SECONDS);
        }
    }

    void generateError(Object rowHandle, Object[] objectList, String errMessage) {
        VoltTable[] dummyTable = new VoltTable[]{new VoltTable(this.m_colInfo)};
        ClientResponseImpl dummyResponse = new ClientResponseImpl(-2, dummyTable, errMessage);
        this.m_notificationCallBack.failureCallback(rowHandle, objectList, dummyResponse);
        this.m_loaderCompletedCnt.incrementAndGet();
    }

    public void insertRow(Object rowHandle, Object ... fieldList) throws InterruptedException {
        int partitionId = 0;
        if (fieldList == null || fieldList.length <= 0) {
            Object errMsg = rowHandle == null ? "Error: insertRow received empty fieldList" : "Error: insertRow received empty fieldList for row: " + rowHandle.toString();
            this.generateError(rowHandle, fieldList, (String)errMsg);
            return;
        }
        if (fieldList.length != this.m_columnCnt) {
            String errMsg = rowHandle == null ? "Error: insertRow received incorrect number of columns; " + fieldList.length + " found, " + this.m_columnCnt + " expected" : "Error: insertRow received incorrect number of columns; " + fieldList.length + " found, " + this.m_columnCnt + " expected for row: " + rowHandle.toString();
            this.generateError(rowHandle, fieldList, errMsg);
            return;
        }
        VoltBulkLoaderRow newRow = new VoltBulkLoaderRow(this, rowHandle, fieldList);
        if (this.m_isMP) {
            this.m_partitionTable[this.m_firstPartitionTable].insertRowInTable(newRow);
        } else {
            try {
                partitionId = this.m_client.getPartitionForParameter(this.m_partitionColumnType.getValue(), fieldList[this.m_partitionedColumnIndex]);
                this.m_partitionTable[partitionId].insertRowInTable(newRow);
            }
            catch (VoltTypeException e) {
                this.generateError(rowHandle, fieldList, e.getMessage());
                return;
            }
        }
        this.m_outstandingRowCount.incrementAndGet();
    }

    public void flush() throws ExecutionException, InterruptedException {
        for (int i = this.m_firstPartitionTable; i <= this.m_lastPartitionTable; ++i) {
            this.m_partitionTable[i].flushAllTableQueues();
        }
    }

    public synchronized void drain() throws InterruptedException {
        for (int i = this.m_firstPartitionTable; i <= this.m_lastPartitionTable; ++i) {
            try {
                this.m_partitionTable[i].flushAllTableQueues().get();
                continue;
            }
            catch (ExecutionException e) {
                loaderLog.error("Failed to drain all buffers, some tuples may not be inserted yet.", e);
            }
        }
        while (this.m_outstandingRowCount.get() != 0L) {
            this.m_client.drainClient();
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws Exception {
        if (this.m_flush != null) {
            this.m_flush.cancel(false);
        }
        this.m_ses.shutdown();
        BulkLoaderState bulkLoaderState = this.m_vblGlobals;
        synchronized (bulkLoaderState) {
            this.drain();
            List<VoltBulkLoader> loaderList = this.m_vblGlobals.m_TableNameToLoader.get(this.m_tableName);
            if (loaderList.size() == 1) {
                this.m_vblGlobals.m_TableNameToLoader.remove(this.m_tableName);
                for (PerPartitionTable ppt : this.m_partitionTable) {
                    if (ppt == null) continue;
                    try {
                        ppt.shutdown();
                    }
                    catch (Exception e) {
                        loaderLog.error("Failed to close processor for partition " + ppt.m_partitionId, e);
                    }
                }
            } else {
                loaderList.remove(this);
            }
        }
        assert (this.m_outstandingRowCount.get() == 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeLoading() {
        for (PerPartitionTable ppt : this.m_partitionTable) {
            if (ppt == null) continue;
            PerPartitionTable perPartitionTable = ppt;
            synchronized (perPartitionTable) {
                ppt.notifyAll();
            }
        }
    }

    public int getMaxBatchSize() {
        return this.m_partitionTable[this.m_firstPartitionTable].m_minBatchTriggerSize;
    }

    public long getOutstandingRowCount() {
        return this.m_outstandingRowCount.get();
    }

    public long getCompletedRowCount() {
        return this.m_loaderCompletedCnt.get();
    }

    public VoltType[] getColumnTypes() {
        return this.m_mappedColumnTypes.values().toArray(new VoltType[this.m_mappedColumnTypes.size()]);
    }

    public Map<Integer, String> getColumnNames() {
        return ImmutableSortedMap.copyOf(this.m_colNames);
    }
}

