/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client.VoltBulkLoader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.voltcore.logging.VoltLogger;
import org.voltcore.utils.CoreUtils;
import org.voltdb.ClientResponseImpl;
import org.voltdb.ParameterConverter;
import org.voltdb.VoltTable;
import org.voltdb.VoltType;
import org.voltdb.VoltTypeException;
import org.voltdb.client.ClientResponse;
import org.voltdb.client.ProcedureCallback;
import org.voltdb.client.VoltBulkLoader.BulkLoaderSuccessCallback;
import org.voltdb.client.VoltBulkLoader.LoaderAdapter;
import org.voltdb.client.VoltBulkLoader.VoltBulkLoader;
import org.voltdb.client.VoltBulkLoader.VoltBulkLoaderRow;

class PerPartitionTable {
    private static final VoltLogger loaderLog = new VoltLogger("LOADER");
    final LoaderAdapter m_client;
    final int m_partitionId;
    final boolean m_isMP;
    LinkedBlockingQueue<VoltBulkLoaderRow> m_partitionRowQueue;
    final ExecutorService m_es;
    final int m_partitionedColumnIndex;
    final VoltType m_partitionColumnType;
    final VoltTable.ColumnInfo[] m_columnInfo;
    final VoltType[] m_columnTypes;
    volatile int m_minBatchTriggerSize;
    final String m_procName;
    final String m_tableName;
    final byte m_upsert;
    final BulkLoaderSuccessCallback m_successCallback;
    final boolean m_autoReconnect;
    static final int LOOKASIDE_LIMIT = 10;
    final LinkedList<VoltTable> m_tableLookaside = new LinkedList();

    PerPartitionTable(LoaderAdapter client, String tableName, int partitionId, boolean isMP, VoltBulkLoader firstLoader, int minBatchTriggerSize, BulkLoaderSuccessCallback successCallback) {
        this.m_client = client;
        this.m_partitionId = partitionId;
        this.m_isMP = isMP;
        this.m_procName = firstLoader.m_procName;
        this.m_upsert = (byte)(firstLoader.m_upsert ? 1 : 0);
        this.m_partitionRowQueue = new LinkedBlockingQueue(minBatchTriggerSize * 5);
        this.m_minBatchTriggerSize = minBatchTriggerSize;
        this.m_columnInfo = firstLoader.m_colInfo;
        this.m_partitionedColumnIndex = firstLoader.m_partitionedColumnIndex;
        this.m_columnTypes = firstLoader.m_columnTypes;
        this.m_partitionColumnType = firstLoader.m_partitionColumnType;
        this.m_tableName = tableName;
        this.m_successCallback = successCallback;
        this.m_autoReconnect = this.m_client.autoconnectEnabled();
        this.m_es = CoreUtils.getSingleThreadExecutor(tableName + "-" + partitionId);
    }

    boolean updateMinBatchTriggerSize(int minBatchTriggerSize) {
        if (this.m_minBatchTriggerSize >= minBatchTriggerSize) {
            this.m_minBatchTriggerSize = minBatchTriggerSize;
            return true;
        }
        return false;
    }

    synchronized void insertRowInTable(VoltBulkLoaderRow nextRow) throws InterruptedException {
        this.m_partitionRowQueue.put(nextRow);
        if (this.m_partitionRowQueue.size() == this.m_minBatchTriggerSize) {
            this.m_es.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (PerPartitionTable.this.m_partitionRowQueue.size() >= PerPartitionTable.this.m_minBatchTriggerSize) {
                            PartitionProcedureCallback cb = PerPartitionTable.this.buildTable();
                            PerPartitionTable.this.loadTable(cb, cb.m_voltTable);
                        }
                    }
                    catch (Exception e) {
                        loaderLog.error("Failed to load batch", e);
                    }
                }
            });
        }
    }

    Future<?> flushAllTableQueues() throws InterruptedException {
        return this.m_es.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                PartitionProcedureCallback cb = PerPartitionTable.this.buildTable();
                PerPartitionTable.this.loadTable(cb, cb.m_voltTable);
                return true;
            }
        });
    }

    void shutdown() throws Exception {
        try {
            this.flushAllTableQueues().get();
        }
        catch (ExecutionException e) {
            throw (Exception)e.getCause();
        }
        this.m_es.shutdown();
        this.m_es.awaitTermination(365L, TimeUnit.DAYS);
        this.m_tableLookaside.clear();
    }

    private void reinsertFailed(List<VoltBulkLoaderRow> rows) throws Exception {
        for (final VoltBulkLoaderRow row : rows) {
            VoltTable tmpTable = new VoltTable(this.m_columnInfo);
            try {
                Object[] row_args = new Object[row.m_rowData.length];
                for (int i = 0; i < row_args.length; ++i) {
                    VoltType type = this.m_columnTypes[i];
                    row_args[i] = ParameterConverter.tryToMakeCompatible(type.classFromType(), row.m_rowData[i]);
                }
                tmpTable.addRow(row_args);
            }
            catch (VoltTypeException ex) {
                loaderLog.error("Type conversion exception", ex);
                assert (false) : "Type conversion exception: " + ex.getMessage();
                continue;
            }
            ProcedureCallback callback = new ProcedureCallback(){

                @Override
                public void clientCallback(ClientResponse response) throws Exception {
                    if (response.getStatus() == -4 && PerPartitionTable.this.m_autoReconnect) {
                        PerPartitionTable.this.m_es.execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    PerPartitionTable.this.reinsertFailed(Arrays.asList(row));
                                }
                                catch (Exception e) {
                                    loaderLog.error("Failed to re-insert failed batch", e);
                                }
                            }
                        });
                        return;
                    }
                    if (response.getStatus() != 1) {
                        row.m_loader.m_notificationCallBack.failureCallback(row.m_rowHandle, row.m_rowData, response);
                    }
                    row.m_loader.m_loaderCompletedCnt.incrementAndGet();
                    row.m_loader.m_outstandingRowCount.decrementAndGet();
                }
            };
            this.loadTable(callback, tmpTable);
        }
    }

    private PartitionProcedureCallback buildTable() {
        ArrayList<VoltBulkLoaderRow> buf = new ArrayList<VoltBulkLoaderRow>(this.m_minBatchTriggerSize);
        this.m_partitionRowQueue.drainTo(buf, this.m_minBatchTriggerSize);
        VoltTable voltTable = this.allocateTable();
        HashMap<VoltBulkLoader, Long> batchSizes = new HashMap<VoltBulkLoader, Long>();
        ListIterator it = buf.listIterator();
        while (it.hasNext()) {
            VoltBulkLoaderRow currRow = (VoltBulkLoaderRow)it.next();
            VoltBulkLoader loader = currRow.m_loader;
            Object[] row_args = new Object[currRow.m_rowData.length];
            try {
                for (int i = 0; i < row_args.length; ++i) {
                    VoltType type = this.m_columnTypes[i];
                    row_args[i] = ParameterConverter.tryToMakeCompatible(type.classFromType(), currRow.m_rowData[i]);
                }
                voltTable.addRow(row_args);
            }
            catch (Exception e) {
                loader.generateError(currRow.m_rowHandle, currRow.m_rowData, e.getMessage());
                loader.m_outstandingRowCount.decrementAndGet();
                it.remove();
                continue;
            }
            Long prevValue = batchSizes.put(loader, 1L);
            if (prevValue == null) continue;
            batchSizes.put(loader, prevValue + 1L);
        }
        return new PartitionProcedureCallback(buf, batchSizes, voltTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VoltTable allocateTable() {
        VoltTable table;
        LinkedList<VoltTable> linkedList = this.m_tableLookaside;
        synchronized (linkedList) {
            table = this.m_tableLookaside.poll();
        }
        if (table == null) {
            table = new VoltTable(this.m_columnInfo);
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deallocateTable(VoltTable table) {
        table.clearRowData();
        LinkedList<VoltTable> linkedList = this.m_tableLookaside;
        synchronized (linkedList) {
            if (this.m_tableLookaside.size() < 10) {
                this.m_tableLookaside.add(table);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTable(ProcedureCallback callback, VoltTable toSend) throws Exception {
        block10: {
            if (toSend.getRowCount() <= 0) {
                return;
            }
            if (this.m_autoReconnect) {
                while (true) {
                    try {
                        this.load(callback, toSend);
                        break block10;
                    }
                    catch (IOException e) {
                        PerPartitionTable perPartitionTable = this;
                        synchronized (perPartitionTable) {
                            this.wait();
                        }
                    }
                }
            }
            try {
                this.load(callback, toSend);
            }
            catch (IOException e) {
                ClientResponseImpl r = new ClientResponseImpl(-4, new VoltTable[0], "Connection to database was lost");
                callback.clientCallback(r);
            }
        }
    }

    private void load(ProcedureCallback callback, VoltTable toSend) throws Exception {
        if (this.m_isMP) {
            this.m_client.callProcedure(callback, this.m_procName, this.m_tableName, this.m_upsert, toSend);
        } else {
            byte[] rpartitionParam = VoltType.valueToBytes(toSend.fetchRow(0).get(this.m_partitionedColumnIndex, this.m_partitionColumnType));
            this.m_client.callProcedure(callback, this.m_procName, rpartitionParam, this.m_tableName, this.m_upsert, toSend);
        }
    }

    class PartitionProcedureCallback
    implements ProcedureCallback {
        final List<VoltBulkLoaderRow> m_batchRowList;
        final Map<VoltBulkLoader, Long> m_batchSizes;
        VoltTable m_voltTable;

        PartitionProcedureCallback(List<VoltBulkLoaderRow> batchRowList, Map<VoltBulkLoader, Long> batchSizes, VoltTable voltTable) {
            this.m_batchRowList = batchRowList;
            this.m_batchSizes = batchSizes;
            this.m_voltTable = voltTable;
        }

        @Override
        public void clientCallback(final ClientResponse response) throws InterruptedException {
            PerPartitionTable.this.deallocateTable(this.m_voltTable);
            this.m_voltTable = null;
            if (response.getStatus() != 1) {
                PerPartitionTable.this.m_es.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PerPartitionTable.this.reinsertFailed(PartitionProcedureCallback.this.m_batchRowList);
                        }
                        catch (Exception e) {
                            loaderLog.error("Failed to re-insert failed batch", e);
                        }
                    }
                });
            } else {
                if (PerPartitionTable.this.m_successCallback != null) {
                    PerPartitionTable.this.m_es.execute(new Runnable(){

                        @Override
                        public void run() {
                            for (VoltBulkLoaderRow r : PartitionProcedureCallback.this.m_batchRowList) {
                                PerPartitionTable.this.m_successCallback.success(r.m_rowHandle, response);
                            }
                        }
                    });
                }
                for (Map.Entry<VoltBulkLoader, Long> e : this.m_batchSizes.entrySet()) {
                    e.getKey().m_loaderCompletedCnt.addAndGet(e.getValue());
                    e.getKey().m_outstandingRowCount.addAndGet(-1L * e.getValue());
                }
            }
        }
    }
}

