/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client.VoltBulkLoader;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.voltcore.logging.VoltLogger;
import org.voltdb.ClientResponseImpl;
import org.voltdb.VoltTable;
import org.voltdb.client.Client2Impl;
import org.voltdb.client.ClientResponse;
import org.voltdb.client.ProcCallException;
import org.voltdb.client.ProcedureCallback;
import org.voltdb.client.VoltBulkLoader.LoaderAdapter;

class Client2LoaderAdapter
implements LoaderAdapter {
    private final Client2Impl m_client2;

    public Client2LoaderAdapter(Client2Impl client2) {
        this.m_client2 = client2;
    }

    @Override
    public ClientResponse callProcedure(String procname, Object ... params) throws IOException, ProcCallException {
        return this.m_client2.callProcedureSync(procname, params);
    }

    @Override
    public void callProcedure(ProcedureCallback callback, String procname, Object ... params) throws IOException {
        this.m_client2.callProcedureAsync(procname, params).whenComplete((r, t) -> this.callbackAdapter((ClientResponse)r, (Throwable)t, callback));
    }

    private Void callbackAdapter(ClientResponse resp, Throwable th, ProcedureCallback cb) {
        try {
            if (th != null) {
                String text = th.getMessage();
                if (text == null) {
                    text = "Unexpected exceptional completion";
                }
                resp = new ClientResponseImpl(-3, new VoltTable[0], text);
            }
            cb.clientCallback(resp);
        }
        catch (Exception ex) {
            VoltLogger logger = new VoltLogger("LOADER");
            logger.error("Exception from loader callback: " + ex);
        }
        return null;
    }

    @Override
    public boolean autoconnectEnabled() {
        return this.m_client2.autoConnectionMgmt();
    }

    @Override
    public boolean waitForTopology() {
        return this.m_client2.waitForTopology(60L, TimeUnit.SECONDS);
    }

    @Override
    public int getPartitionForParameter(byte type, Object value) {
        return this.m_client2.getPartitionForParameter(type, value);
    }

    @Override
    public void drainClient() throws InterruptedException {
        this.m_client2.drain();
    }
}

