/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client.VoltBulkLoader;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.voltdb.client.Client;
import org.voltdb.client.Client2;
import org.voltdb.client.Client2Impl;
import org.voltdb.client.ClientImpl;
import org.voltdb.client.VoltBulkLoader.BulkLoaderFailureCallBack;
import org.voltdb.client.VoltBulkLoader.BulkLoaderSuccessCallback;
import org.voltdb.client.VoltBulkLoader.VoltBulkLoader;

public class BulkLoaderState {
    final ClientImpl m_clientImpl;
    final Client2Impl m_client2Impl;
    final Map<String, List<VoltBulkLoader>> m_TableNameToLoader = Collections.synchronizedMap(new TreeMap());

    public BulkLoaderState(Client client) {
        this.m_clientImpl = (ClientImpl)client;
        this.m_client2Impl = null;
    }

    public BulkLoaderState(Client2 client) {
        this.m_clientImpl = null;
        this.m_client2Impl = (Client2Impl)client;
    }

    public void connect(String servers, long timeout, long delay, TimeUnit unit) throws IOException {
        if (this.m_client2Impl != null) {
            this.m_client2Impl.connectSync(servers, timeout, delay, unit);
        } else {
            this.m_clientImpl.createAnyConnection(servers, unit.toMillis(timeout), unit.toMillis(delay));
        }
    }

    public synchronized VoltBulkLoader newBulkLoader(String tableName, int maxBatchSize, boolean upsertMode, BulkLoaderFailureCallBack failureCallback) throws Exception {
        return new VoltBulkLoader(this, tableName, maxBatchSize, upsertMode, failureCallback);
    }

    public synchronized VoltBulkLoader newBulkLoader(String tableName, int maxBatchSize, boolean upsertMode, BulkLoaderFailureCallBack failureCallback, BulkLoaderSuccessCallback successCallback) throws Exception {
        return new VoltBulkLoader(this, tableName, maxBatchSize, upsertMode, failureCallback, successCallback);
    }
}

