/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import io.netty.handler.ssl.NotSslRecordException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.function.Predicate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public class TLSHandshaker {
    public static final long HANDSHAKE_TIMEOUT_MILLIS = Long.getLong("TLS_HANDSHAKE_TIMEOUT", 30000L);
    private final SSLEngine m_eng;
    private final SocketChannel m_sc;
    private ByteBuffer m_remnant;

    public TLSHandshaker(SocketChannel socketChan, SSLEngine engine) {
        this.m_sc = socketChan;
        this.m_eng = engine;
    }

    private static boolean canRead(Selector selector) {
        Iterator<SelectionKey> keyIterator = selector.selectedKeys().iterator();
        boolean can = false;
        while (keyIterator.hasNext()) {
            SelectionKey key = keyIterator.next();
            if (key.isReadable()) {
                can = true;
            }
            keyIterator.remove();
        }
        return can;
    }

    public boolean handshake() throws IOException {
        return this.handshake(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handshake(Predicate<ByteBuffer> nonTlsCheck) throws IOException {
        SSLEngineResult result;
        boolean isBlocked;
        SSLSession session = this.m_eng.getSession();
        ByteBuffer rxNetData = TLSHandshaker.allocateBuffer(session.getPacketBufferSize());
        ByteBuffer txNetData = TLSHandshaker.allocateBuffer(session.getPacketBufferSize());
        ByteBuffer clearData = TLSHandshaker.allocateBuffer(session.getApplicationBufferSize());
        this.m_eng.beginHandshake();
        SSLEngineResult.HandshakeStatus status = this.m_eng.getHandshakeStatus();
        Object object = this.m_sc.blockingLock();
        synchronized (object) {
            isBlocked = this.m_sc.isBlocking();
            if (isBlocked) {
                this.m_sc.configureBlocking(false);
            }
        }
        Selector selector = Selector.open();
        this.m_sc.register(selector, 1);
        boolean testForNonTlsDone = false;
        int totalBytesRead = 0;
        int totalBytesWritten = 0;
        try {
            long startTs = System.currentTimeMillis();
            long endTs = startTs + HANDSHAKE_TIMEOUT_MILLIS;
            block50: while (status != SSLEngineResult.HandshakeStatus.FINISHED && status != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                long now = System.currentTimeMillis();
                if (now > endTs) {
                    String mess = String.format("TLS handshake timed out after %.3f sec (read %d, wrote %d, status %s)", new Object[]{(double)(now - startTs) / 1000.0, totalBytesRead, totalBytesWritten, status});
                    throw new IllegalStateException(mess);
                }
                boolean waitForData = true;
                switch (status) {
                    case NEED_UNWRAP: {
                        int bytesRead = 0;
                        if (waitForData && selector.select(2L) == 1 && TLSHandshaker.canRead(selector)) {
                            bytesRead = this.m_sc.read(rxNetData);
                            if (bytesRead < 0) {
                                if (this.m_eng.isInboundDone() && this.m_eng.isOutboundDone()) {
                                    boolean bl = false;
                                    return bl;
                                }
                                try {
                                    this.m_eng.closeInbound();
                                }
                                catch (SSLException sSLException) {
                                    // empty catch block
                                }
                                this.m_eng.closeOutbound();
                                status = this.m_eng.getHandshakeStatus();
                                continue block50;
                            }
                            totalBytesRead += bytesRead;
                        }
                        rxNetData.flip();
                        if (nonTlsCheck != null && !testForNonTlsDone && bytesRead > 0) {
                            if (nonTlsCheck.test(rxNetData)) {
                                throw new NotSslRecordException();
                            }
                            testForNonTlsDone = true;
                        }
                        try {
                            result = this.m_eng.unwrap(rxNetData, clearData);
                            rxNetData.compact();
                            waitForData = rxNetData.position() == 0;
                            status = result.getHandshakeStatus();
                        }
                        catch (SSLException e) {
                            this.m_eng.closeOutbound();
                            throw e;
                        }
                        switch (result.getStatus()) {
                            case OK: {
                                continue block50;
                            }
                            case BUFFER_OVERFLOW: {
                                clearData = TLSHandshaker.allocateBuffer(this.m_eng.getSession().getApplicationBufferSize());
                                continue block50;
                            }
                            case BUFFER_UNDERFLOW: {
                                waitForData = true;
                                continue block50;
                            }
                            case CLOSED: {
                                if (this.m_eng.isOutboundDone()) {
                                    boolean e = false;
                                    return e;
                                }
                                this.m_eng.closeOutbound();
                                status = this.m_eng.getHandshakeStatus();
                                continue block50;
                            }
                        }
                        throw new IllegalStateException("Invalid TLS unwrap result status: " + result.getStatus());
                    }
                    case NEED_WRAP: {
                        txNetData.clear();
                        try {
                            result = this.m_eng.wrap(clearData, txNetData);
                            status = result.getHandshakeStatus();
                        }
                        catch (SSLException e) {
                            this.m_eng.closeOutbound();
                            throw e;
                        }
                        int bytesWritten = 0;
                        switch (result.getStatus()) {
                            case OK: {
                                txNetData.flip();
                                bytesWritten = txNetData.remaining();
                                while (txNetData.hasRemaining()) {
                                    this.m_sc.write(txNetData);
                                }
                                break;
                            }
                            case BUFFER_OVERFLOW: {
                                txNetData = TLSHandshaker.allocateBuffer(this.m_eng.getSession().getPacketBufferSize());
                                break;
                            }
                            case BUFFER_UNDERFLOW: {
                                throw new SSLException("Buffer underflow occured after a wrap");
                            }
                            case CLOSED: {
                                txNetData.flip();
                                bytesWritten = txNetData.remaining();
                                while (txNetData.hasRemaining()) {
                                    this.m_sc.write(txNetData);
                                }
                                rxNetData.clear();
                                status = this.m_eng.getHandshakeStatus();
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Invalid TLS wrap result status: " + result.getStatus());
                            }
                        }
                        totalBytesWritten += bytesWritten;
                        continue block50;
                    }
                    case NEED_TASK: {
                        Runnable task;
                        while ((task = this.m_eng.getDelegatedTask()) != null) {
                            task.run();
                        }
                        status = this.m_eng.getHandshakeStatus();
                        continue block50;
                    }
                    case FINISHED: 
                    case NOT_HANDSHAKING: {
                        continue block50;
                    }
                }
                throw new IllegalStateException("Invalid TLS handshake status: " + status);
            }
        }
        finally {
            SelectionKey sk = this.m_sc.keyFor(selector);
            sk.cancel();
            selector.close();
            if (isBlocked) {
                Object object2 = this.m_sc.blockingLock();
                synchronized (object2) {
                    this.m_sc.configureBlocking(isBlocked);
                }
            }
        }
        rxNetData.flip();
        while (rxNetData.hasRemaining()) {
            result = this.m_eng.unwrap(rxNetData, clearData);
            switch (result.getStatus()) {
                case OK: {
                    break;
                }
                case BUFFER_OVERFLOW: {
                    clearData = TLSHandshaker.expand(clearData, clearData.limit() << 1);
                    break;
                }
                case BUFFER_UNDERFLOW: {
                    throw new IOException("buffer underflow while decrypting handshake remnant");
                }
                case CLOSED: {
                    throw new IOException("ssl engine closed while decrypting handshake remnant");
                }
            }
        }
        clearData.flip();
        this.m_remnant = clearData.slice();
        return true;
    }

    public ByteBuffer getRemnant() throws IOException {
        return this.m_remnant.hasRemaining() ? this.m_remnant.asReadOnlyBuffer() : this.m_remnant;
    }

    public boolean hasRemnant() {
        return this.m_remnant.hasRemaining();
    }

    public SSLEngine getSslEngine() {
        return this.m_eng;
    }

    private static ByteBuffer allocateBuffer(int size) {
        return TLSHandshaker.expand(null, size);
    }

    private static ByteBuffer expand(ByteBuffer bb, int newSize) {
        ByteBuffer expanded = ByteBuffer.allocate(newSize);
        if (bb != null) {
            expanded.put(bb.flip());
        }
        return expanded;
    }
}

