/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

class RateLimiter2 {
    static final int BLOCK_SIZE = 100;
    private final int targetTxnsPerBlock;
    private int currentBlockTxnCount;
    private long currentBlockTimestamp = -1L;

    RateLimiter2(int txnsPerSec) {
        this.targetTxnsPerBlock = Math.max(1, txnsPerSec / 10);
    }

    void limitSendRate() {
        long timestamp = System.currentTimeMillis();
        while (!this.rateIsWithinLimit(timestamp)) {
            try {
                Thread.sleep(1L);
                timestamp = System.currentTimeMillis();
            }
            catch (InterruptedException ex) {
                return;
            }
        }
    }

    private synchronized boolean rateIsWithinLimit(long timestamp) {
        this.updateCurrentBlock(timestamp);
        double fractionalLimit = (double)this.targetTxnsPerBlock * ((double)(timestamp - this.currentBlockTimestamp) + 1.0) / 100.0;
        if ((double)this.currentBlockTxnCount < Math.ceil(fractionalLimit)) {
            ++this.currentBlockTxnCount;
            return true;
        }
        return false;
    }

    private void updateCurrentBlock(long timestamp) {
        long thisBlock = timestamp - timestamp % 100L;
        if (this.currentBlockTimestamp < 0L) {
            this.currentBlockTimestamp = thisBlock;
        }
        if (thisBlock < this.currentBlockTimestamp) {
            thisBlock = this.currentBlockTimestamp;
        }
        if (thisBlock > this.currentBlockTimestamp) {
            this.currentBlockTimestamp = thisBlock;
            this.currentBlockTxnCount = 0;
        }
    }
}

