/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.voltcore.utils.EstTime;

class RateLimiter {
    static final int BLOCK_SIZE = 100;
    static final int DEFAULT_TXN_LIMIT = 10;
    protected boolean m_doesRateLimiting = false;
    protected int m_maxOutstandingTxns = 10;
    protected int m_outstandingTxns = 0;
    protected long m_currentBlockTimestamp = -1L;
    protected int m_currentBlockSendCount = 0;
    protected int m_currentBlockRecvSuccessCount = 0;
    protected long m_currentBlockTotalInternalLatency = 0L;
    protected int m_targetTxnsPerSecond = Integer.MAX_VALUE;
    protected Semaphore m_outstandingTxnsSemaphore = new Semaphore(10);
    private Runnable m_resumeSendCallback = null;
    private boolean m_needResume = false;
    private long m_resumeWaitTimeout = 0L;
    private int m_nonblockingOutCount = 0;
    private int m_nonblockingResumeLevel = Math.round(2.5f);
    private static final float RESUME_THRESHOLD = 0.25f;
    private static final int RESUME_TIMEOUT_FACTOR = 5;

    RateLimiter() {
    }

    private void ensureCurrentBlockIsKosher(long timestamp) {
        long thisBlock = timestamp - timestamp % 100L;
        if (this.m_currentBlockTimestamp == -1L) {
            this.m_currentBlockTimestamp = thisBlock;
        }
        if (thisBlock < this.m_currentBlockTimestamp) {
            thisBlock = this.m_currentBlockTimestamp;
        }
        if (thisBlock > this.m_currentBlockTimestamp) {
            this.m_currentBlockTimestamp = thisBlock;
            this.m_currentBlockSendCount = 0;
            this.m_currentBlockRecvSuccessCount = 0;
            this.m_currentBlockTotalInternalLatency = 0L;
        }
    }

    synchronized void setLimits(int txnsPerSec, int maxOutstanding) {
        this.m_doesRateLimiting = txnsPerSec < 0x3FFFFFFF;
        this.m_targetTxnsPerSecond = txnsPerSec;
        this.m_maxOutstandingTxns = maxOutstanding;
        this.m_outstandingTxnsSemaphore.drainPermits();
        this.m_outstandingTxnsSemaphore.release(maxOutstanding);
        this.m_nonblockingOutCount = 0;
        this.m_nonblockingResumeLevel = Math.round((float)maxOutstanding * 0.25f);
    }

    synchronized int[] getLimits() {
        int[] limits = new int[]{this.m_targetTxnsPerSecond, this.m_maxOutstandingTxns};
        return limits;
    }

    synchronized void setNonblockingResumeHook(Runnable callbk) {
        this.m_resumeSendCallback = callbk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void transactionResponseReceived(long endNanos, int internalLatency, boolean ignoreBackpressure) {
        if (this.m_doesRateLimiting) {
            RateLimiter rateLimiter = this;
            synchronized (rateLimiter) {
                this.ensureCurrentBlockIsKosher(TimeUnit.NANOSECONDS.toMillis(endNanos));
                --this.m_outstandingTxns;
                assert (this.m_outstandingTxns >= 0);
                if (internalLatency != -1) {
                    ++this.m_currentBlockRecvSuccessCount;
                    this.m_currentBlockTotalInternalLatency += (long)internalLatency;
                }
            }
        } else if (!ignoreBackpressure) {
            this.m_outstandingTxnsSemaphore.release();
            if (this.m_resumeSendCallback != null && this.shouldResumeSending()) {
                this.m_resumeSendCallback.run();
            }
        }
    }

    private synchronized boolean shouldResumeSending() {
        if (this.m_nonblockingOutCount > 0) {
            --this.m_nonblockingOutCount;
        }
        if (this.m_needResume && (this.m_nonblockingOutCount <= this.m_nonblockingResumeLevel || EstTime.currentTimeMillis() >= this.m_resumeWaitTimeout)) {
            this.m_needResume = false;
            this.m_resumeWaitTimeout = 0L;
            return true;
        }
        return false;
    }

    void prepareToSendTransaction(long startNanos, long timeoutNanos, boolean ignoreBackpressure) throws TimeoutException, InterruptedException {
        boolean acquired;
        if (this.m_doesRateLimiting) {
            long timestampNanos = startNanos;
            while (!this.rateWithinLimit(timestampNanos, ignoreBackpressure)) {
                Thread.sleep(1L);
                timestampNanos = System.nanoTime();
            }
        } else if (!(ignoreBackpressure || (acquired = this.m_outstandingTxnsSemaphore.tryAcquire()) || (acquired = this.m_outstandingTxnsSemaphore.tryAcquire(timeoutNanos, TimeUnit.NANOSECONDS)))) {
            throw new TimeoutException("timed out awaiting send permit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean prepareToSendTransactionNonblocking() {
        if (this.m_doesRateLimiting) {
            throw new IllegalStateException("Nonblocking not available with rate-limiting");
        }
        boolean acquired = this.m_outstandingTxnsSemaphore.tryAcquire();
        RateLimiter rateLimiter = this;
        synchronized (rateLimiter) {
            if (!acquired) {
                if (!this.m_needResume) {
                    this.m_needResume = true;
                    this.m_resumeWaitTimeout = EstTime.currentTimeMillis() + (long)(this.m_maxOutstandingTxns * 5);
                }
                return false;
            }
            ++this.m_nonblockingOutCount;
        }
        return true;
    }

    private synchronized boolean rateWithinLimit(long timestampNanos, boolean ignoreBackpressure) {
        long timestamp = TimeUnit.NANOSECONDS.toMillis(timestampNanos);
        this.ensureCurrentBlockIsKosher(timestamp);
        assert (timestamp - this.m_currentBlockTimestamp <= 100L);
        if (ignoreBackpressure || this.checkRate(timestamp)) {
            ++this.m_currentBlockSendCount;
            ++this.m_outstandingTxns;
            return true;
        }
        return false;
    }

    private boolean checkRate(long timestamp) {
        long faketime = Math.max(timestamp, this.m_currentBlockTimestamp);
        long targetTxnsPerBlock = this.m_targetTxnsPerSecond / 10;
        double expectedTxnsSent = (double)targetTxnsPerBlock * ((double)(faketime - this.m_currentBlockTimestamp) + 1.0) / 100.0;
        expectedTxnsSent = Math.ceil(expectedTxnsSent);
        assert (expectedTxnsSent <= (double)targetTxnsPerBlock);
        assert (expectedTxnsSent >= 1.0 || targetTxnsPerBlock == 0L);
        return (double)this.m_currentBlockSendCount < expectedTxnsSent && this.m_outstandingTxns < this.m_maxOutstandingTxns;
    }

    synchronized void debug() {
        System.out.printf("Target txns/sec is %d, max outstanding txns is %d, current outstanding is %d\n", this.m_targetTxnsPerSecond, this.m_maxOutstandingTxns, this.m_outstandingTxns);
    }
}

