/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PemTruststore {
    private final String pemPath;
    private final String storeType;

    private PemTruststore(String pemPath, String type) {
        this.pemPath = pemPath;
        this.storeType = type;
    }

    private void validatePemFile() {
        File pf = new File(this.pemPath);
        if (!pf.exists()) {
            throw new PemException("Input PEM file '%s' not found", this.pemPath);
        }
        if (!pf.canRead()) {
            throw new PemException("Cannot read input PEM file '%s'", this.pemPath);
        }
        if (!PemTruststore.looksLikePem(pf.getAbsolutePath())) {
            throw new PemException("File '%s' does not appear to be in PEM form", this.pemPath);
        }
    }

    public static boolean looksLikePem(String pemPath) {
        boolean pemmy = false;
        try (InputStream in = Files.newInputStream(Paths.get(pemPath, new String[0]), new OpenOption[0]);){
            byte[] marker = "-----BEGIN".getBytes(StandardCharsets.UTF_8);
            byte[] buff = new byte[marker.length];
            int len = in.read(buff);
            pemmy = len == marker.length && Arrays.equals(buff, marker);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pemmy;
    }

    public static KeyStore loadPemTruststore(String pemPath, String storeType) {
        PemTruststore instance = new PemTruststore(pemPath, storeType);
        return instance.makeTruststore();
    }

    public static KeyStore loadPemTruststore(String pemPath) {
        PemTruststore instance = new PemTruststore(pemPath, KeyStore.getDefaultType());
        return instance.makeTruststore();
    }

    private KeyStore makeTruststore() {
        this.validatePemFile();
        try {
            KeyStore truststore = KeyStore.getInstance(this.storeType);
            truststore.load(null, null);
            this.extractObjectsFromPem("CERTIFICATE", cert -> this.importCert((String)cert, truststore));
            if (truststore.size() == 0) {
                throw new PemException("No certificates found in PEM file '%s'", this.pemPath);
            }
            return truststore;
        }
        catch (PemException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PemException("Unable to build trust store from PEM file '%s': %s", this.pemPath, ex.getMessage());
        }
    }

    private void extractObjectsFromPem(String desiredObjType, Consumer<String> func) throws IOException {
        try (BufferedReader in = Files.newBufferedReader(Paths.get(this.pemPath, new String[0]), StandardCharsets.UTF_8);){
            Pattern begin = Pattern.compile("^-----BEGIN (.+)-----$");
            Pattern end = Pattern.compile("^-----END (.+)-----$");
            Pattern desired = Pattern.compile(desiredObjType);
            String currObjType = null;
            StringBuilder currObj = null;
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.startsWith("-----")) {
                    Matcher m;
                    if (currObjType == null) {
                        m = begin.matcher(line);
                        if (!m.matches()) {
                            throw new PemException("Bad PEM structure at '%s' in file '%s'", line, this.pemPath);
                        }
                        currObjType = m.group(1);
                        if (!desired.matcher(currObjType).matches()) continue;
                        currObj = new StringBuilder(4096);
                        continue;
                    }
                    m = end.matcher(line);
                    if (!m.matches() || !currObjType.equals(m.group(1))) {
                        throw new PemException("Bad PEM structure at '%s' in file '%s'", line, this.pemPath);
                    }
                    currObjType = null;
                    if (currObj == null) continue;
                    func.accept(currObj.toString());
                    currObj = null;
                    continue;
                }
                if (currObj == null) continue;
                currObj.append(line);
            }
            if (currObjType != null) {
                throw new PemException("Bad PEM structure at EOF in file '%s', pemPath", new Object[0]);
            }
        }
    }

    private Certificate importCert(String pemCert, KeyStore keystore) {
        try {
            byte[] derCert = Base64.getDecoder().decode(pemCert);
            ByteArrayInputStream in = new ByteArrayInputStream(derCert);
            CertificateFactory fac = CertificateFactory.getInstance("X.509");
            X509Certificate x509Cert = (X509Certificate)fac.generateCertificate(in);
            String alias = "cert_" + (keystore.size() + 1);
            keystore.setCertificateEntry(alias, x509Cert);
            return x509Cert;
        }
        catch (Exception ex) {
            throw new PemException("Unable to import certificate into keystore: %s", ex.getMessage());
        }
    }

    public static class PemException
    extends RuntimeException {
        public PemException(String msg, Object ... args) {
            super(String.format(msg, args));
        }
    }
}

