/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import java.io.FileWriter;
import java.io.IOException;
import org.voltdb.client.ClientStats;

public final class ClientStatsUtil {
    public static void writeSummaryCSV(ClientStats stats, String path) throws IOException {
        ClientStatsUtil.writeSummaryCSV(null, stats, path);
    }

    public static void writeSummaryCSV(String statsRowName, ClientStats stats, String path) throws IOException {
        if (stats == null) {
            throw new IllegalArgumentException("stats required");
        }
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("path required");
        }
        Object prefix = "";
        if (statsRowName != null && !statsRowName.isEmpty()) {
            prefix = statsRowName + ",";
        }
        String row = String.format("%s%d,%d,%d,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%d,%d,%d\n", prefix, stats.getStartTimestamp(), stats.getDuration(), stats.getInvocationsCompleted(), stats.kPercentileLatencyAsDouble(0.0), stats.kPercentileLatencyAsDouble(1.0), stats.kPercentileLatencyAsDouble(0.95), stats.kPercentileLatencyAsDouble(0.99), stats.kPercentileLatencyAsDouble(0.999), stats.kPercentileLatencyAsDouble(0.9999), stats.kPercentileLatencyAsDouble(0.99999), stats.getInvocationErrors(), stats.getInvocationAborts(), stats.getInvocationTimeouts());
        try (FileWriter fw = new FileWriter(path, true);){
            fw.append(row);
        }
    }
}

