/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.voltdb.client.Client2Impl;
import org.voltdb.client.ClientAffinityStats;
import org.voltdb.client.ClientConnectionRequestStats;
import org.voltdb.client.ClientIOStats;
import org.voltdb.client.ClientStats;
import org.voltdb.client.Distributer;

public class ClientStatsContext {
    final Distributer m_distributer;
    final Client2Impl m_client2;
    Map<Long, Map<String, ClientStats>> m_baseline;
    Map<Long, Map<String, ClientStats>> m_current;
    Map<Long, ClientIOStats> m_baselineIO;
    Map<Long, ClientIOStats> m_currentIO;
    Map<Integer, ClientAffinityStats> m_baselineAffinity;
    Map<Integer, ClientAffinityStats> m_currentAffinity;
    long m_baselineTS;
    long m_currentTS;

    ClientStatsContext(Distributer distributor, Map<Long, Map<String, ClientStats>> current, Map<Long, ClientIOStats> currentIO, Map<Integer, ClientAffinityStats> currentAffinity) {
        this(distributor, null, current, currentIO, currentAffinity);
    }

    ClientStatsContext(Client2Impl client2, Map<Long, Map<String, ClientStats>> current, Map<Long, ClientIOStats> currentIO, Map<Integer, ClientAffinityStats> currentAffinity) {
        this(null, client2, current, currentIO, currentAffinity);
    }

    private ClientStatsContext(Distributer distributor, Client2Impl client2, Map<Long, Map<String, ClientStats>> current, Map<Long, ClientIOStats> currentIO, Map<Integer, ClientAffinityStats> currentAffinity) {
        this.m_distributer = distributor;
        this.m_client2 = client2;
        this.m_baseline = new TreeMap<Long, Map<String, ClientStats>>();
        this.m_baselineIO = new TreeMap<Long, ClientIOStats>();
        this.m_baselineAffinity = new HashMap<Integer, ClientAffinityStats>();
        this.m_current = current;
        this.m_currentIO = currentIO;
        this.m_currentAffinity = currentAffinity;
        this.m_baselineTS = this.m_currentTS = System.currentTimeMillis();
    }

    public ClientStatsContext fetch() {
        if (this.m_client2 != null) {
            this.m_current = this.m_client2.getStatsSnapshot();
            this.m_currentIO = this.m_client2.getIOStatsSnapshot();
            this.m_currentAffinity = this.m_client2.getAffinityStatsSnapshot();
        } else {
            this.m_current = this.m_distributer.getStatsSnapshot();
            this.m_currentIO = this.m_distributer.getIOStatsSnapshot();
            this.m_currentAffinity = this.m_distributer.getAffinityStatsSnapshot();
        }
        this.m_currentTS = System.currentTimeMillis();
        return this;
    }

    public ClientStatsContext fetchAndResetBaseline() {
        this.fetch();
        ClientStatsContext retval = new ClientStatsContext(this.m_distributer, this.m_client2, this.m_current, this.m_currentIO, this.m_currentAffinity);
        retval.m_baseline = this.m_baseline;
        retval.m_baselineIO = this.m_baselineIO;
        retval.m_baselineTS = this.m_baselineTS;
        retval.m_baselineAffinity = this.m_baselineAffinity;
        retval.m_currentTS = this.m_currentTS;
        this.m_baseline = this.m_current;
        this.m_baselineIO = this.m_currentIO;
        this.m_baselineTS = this.m_currentTS;
        this.m_baselineAffinity = this.m_currentAffinity;
        return retval;
    }

    public ClientStats getStats() {
        ClientStats cs = ClientStats.merge(this.getStatsByConnection().values());
        if (cs.m_endTS == Long.MIN_VALUE) {
            cs.m_startTS = this.m_baselineTS;
            cs.m_endTS = this.m_currentTS;
        }
        return cs;
    }

    public Map<String, ClientStats> getStatsByProc() {
        Map<Long, Map<String, ClientStats>> complete = this.getCompleteStats();
        TreeMap<String, ClientStats> retval = new TreeMap<String, ClientStats>();
        for (Map.Entry<Long, Map<String, ClientStats>> e : complete.entrySet()) {
            for (Map.Entry<String, ClientStats> e2 : e.getValue().entrySet()) {
                ClientStats current = e2.getValue();
                ClientStats aggregate = (ClientStats)retval.get(current.getProcedureName());
                if (aggregate == null) {
                    retval.put(current.getProcedureName(), (ClientStats)current.clone());
                    continue;
                }
                aggregate.add(current);
            }
        }
        return retval;
    }

    public Map<Long, ClientStats> getStatsByConnection() {
        Map<Long, Map<String, ClientStats>> complete = this.getCompleteStats();
        Map<Long, ClientIOStats> completeIO = this.diffIO(this.m_currentIO, this.m_baselineIO);
        TreeMap<Long, ClientStats> retval = new TreeMap<Long, ClientStats>();
        for (Map.Entry<Long, Map<String, ClientStats>> e : complete.entrySet()) {
            ClientStats cs = ClientStats.merge(e.getValue().values());
            ClientIOStats cios = completeIO.get(e.getKey());
            if (cios != null) {
                cs.m_bytesReceived = cios.m_bytesReceived;
                cs.m_bytesSent = cios.m_bytesSent;
            }
            retval.put(e.getKey(), cs);
        }
        return retval;
    }

    public Map<Long, Map<String, ClientStats>> getCompleteStats() {
        TreeMap<Long, Map<String, ClientStats>> retval = new TreeMap<Long, Map<String, ClientStats>>();
        for (Map.Entry<Long, Map<String, ClientStats>> entry : this.m_current.entrySet()) {
            if (this.m_baseline.containsKey(entry.getKey())) {
                retval.put(entry.getKey(), this.diff(entry.getValue(), this.m_baseline.get(entry.getKey())));
                continue;
            }
            retval.put(entry.getKey(), this.dup(entry.getValue()));
        }
        for (Map.Entry<Long, Map<String, ClientStats>> entry : retval.entrySet()) {
            for (Map.Entry<String, ClientStats> e2 : entry.getValue().entrySet()) {
                ClientStats cs = e2.getValue();
                cs.m_startTS = this.m_baselineTS;
                cs.m_endTS = this.m_currentTS;
                assert (cs.m_startTS != Long.MAX_VALUE);
                assert (cs.m_endTS != Long.MIN_VALUE);
            }
        }
        return retval;
    }

    public Map<Integer, ClientAffinityStats> getAffinityStats() {
        TreeMap<Integer, ClientAffinityStats> retval = new TreeMap<Integer, ClientAffinityStats>();
        for (Map.Entry<Integer, ClientAffinityStats> e : this.m_currentAffinity.entrySet()) {
            if (this.m_baselineAffinity.containsKey(e.getKey())) {
                retval.put(e.getKey(), ClientAffinityStats.diff(e.getValue(), this.m_baselineAffinity.get(e.getKey())));
                continue;
            }
            retval.put(e.getKey(), (ClientAffinityStats)e.getValue().clone());
        }
        return retval;
    }

    public ClientAffinityStats getAggregateAffinityStats() {
        long afWrites = 0L;
        long afReads = 0L;
        long rrWrites = 0L;
        long rrReads = 0L;
        Map<Integer, ClientAffinityStats> affinityStats = this.getAffinityStats();
        for (Map.Entry<Integer, ClientAffinityStats> e : affinityStats.entrySet()) {
            afWrites += e.getValue().getAffinityWrites();
            afReads += e.getValue().getAffinityReads();
            rrWrites += e.getValue().getRrWrites();
            rrReads += e.getValue().getRrReads();
        }
        ClientAffinityStats retval = new ClientAffinityStats(Integer.MAX_VALUE, afWrites, rrWrites, afReads, rrReads);
        return retval;
    }

    public ClientStats getStatsForProcedure(String procedureName) {
        Map<Long, Map<String, ClientStats>> complete = this.getCompleteStats();
        ArrayList<ClientStats> statsForProc = new ArrayList<ClientStats>();
        for (Map.Entry<Long, Map<String, ClientStats>> e : complete.entrySet()) {
            ClientStats procStats = e.getValue().get(procedureName);
            if (procStats == null) continue;
            statsForProc.add(procStats);
        }
        if (statsForProc.size() == 0) {
            return null;
        }
        return ClientStats.merge(statsForProc);
    }

    public Map<Integer, ClientConnectionRequestStats> getConnectionRequestStats() {
        if (this.m_client2 != null) {
            return this.m_client2.getConnectionRequestStats();
        }
        return this.m_distributer.getConnectionRequestStats();
    }

    public void resetConnectionRequestStats() {
        if (this.m_client2 != null) {
            this.m_client2.resetConnectionRequestStats();
        } else {
            this.m_distributer.resetConnectionRequestStats();
        }
    }

    Map<Long, ClientIOStats> diffIO(Map<Long, ClientIOStats> newer, Map<Long, ClientIOStats> older) {
        TreeMap<Long, ClientIOStats> retval = new TreeMap<Long, ClientIOStats>();
        if (newer == null) {
            return retval;
        }
        if (older == null) {
            return newer;
        }
        for (Map.Entry<Long, ClientIOStats> e : newer.entrySet()) {
            if (older.containsKey(e.getKey())) {
                retval.put(e.getKey(), ClientIOStats.diff(e.getValue(), older.get(e.getKey())));
                continue;
            }
            retval.put(e.getKey(), (ClientIOStats)e.getValue().clone());
        }
        return retval;
    }

    Map<String, ClientStats> diff(Map<String, ClientStats> newer, Map<String, ClientStats> older) {
        TreeMap<String, ClientStats> retval = new TreeMap<String, ClientStats>();
        for (Map.Entry<String, ClientStats> e : newer.entrySet()) {
            if (older.containsKey(e.getKey())) {
                retval.put(e.getKey(), ClientStats.diff(e.getValue(), older.get(e.getKey())));
                continue;
            }
            retval.put(e.getKey(), (ClientStats)e.getValue().clone());
        }
        return retval;
    }

    Map<String, ClientStats> dup(Map<String, ClientStats> x) {
        TreeMap<String, ClientStats> retval = new TreeMap<String, ClientStats>();
        for (Map.Entry<String, ClientStats> e : x.entrySet()) {
            retval.put(e.getKey(), (ClientStats)e.getValue().clone());
        }
        return retval;
    }
}

