/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import com.google_voltpatches.common.collect.ImmutableMap;
import com.google_voltpatches.common.net.HostAndPort;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.voltcore.utils.CoreUtils;
import org.voltdb.ClientResponseImpl;
import org.voltdb.VoltTable;
import org.voltdb.client.AllPartitionProcedureCallback;
import org.voltdb.client.Client;
import org.voltdb.client.ClientAuthScheme;
import org.voltdb.client.ClientConfig;
import org.voltdb.client.ClientFactory;
import org.voltdb.client.ClientResponse;
import org.voltdb.client.ClientResponseWithPartitionKey;
import org.voltdb.client.ClientSslSetup;
import org.voltdb.client.ClientStats;
import org.voltdb.client.ClientStatsContext;
import org.voltdb.client.ClientStatsUtil;
import org.voltdb.client.ClientStatusListenerExt;
import org.voltdb.client.ConnectionUtil;
import org.voltdb.client.Distributer;
import org.voltdb.client.NoConnectionsException;
import org.voltdb.client.NullCallback;
import org.voltdb.client.ProcCallException;
import org.voltdb.client.ProcedureArgumentCacher;
import org.voltdb.client.ProcedureCallback;
import org.voltdb.client.ProcedureInvocation;
import org.voltdb.client.UpdateClasses;
import org.voltdb.client.VoltBulkLoader.BulkLoaderFailureCallBack;
import org.voltdb.client.VoltBulkLoader.BulkLoaderState;
import org.voltdb.client.VoltBulkLoader.BulkLoaderSuccessCallback;
import org.voltdb.client.VoltBulkLoader.VoltBulkLoader;
import org.voltdb.utils.Encoder;

public final class ClientImpl
implements Client {
    private static final ProcedureCallback NULL_CALLBACK = new NullCallback();
    private final AtomicLong m_handle = new AtomicLong(0L);
    private final String m_username;
    private final byte[] m_passwordHash;
    private final ClientAuthScheme m_hashScheme;
    private final SslContext m_sslContext;
    private final Distributer m_distributer;
    private final long m_reconnectDelay;
    private final long m_reconnectMaxDelay;
    private final ScheduledExecutorService m_ex;
    private final boolean m_topologyChangeAware;
    final InternalClientStatusListener m_listener = new InternalClientStatusListener();
    private final ClientStatusListenerExt m_clientStatusListener;
    private final Object m_backpressureLock = new Object();
    private final CopyOnWriteArrayList<Long> m_blessedThreadIds = new CopyOnWriteArrayList();
    private boolean m_backpressure = false;
    private boolean m_nonblocking = false;
    private long m_asyncBlockingTimeout = 0L;
    private int m_requestPriority = -1;
    private final Set<HostAndPort> m_connectHistory;
    private boolean m_newConnectEpoch;
    private BulkLoaderState m_vblGlobals;
    private volatile boolean m_isShutdown;

    ClientImpl(ClientConfig config) {
        String username = config.m_username;
        if (config.m_subject != null) {
            username = ClientConfig.getUserNameFromSubject(config.m_subject);
        }
        this.m_username = username == null ? "" : username;
        this.m_hashScheme = config.m_hashScheme;
        if (config.m_cleartext) {
            String passwd = config.m_password != null ? config.m_password : "";
            this.m_passwordHash = ConnectionUtil.getHashedPassword(this.m_hashScheme, passwd);
        } else {
            this.m_passwordHash = Encoder.hexDecode(config.m_password);
        }
        this.m_sslContext = config.m_enableSSL ? ClientSslSetup.createClientSslContext(config.m_sslConfig) : null;
        this.m_distributer = new Distributer(config.m_heavyweight, config.m_procedureCallTimeoutNanos, config.m_connectionResponseTimeoutMS, config.m_subject, this.m_sslContext, config.m_enableSSLHostCheck);
        this.m_distributer.addClientStatusListener(this.m_listener);
        this.m_topologyChangeAware = config.m_topologyChangeAware;
        this.m_reconnectDelay = config.m_initialConnectionRetryIntervalMS;
        this.m_reconnectMaxDelay = config.m_maxConnectionRetryIntervalMS;
        this.m_distributer.setTopologyChangeAware(this.m_topologyChangeAware);
        if (this.m_topologyChangeAware) {
            this.m_ex = Executors.newSingleThreadScheduledExecutor(CoreUtils.getThreadFactory("Topoaware thread"));
            this.m_connectHistory = new LinkedHashSet<HostAndPort>();
        } else {
            this.m_ex = null;
            this.m_connectHistory = null;
        }
        if (config.m_requestPriority > 0) {
            this.m_requestPriority = config.m_requestPriority;
            this.m_distributer.useRequestPriority();
        }
        if (config.m_listener != null) {
            this.m_distributer.addClientStatusListener(config.m_listener);
        }
        this.m_clientStatusListener = config.m_listener;
        assert (config.m_maxOutstandingTxns > 0);
        this.m_distributer.m_rateLimiter.setLimits(config.m_maxTransactionsPerSecond, config.m_maxOutstandingTxns);
        this.m_blessedThreadIds.addAll(this.m_distributer.getThreadIds());
        this.m_nonblocking = config.m_nonblocking;
        this.m_asyncBlockingTimeout = config.m_asyncBlockingTimeout;
        this.m_distributer.setBackpressureQueueThresholds(config.m_backpressureQueueRequestLimit, config.m_backpressureQueueByteLimit);
    }

    public SslContext getSSLContext() {
        return this.m_sslContext;
    }

    @Override
    public final ClientResponse callProcedure(String procName, Object ... parameters) throws IOException, NoConnectionsException, ProcCallException {
        return this.callProcedureWithClientTimeoutImpl(-1, procName, 0L, TimeUnit.SECONDS, parameters);
    }

    @Override
    public ClientResponse callProcedureWithTimeout(int batchTimeout, String procName, Object ... parameters) throws IOException, NoConnectionsException, ProcCallException {
        return this.callProcedureWithClientTimeoutImpl(batchTimeout, procName, 0L, TimeUnit.SECONDS, parameters);
    }

    @Override
    public ClientResponse callProcedureWithClientTimeout(int batchTimeout, String procName, long clientTimeout, TimeUnit unit, Object ... parameters) throws IOException, NoConnectionsException, ProcCallException {
        return this.callProcedureWithClientTimeoutImpl(batchTimeout, procName, clientTimeout, unit, parameters);
    }

    private ClientResponse callProcedureWithClientTimeoutImpl(int batchTimeout, String procName, long clientTimeout, TimeUnit unit, Object ... parameters) throws IOException, NoConnectionsException, ProcCallException {
        long handle = this.m_handle.getAndIncrement();
        ProcedureInvocation invocation = new ProcedureInvocation(handle, batchTimeout, -1, this.m_requestPriority, procName, parameters);
        long nanos = unit.toNanos(clientTimeout);
        return this.internalSyncCallProcedure(nanos, invocation);
    }

    @Override
    public final boolean callProcedure(ProcedureCallback callback, String procName, Object ... parameters) throws IOException {
        return this.callProcedureWithClientTimeout(callback, -1, -1, procName, 0L, TimeUnit.NANOSECONDS, parameters);
    }

    @Override
    public final boolean callProcedureWithTimeout(ProcedureCallback callback, int batchTimeout, String procName, Object ... parameters) throws IOException {
        return this.callProcedureWithClientTimeout(callback, batchTimeout, -1, procName, 0L, TimeUnit.NANOSECONDS, parameters);
    }

    @Override
    public boolean callProcedureWithClientTimeout(ProcedureCallback callback, int batchTimeout, String procName, long clientTimeout, TimeUnit clientTimeoutUnit, Object ... parameters) throws IOException {
        return this.callProcedureWithClientTimeout(callback, batchTimeout, -1, procName, clientTimeout, clientTimeoutUnit, parameters);
    }

    public boolean callProcedureWithClientTimeout(ProcedureCallback callback, int batchTimeout, int partitionDestination, String procName, long clientTimeout, TimeUnit clientTimeoutUnit, Object ... parameters) throws IOException {
        if (callback instanceof ProcedureArgumentCacher) {
            ((ProcedureArgumentCacher)((Object)callback)).setArgs(parameters);
        }
        long handle = this.m_handle.getAndIncrement();
        ProcedureInvocation invocation = new ProcedureInvocation(handle, batchTimeout, partitionDestination, this.m_requestPriority, procName, parameters);
        if (this.m_isShutdown) {
            return false;
        }
        if (callback == null) {
            callback = NULL_CALLBACK;
        }
        return this.internalAsyncCallProcedure(callback, clientTimeoutUnit.toNanos(clientTimeout), this.m_nonblocking, invocation);
    }

    private final ClientResponse internalSyncCallProcedure(long clientTimeoutNanos, ProcedureInvocation invocation) throws ProcCallException, IOException {
        if (this.m_isShutdown) {
            throw new NoConnectionsException("Client is shut down");
        }
        if (this.m_blessedThreadIds.contains(Thread.currentThread().getId())) {
            throw new IOException("Can't invoke a procedure synchronously from within the client callback thread  without deadlocking the client library");
        }
        ClientResponse resp = null;
        SyncCallbackLight cb = new SyncCallbackLight();
        boolean queued = this.internalAsyncCallProcedure(cb, clientTimeoutNanos, false, invocation);
        if (!queued) {
            resp = new ClientResponseImpl(-2, -128, "", new VoltTable[0], "Procedure call not queued: timed out waiting for host connection");
            throw new ProcCallException(resp);
        }
        try {
            cb.waitForResponse();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted while waiting for response");
        }
        resp = cb.getResponse();
        if (resp.getStatus() != 1) {
            throw new ProcCallException(resp);
        }
        return resp;
    }

    private final boolean internalAsyncCallProcedure(ProcedureCallback callback, long clientTimeoutNanos, boolean nonblockingAsync, ProcedureInvocation invocation) throws IOException {
        if (this.m_isShutdown) {
            throw new NoConnectionsException("Client is shut down");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Callback required for async procedure call");
        }
        long startNanos = System.nanoTime();
        boolean isBlessed = this.m_blessedThreadIds.contains(Thread.currentThread().getId());
        if (nonblockingAsync && !isBlessed) {
            boolean queued = this.m_distributer.queueNonblocking(invocation, callback, startNanos, clientTimeoutNanos);
            if (!queued && this.m_asyncBlockingTimeout > 0L) {
                boolean bp = true;
                try {
                    bp = this.backpressureBarrier(startNanos, this.m_asyncBlockingTimeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!bp) {
                    queued = this.m_distributer.queueNonblocking(invocation, callback, startNanos, clientTimeoutNanos);
                }
            }
            return queued;
        }
        while (!this.m_distributer.queue(invocation, callback, isBlessed, startNanos, clientTimeoutNanos)) {
            if (this.m_isShutdown) {
                throw new NoConnectionsException("Client is shut down");
            }
            long delta = Math.max(1L, System.nanoTime() - startNanos);
            long timeout = clientTimeoutNanos == 0L ? this.m_distributer.getProcedureTimeoutNanos() : clientTimeoutNanos;
            boolean bp = true;
            try {
                bp = this.backpressureBarrier(startNanos, timeout - delta);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!bp) continue;
            return false;
        }
        return true;
    }

    @Override
    public ClientResponse updateClasses(File jarPath, String classesToDelete) throws IOException, ProcCallException {
        return UpdateClasses.update(this, jarPath, classesToDelete);
    }

    @Override
    public boolean updateClasses(ProcedureCallback callback, File jarPath, String classesToDelete) throws IOException {
        return UpdateClasses.update(this, callback, jarPath, classesToDelete);
    }

    @Override
    public void drain() throws InterruptedException {
        if (this.m_isShutdown) {
            return;
        }
        if (this.m_blessedThreadIds.contains(Thread.currentThread().getId())) {
            throw new RuntimeException("Can't invoke drain from within the client callback thread  without deadlocking the client library");
        }
        this.m_distributer.drain();
    }

    @Override
    public void close() throws InterruptedException {
        if (this.m_blessedThreadIds.contains(Thread.currentThread().getId())) {
            throw new RuntimeException("Can't invoke close from within the client callback thread  without deadlocking the client library");
        }
        this.m_isShutdown = true;
        this.setLocalBackpressureState(false);
        if (this.m_ex != null) {
            if (CoreUtils.isJunitTest()) {
                this.m_ex.shutdownNow();
            } else {
                this.m_ex.shutdown();
                this.m_ex.awaitTermination(365L, TimeUnit.DAYS);
            }
        }
        this.m_distributer.shutdown();
        ClientFactory.decreaseClientNum();
    }

    @Override
    public void backpressureBarrier() throws InterruptedException {
        this.backpressureBarrier(0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean backpressureBarrier(long start, long timeoutNanos) throws InterruptedException {
        if (this.m_isShutdown) {
            return false;
        }
        if (this.m_blessedThreadIds.contains(Thread.currentThread().getId())) {
            throw new RuntimeException("Can't invoke backpressureBarrier from within the client callback thread  without deadlocking the client library");
        }
        if (start == 0L) {
            Object object = this.m_backpressureLock;
            synchronized (object) {
                while (this.m_backpressure && !this.m_isShutdown) {
                    this.m_backpressureLock.wait();
                }
                return false;
            }
        }
        long msToNs = TimeUnit.MILLISECONDS.toNanos(1L);
        Object object = this.m_backpressureLock;
        synchronized (object) {
            long remainingTime = start + timeoutNanos - System.nanoTime();
            while (this.m_backpressure && !this.m_isShutdown) {
                if (remainingTime <= 0L) {
                    return true;
                }
                this.m_backpressureLock.wait(remainingTime / msToNs, (int)(remainingTime % msToNs));
                remainingTime = Math.min(start + timeoutNanos - System.nanoTime(), remainingTime - 1L);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLocalBackpressureState(boolean onoff) {
        Object object = this.m_backpressureLock;
        synchronized (object) {
            this.m_backpressure = onoff;
            if (!onoff) {
                this.m_backpressureLock.notifyAll();
            }
        }
    }

    @Override
    public ClientStatsContext createStatsContext() {
        return this.m_distributer.createStatsContext();
    }

    @Override
    public Object[] getInstanceId() {
        return this.m_distributer.getInstanceId();
    }

    @Override
    public String getBuildString() {
        return this.m_distributer.getBuildString();
    }

    public void resetInstanceId() {
        this.m_distributer.resetInstanceId();
    }

    static HostAndPort parseHostAndPort(String server) {
        return HostAndPort.fromString(server.trim()).withDefaultPort(21212).requireBracketsForIPv6();
    }

    @Override
    public void createConnection(String host) throws IOException {
        HostAndPort hp = ClientImpl.parseHostAndPort(host);
        this.createConnectionImpl(hp.getHost(), hp.getPort());
    }

    @Override
    public void createConnection(String host, int port) throws IOException {
        this.createConnectionImpl(host, port);
    }

    private void createConnectionImpl(String host, int port) throws IOException {
        if (this.m_isShutdown) {
            throw new NoConnectionsException("Client is shut down");
        }
        this.m_distributer.createConnectionWithHashedCredentials(host, this.m_username, this.m_passwordHash, port, this.m_hashScheme);
    }

    @Override
    public void createAnyConnection(String hostList) throws IOException {
        this.createAnyConnection(hostList, 0L, 0L);
    }

    @Override
    public void createAnyConnection(String hostList, long timeout, long delay) throws IOException {
        List<HostAndPort> servers = this.hostAndPortList(hostList);
        long startTime = System.currentTimeMillis();
        while (true) {
            Iterator<HostAndPort> it = servers.iterator();
            while (it.hasNext()) {
                HostAndPort srv = it.next();
                String host = srv.getHost();
                int port = srv.getPort();
                try {
                    this.createConnectionImpl(host, port);
                    return;
                }
                catch (UnknownHostException e) {
                    it.remove();
                }
                catch (IOException e) {
                }
                catch (Exception e) {
                    it.remove();
                }
                if (this.m_clientStatusListener == null) continue;
                this.m_clientStatusListener.connectionCreated(host, port, ClientStatusListenerExt.AutoConnectionStatus.UNABLE_TO_CONNECT);
            }
            if (servers.isEmpty() || System.currentTimeMillis() - startTime >= timeout) {
                throw new ConnectException("Failed to connect to cluster");
            }
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException ex) {
                throw new InterruptedIOException("Interrupted while waiting to retry connect");
            }
        }
    }

    private List<HostAndPort> hostAndPortList(String servers) {
        ArrayList<HostAndPort> list = new ArrayList<HostAndPort>();
        for (String srv : servers.split(",")) {
            if ((srv = srv.trim()).isEmpty()) continue;
            list.add(HostAndPort.fromString(srv).withDefaultPort(21212).requireBracketsForIPv6());
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Empty server list");
        }
        return list;
    }

    @Override
    public List<InetSocketAddress> getConnectedHostList() {
        return this.m_distributer.getConnectedHostList();
    }

    @Override
    public int[] getThroughputAndOutstandingTxnLimits() {
        return this.m_distributer.m_rateLimiter.getLimits();
    }

    @Override
    public void writeSummaryCSV(ClientStats stats, String path) throws IOException {
        this.writeSummaryCSV(null, stats, path);
    }

    @Override
    public void writeSummaryCSV(String statsRowName, ClientStats stats, String path) throws IOException {
        if (path != null && !path.isEmpty()) {
            ClientStatsUtil.writeSummaryCSV(statsRowName, stats, path);
        }
    }

    public boolean isHashinatorInitialized() {
        return this.m_distributer.isHashinatorInitialized();
    }

    public long getPartitionForParameter(byte typeValue, Object value) {
        return this.m_distributer.getPartitionForParameter(typeValue, value);
    }

    public long getPartitionForParameter(byte[] bytes) {
        return this.m_distributer.getPartitionForParameter(bytes);
    }

    @Override
    public VoltBulkLoader getNewBulkLoader(String tableName, int maxBatchSize, boolean upsertMode, BulkLoaderFailureCallBack failureCallback) throws Exception {
        return this.getNewBulkLoader(tableName, maxBatchSize, upsertMode, failureCallback, null);
    }

    @Override
    public VoltBulkLoader getNewBulkLoader(String tableName, int maxBatchSize, BulkLoaderFailureCallBack failureCallback) throws Exception {
        return this.getNewBulkLoader(tableName, maxBatchSize, false, failureCallback, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VoltBulkLoader getNewBulkLoader(String tableName, int maxBatchSize, boolean upsertMode, BulkLoaderFailureCallBack failureCallback, BulkLoaderSuccessCallback successCallback) throws Exception {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            if (this.m_vblGlobals == null) {
                this.m_vblGlobals = new BulkLoaderState(this);
            }
        }
        return this.m_vblGlobals.newBulkLoader(tableName, maxBatchSize, upsertMode, failureCallback, successCallback);
    }

    @Override
    public boolean waitForTopology(long timeout) {
        boolean ready = false;
        long start = System.currentTimeMillis();
        long delta = Math.min(timeout, 500L);
        try {
            while (!(ready = this.m_distributer.isHashinatorInitialized()) && System.currentTimeMillis() - start < timeout) {
                Thread.sleep(delta);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return ready;
    }

    @Override
    public boolean isAutoReconnectEnabled() {
        return this.m_topologyChangeAware;
    }

    @Override
    public boolean isTopologyChangeAwareEnabled() {
        return this.m_topologyChangeAware;
    }

    @Override
    public ClientResponseWithPartitionKey[] callAllPartitionProcedure(String procedureName, Object ... params) throws IOException, ProcCallException {
        CountDownLatch latch = new CountDownLatch(1);
        SyncAllPartitionProcedureCallback callBack = new SyncAllPartitionProcedureCallback(latch);
        this.callAllPartitionProcedure(callBack, procedureName, params);
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted while waiting for response");
        }
        return callBack.getResponse();
    }

    @Override
    public boolean callAllPartitionProcedure(AllPartitionProcedureCallback callback, String procedureName, Object ... params) throws IOException, ProcCallException {
        if (callback == null) {
            throw new IllegalArgumentException("AllPartitionProcedureCallback can not be null");
        }
        Object[] args = new Object[params.length + 1];
        System.arraycopy(params, 0, args, 1, params.length);
        ImmutableMap<Integer, Integer> partitionMap = this.m_distributer.getPartitionKeys();
        int partitionCount = partitionMap.size();
        AtomicInteger counter = new AtomicInteger(partitionCount);
        assert (partitionCount > 0);
        ClientResponseWithPartitionKey[] responses = new ClientResponseWithPartitionKey[partitionCount];
        for (Map.Entry entry : partitionMap.entrySet()) {
            args[0] = entry.getValue();
            OnePartitionProcedureCallback cb = new OnePartitionProcedureCallback(counter, args[0], --partitionCount, responses, callback, (Integer)entry.getKey());
            try {
                if (this.callProcedureWithClientTimeout((ProcedureCallback)cb, -1, (Integer)entry.getKey(), procedureName, 0L, TimeUnit.NANOSECONDS, args)) continue;
                ClientResponseImpl r = new ClientResponseImpl(-2, new VoltTable[0], "The procedure is not queued for execution.");
                throw new ProcCallException(r);
            }
            catch (Exception ex) {
                try {
                    cb.exceptionCallback(ex);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        }
        return true;
    }

    class InternalClientStatusListener
    extends ClientStatusListenerExt {
        private boolean m_useAdminPort = false;
        private boolean m_adminPortChecked = false;
        private AtomicInteger connectionTaskCount = new AtomicInteger(0);

        InternalClientStatusListener() {
        }

        @Override
        public void backpressure(boolean status) {
            ClientImpl.this.setLocalBackpressureState(status);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionCreated(String hostname, int port, ClientStatusListenerExt.AutoConnectionStatus status) {
            if (ClientImpl.this.m_topologyChangeAware && status == ClientStatusListenerExt.AutoConnectionStatus.SUCCESS) {
                Set<HostAndPort> set = ClientImpl.this.m_connectHistory;
                synchronized (set) {
                    if (ClientImpl.this.m_newConnectEpoch) {
                        ClientImpl.this.m_newConnectEpoch = false;
                        ClientImpl.this.m_connectHistory.clear();
                    }
                    ClientImpl.this.m_connectHistory.add(HostAndPort.fromParts(hostname, port));
                }
            }
        }

        @Override
        public void connectionLost(String hostname, int port, int connectionsLeft, ClientStatusListenerExt.DisconnectCause cause) {
            if (connectionsLeft == 0) {
                if (ClientImpl.this.m_topologyChangeAware && !ClientImpl.this.m_isShutdown) {
                    this.createAnyConnection();
                } else {
                    ClientImpl.this.setLocalBackpressureState(false);
                }
            }
        }

        Map<Integer, HostConfig> buildUnconnectedHostConfigMap(VoltTable vt) {
            HashMap<Integer, HostConfig> unconnectedMap = new HashMap<Integer, HostConfig>();
            HashMap<Integer, HostConfig> connectedMap = new HashMap<Integer, HostConfig>();
            while (vt.advanceRow()) {
                Integer hid = (int)vt.getLong("HOST_ID");
                HostConfig config = null;
                if (!ClientImpl.this.m_distributer.isHostConnected(hid)) {
                    config = (HostConfig)unconnectedMap.get(hid);
                    if (config == null) {
                        config = new HostConfig();
                        unconnectedMap.put(hid, config);
                    }
                } else if (!this.m_adminPortChecked && (config = (HostConfig)connectedMap.get(hid)) == null) {
                    config = new HostConfig();
                    connectedMap.put(hid, config);
                }
                if (config == null) continue;
                config.setValue(vt.getString("KEY"), vt.getString("VALUE"));
            }
            if (!this.m_adminPortChecked) {
                Map<String, Integer> connectedIpPortPairs = ClientImpl.this.m_distributer.getConnectedHostIPAndPort();
                int admintPortCount = 0;
                for (HostConfig config : connectedMap.values()) {
                    Integer connectedPort = connectedIpPortPairs.get(config.m_ipAddress);
                    if (connectedPort == null || config.m_adminPort != connectedPort) continue;
                    ++admintPortCount;
                }
                this.m_useAdminPort = admintPortCount == connectedMap.values().size();
            }
            this.m_adminPortChecked = true;
            return unconnectedMap;
        }

        void notifyAutoConnectFailure(HostConfig host, ClientStatusListenerExt.AutoConnectionStatus status) {
            if (host != null) {
                this.notifyAutoConnectFailure(host.m_hostName, host.m_clientPort, status);
            } else {
                this.notifyAutoConnectFailure("", -1, status);
            }
        }

        void notifyAutoConnectFailure(String host, int port, ClientStatusListenerExt.AutoConnectionStatus status) {
            if (ClientImpl.this.m_clientStatusListener != null) {
                ClientImpl.this.m_clientStatusListener.connectionCreated(host, port, status);
            }
        }

        void retryConnectionCreationIfNeeded(int failCount, boolean first, int retry) {
            if (failCount == 0) {
                try {
                    ClientImpl.this.m_distributer.setCreateConnectionsUponTopologyChangeComplete();
                }
                catch (Exception e) {
                    this.notifyAutoConnectFailure(null, ClientStatusListenerExt.AutoConnectionStatus.UNABLE_TO_QUERY_TOPOLOGY);
                }
            } else if (ClientImpl.this.m_isShutdown) {
                this.notifyAutoConnectFailure(null, ClientStatusListenerExt.AutoConnectionStatus.UNABLE_TO_CONNECT);
            } else if (first) {
                ClientImpl.this.m_ex.schedule(new FirstConnectionTask(this, this.connectionTaskCount, retry + 1), this.reconnectDelay(retry + 1), TimeUnit.MILLISECONDS);
            } else if (this.connectionTaskCount.get() < 2) {
                ClientImpl.this.m_ex.schedule(new CreateConnectionTask(this, this.connectionTaskCount, retry + 1), this.reconnectDelay(retry + 1), TimeUnit.MILLISECONDS);
            }
        }

        long reconnectDelay(int n) {
            long delay = ClientImpl.this.m_reconnectDelay;
            for (int i = 1; delay < ClientImpl.this.m_reconnectMaxDelay && i < n; ++i) {
                delay = Math.min(delay * 2L, ClientImpl.this.m_reconnectMaxDelay);
            }
            return delay;
        }

        public void createConnectionsUponTopologyChange() {
            ClientImpl.this.m_ex.execute(new CreateConnectionTask(this, this.connectionTaskCount, 0));
        }

        public void createAnyConnection() {
            ClientImpl.this.m_ex.execute(new FirstConnectionTask(this, this.connectionTaskCount, 0));
        }
    }

    private final class SyncCallbackLight
    implements ProcedureCallback {
        private final Semaphore m_lock = new Semaphore(1);
        private ClientResponse m_response = null;

        public SyncCallbackLight() {
            this.m_lock.acquireUninterruptibly();
        }

        @Override
        public void clientCallback(ClientResponse clientResponse) {
            this.m_response = clientResponse;
            this.m_lock.release();
        }

        public ClientResponse getResponse() {
            return this.m_response;
        }

        public void waitForResponse() throws InterruptedException {
            this.m_lock.acquire();
            this.m_lock.release();
        }
    }

    private class SyncAllPartitionProcedureCallback
    implements AllPartitionProcedureCallback {
        ClientResponseWithPartitionKey[] m_responses;
        final CountDownLatch m_latch;

        SyncAllPartitionProcedureCallback(CountDownLatch latch) {
            this.m_latch = latch;
        }

        @Override
        public void clientCallback(ClientResponseWithPartitionKey[] clientResponse) throws Exception {
            this.m_responses = clientResponse;
            this.m_latch.countDown();
        }

        ClientResponseWithPartitionKey[] getResponse() {
            return this.m_responses;
        }
    }

    private class OnePartitionProcedureCallback
    implements ProcedureCallback {
        final ClientResponseWithPartitionKey[] m_responses;
        final int m_index;
        final Object m_partitionKey;
        final AtomicInteger m_partitionCounter;
        final AllPartitionProcedureCallback m_cb;
        final int m_partitionId;

        OnePartitionProcedureCallback(AtomicInteger counter, Object partitionKey, int index, ClientResponseWithPartitionKey[] responses, AllPartitionProcedureCallback cb, int partitionId) {
            this.m_partitionCounter = counter;
            this.m_partitionKey = partitionKey;
            this.m_index = index;
            this.m_responses = responses;
            this.m_cb = cb;
            this.m_partitionId = partitionId;
        }

        @Override
        public void clientCallback(ClientResponse response) throws Exception {
            this.m_responses[this.m_index] = new ClientResponseWithPartitionKey(this.m_partitionKey, response, this.m_partitionId);
            if (this.m_partitionCounter.decrementAndGet() == 0) {
                this.m_cb.clientCallback(this.m_responses);
            }
        }

        void exceptionCallback(Exception e) throws Exception {
            if (e instanceof ProcCallException) {
                ProcCallException pe = (ProcCallException)e;
                this.m_responses[this.m_index] = new ClientResponseWithPartitionKey(this.m_partitionKey, pe.getClientResponse(), this.m_partitionId);
            } else {
                byte status = -2;
                if (e instanceof NoConnectionsException) {
                    status = -4;
                }
                ClientResponseImpl r = new ClientResponseImpl(status, new VoltTable[0], e.getMessage());
                this.m_responses[this.m_index] = new ClientResponseWithPartitionKey(this.m_partitionKey, r, this.m_partitionId);
            }
            if (this.m_partitionCounter.decrementAndGet() == 0) {
                this.m_cb.clientCallback(this.m_responses);
            }
        }
    }

    private class FirstConnectionTask
    implements Runnable {
        final InternalClientStatusListener listener;
        final AtomicInteger connectionTaskCount;
        final LinkedHashSet<HostAndPort> targets;
        final int retryCount;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        FirstConnectionTask(InternalClientStatusListener listener, AtomicInteger connectionTaskCount, int retryCount) {
            this.listener = listener;
            this.connectionTaskCount = connectionTaskCount;
            this.retryCount = retryCount;
            Set<HostAndPort> set = ClientImpl.this.m_connectHistory;
            synchronized (set) {
                this.targets = new LinkedHashSet<HostAndPort>(ClientImpl.this.m_connectHistory);
                ClientImpl.this.m_newConnectEpoch = true;
            }
            connectionTaskCount.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int failCount = 0;
            try {
                for (HostAndPort hap : this.targets) {
                    try {
                        ClientImpl.this.createConnectionImpl(hap.getHost(), hap.getPort());
                        ClientImpl.this.setLocalBackpressureState(false);
                        break;
                    }
                    catch (Exception e) {
                        ++failCount;
                    }
                }
                if (this.targets.isEmpty()) {
                    this.listener.notifyAutoConnectFailure(null, ClientStatusListenerExt.AutoConnectionStatus.NO_KNOWN_SERVERS);
                }
            }
            finally {
                this.connectionTaskCount.decrementAndGet();
                this.listener.retryConnectionCreationIfNeeded(failCount, true, this.retryCount);
            }
        }
    }

    private class CreateConnectionTask
    implements Runnable {
        final InternalClientStatusListener listener;
        final AtomicInteger connectionTaskCount;
        final int retryCount;

        CreateConnectionTask(InternalClientStatusListener listener, AtomicInteger connectionTaskCount, int retryCount) {
            this.listener = listener;
            this.connectionTaskCount = connectionTaskCount;
            this.retryCount = retryCount;
            connectionTaskCount.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int failCount = 0;
            try {
                ClientResponse resp = ClientImpl.this.callProcedureWithClientTimeoutImpl(-1, "@SystemInformation", Distributer.TOPO_AWARE_PROC_TIMEOUT_NS, TimeUnit.NANOSECONDS, "OVERVIEW");
                if (resp.getStatus() == 1) {
                    Map<Integer, HostConfig> hosts = this.listener.buildUnconnectedHostConfigMap(resp.getResults()[0]);
                    for (Map.Entry<Integer, HostConfig> entry : hosts.entrySet()) {
                        HostConfig config = entry.getValue();
                        try {
                            ClientImpl.this.createConnectionImpl(config.m_ipAddress, config.getPort(this.listener.m_useAdminPort));
                        }
                        catch (Exception e) {
                            this.listener.notifyAutoConnectFailure(config, ClientStatusListenerExt.AutoConnectionStatus.UNABLE_TO_CONNECT);
                            ++failCount;
                        }
                    }
                } else {
                    this.listener.notifyAutoConnectFailure(null, ClientStatusListenerExt.AutoConnectionStatus.UNABLE_TO_QUERY_TOPOLOGY);
                    ++failCount;
                }
            }
            catch (Exception e) {
                this.listener.notifyAutoConnectFailure(null, ClientStatusListenerExt.AutoConnectionStatus.UNABLE_TO_QUERY_TOPOLOGY);
                ++failCount;
            }
            finally {
                this.connectionTaskCount.decrementAndGet();
                this.listener.retryConnectionCreationIfNeeded(failCount, false, this.retryCount);
            }
        }
    }

    private class HostConfig {
        String m_ipAddress;
        String m_hostName;
        int m_clientPort;
        int m_adminPort;

        private HostConfig() {
        }

        void setValue(String param, String value) {
            if ("IPADDRESS".equalsIgnoreCase(param)) {
                this.m_ipAddress = value;
            } else if ("HOSTNAME".equalsIgnoreCase(param)) {
                this.m_hostName = value;
            } else if ("CLIENTPORT".equalsIgnoreCase(param)) {
                this.m_clientPort = Integer.parseInt(value);
            } else if ("ADMINPORT".equalsIgnoreCase(param)) {
                this.m_adminPort = Integer.parseInt(value);
            }
        }

        int getPort(boolean isAdmin) {
            return isAdmin ? this.m_adminPort : this.m_clientPort;
        }
    }
}

