/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import org.voltcore.network.metrics.IOStatsData;

class ClientIOStats {
    long m_connectionId;
    long m_bytesSent;
    long m_bytesReceived;

    ClientIOStats(long connectionId, long bytesSent, long bytesReceived) {
        this.m_connectionId = connectionId;
        this.m_bytesSent = bytesSent;
        this.m_bytesReceived = bytesReceived;
    }

    ClientIOStats(IOStatsData input) {
        this.m_connectionId = input.getConnectionId();
        this.m_bytesSent = input.getBytesWritten();
        this.m_bytesReceived = input.getBytesRead();
    }

    public long getConnectionId() {
        return this.m_connectionId;
    }

    public static ClientIOStats diff(ClientIOStats newer, ClientIOStats older) {
        if (newer.m_connectionId != older.m_connectionId) {
            throw new IllegalArgumentException("Can't diff these ClientIOStats instances.");
        }
        ClientIOStats retval = new ClientIOStats(older.m_connectionId, newer.m_bytesSent - older.m_bytesSent, newer.m_bytesReceived - older.m_bytesReceived);
        return retval;
    }

    protected Object clone() {
        return new ClientIOStats(this.m_connectionId, this.m_bytesSent, this.m_bytesReceived);
    }
}

