/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import org.voltcore.network.ReverseDNSCache;
import org.voltcore.utils.EstTimeUpdater;
import org.voltdb.client.Client;
import org.voltdb.client.Client2;
import org.voltdb.client.Client2Config;
import org.voltdb.client.Client2Impl;
import org.voltdb.client.ClientAdapter;
import org.voltdb.client.ClientConfig;
import org.voltdb.client.ClientImpl;

public class ClientFactory {
    static int m_activeClientCount = 0;
    static boolean m_preserveResources = false;
    private static boolean m_forceClient2 = Boolean.parseBoolean(System.getenv("CLIENT2_COMPATIBILITY_API"));

    public static Client createClient() {
        return ClientFactory.createClient(new ClientConfig());
    }

    public static Client createClient(ClientConfig config) {
        if (m_forceClient2) {
            return ClientFactory.createCompatibleClient(config);
        }
        ClientFactory.start();
        return new ClientImpl(config);
    }

    public static Client2 createClient(Client2Config config) {
        ClientFactory.start();
        return new Client2Impl(config);
    }

    private static synchronized void start() {
        if (m_activeClientCount++ == 0 && !m_preserveResources) {
            EstTimeUpdater.start();
            ReverseDNSCache.start();
        }
    }

    private static Client createCompatibleClient(ClientConfig config) {
        ClientFactory.start();
        return new ClientAdapter(config);
    }

    public static synchronized void preserveResources() {
        m_preserveResources = true;
        EstTimeUpdater.start();
        ReverseDNSCache.start();
    }

    static synchronized void decreaseClientNum() throws InterruptedException {
        if (m_activeClientCount > 0 && --m_activeClientCount == 0 && !m_preserveResources) {
            EstTimeUpdater.stop();
            ReverseDNSCache.stop();
        }
    }
}

