/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class ClientConnectionRequestStats {
    private static long IDLE_DURATION = TimeUnit.MINUTES.toMillis(60L);
    private final int m_hostId;
    private final String m_host;
    private long m_lastUpdated;
    private AtomicLong m_totalReqs = new AtomicLong(0L);
    private AtomicLong m_totalResps = new AtomicLong(0L);

    public ClientConnectionRequestStats(int hostId, String host) {
        this.m_hostId = hostId;
        this.m_host = host;
        this.m_lastUpdated = System.currentTimeMillis();
    }

    public synchronized void reset() {
        this.m_totalReqs.set(0L);
        this.m_totalResps.set(0L);
    }

    public void incrementInvocation() {
        this.m_totalReqs.incrementAndGet();
        this.m_lastUpdated = System.currentTimeMillis();
    }

    public void incrementResponse() {
        this.m_totalResps.incrementAndGet();
        this.m_lastUpdated = System.currentTimeMillis();
    }

    public long getTotalInvocations() {
        return this.m_totalReqs.get();
    }

    public long getTotalResponses() {
        return this.m_totalResps.get();
    }

    public int getHostId() {
        return this.m_hostId;
    }

    public String getHost() {
        return this.m_host;
    }

    public boolean expired() {
        return System.currentTimeMillis() - this.m_lastUpdated > IDLE_DURATION;
    }
}

