/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import java.io.IOException;
import java.io.InputStream;
import java.math.RoundingMode;
import java.security.Principal;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.voltdb.client.ClientAuthScheme;
import org.voltdb.client.ClientSslSetup;
import org.voltdb.client.ClientStatusListenerExt;
import org.voltdb.client.DelegatePrincipal;
import org.voltdb.types.VoltDecimalHelper;

public class ClientConfig {
    private static final String DEFAULT_SSL_PROPS_FILE = "ssl-config";
    static final long DEFAULT_PROCEDURE_TIMEOUT_NANOS = TimeUnit.MINUTES.toNanos(2L);
    static final long DEFAULT_CONNECTION_TIMEOUT_MS = 120000L;
    static final long DEFAULT_INITIAL_CONNECTION_RETRY_INTERVAL_MS = 1000L;
    static final long DEFAULT_MAX_CONNECTION_RETRY_INTERVAL_MS = 8000L;
    static final long DEFAULT_NONBLOCKING_ASYNC_TIMEOUT_NANOS = 500000L;
    static final int DEFAULT_MAX_OUTSTANDING_TRANSACTIONS = 3000;
    static final int DEFAULT_BACKPRESSURE_QUEUE_REQUEST_LIMIT = 100;
    static final int DEFAULT_BACKPRESSURE_QUEUE_BYTE_LIMIT = 262144;
    static final int HIGHEST_PRIORITY = 1;
    static final int LOWEST_PRIORITY = 8;
    final ClientAuthScheme m_hashScheme;
    final String m_username;
    final String m_password;
    final boolean m_cleartext;
    final ClientStatusListenerExt m_listener;
    boolean m_heavyweight = false;
    int m_maxOutstandingTxns = 3000;
    int m_maxTransactionsPerSecond = Integer.MAX_VALUE;
    long m_procedureCallTimeoutNanos = DEFAULT_PROCEDURE_TIMEOUT_NANOS;
    long m_connectionResponseTimeoutMS = 120000L;
    Subject m_subject = null;
    long m_initialConnectionRetryIntervalMS = 1000L;
    long m_maxConnectionRetryIntervalMS = 8000L;
    ClientSslSetup.SslConfig m_sslConfig;
    boolean m_topologyChangeAware = false;
    boolean m_enableSSL = false;
    boolean m_enableSSLHostCheck = false;
    String m_sslPropsFile = null;
    boolean m_nonblocking = false;
    long m_asyncBlockingTimeout = 500000L;
    int m_backpressureQueueRequestLimit = 100;
    int m_backpressureQueueByteLimit = 262144;
    int m_requestPriority = -1;
    public static final boolean ENABLE_SSL_FOR_TEST = Boolean.valueOf(System.getenv("ENABLE_SSL") == null ? Boolean.toString(Boolean.getBoolean("ENABLE_SSL")) : System.getenv("ENABLE_SSL"));

    static final String getUserNameFromSubject(Subject subject) {
        if (subject == null || subject.getPrincipals() == null || subject.getPrincipals().isEmpty()) {
            throw new IllegalArgumentException("Subject is null or does not contain principals");
        }
        Iterator<Principal> piter = subject.getPrincipals().iterator();
        Principal principal = piter.next();
        String username = principal.getName();
        while (piter.hasNext()) {
            principal = piter.next();
            if (!(principal instanceof DelegatePrincipal)) continue;
            username = principal.getName();
            break;
        }
        return username;
    }

    public ClientConfig() {
        this("", "", true, null, ClientAuthScheme.HASH_SHA256);
    }

    public ClientConfig(String username, String password) {
        this(username, password, true, null, ClientAuthScheme.HASH_SHA256);
    }

    public ClientConfig(String username, String password, ClientStatusListenerExt listener) {
        this(username, password, true, listener, ClientAuthScheme.HASH_SHA256);
    }

    public ClientConfig(String username, String password, ClientStatusListenerExt listener, ClientAuthScheme scheme) {
        this(username, password, true, listener, scheme);
    }

    public ClientConfig(String username, String password, boolean cleartext, ClientStatusListenerExt listener) {
        this(username, password, cleartext, listener, ClientAuthScheme.HASH_SHA256);
    }

    public ClientConfig(Subject subject, ClientStatusListenerExt listener) {
        this(ClientConfig.getUserNameFromSubject(subject), "", true, listener, ClientAuthScheme.HASH_SHA256);
        this.m_subject = subject;
    }

    public ClientConfig(String username, String password, boolean cleartext, ClientStatusListenerExt listener, ClientAuthScheme scheme) {
        if (ENABLE_SSL_FOR_TEST) {
            try (InputStream is = ClientConfig.class.getResourceAsStream(DEFAULT_SSL_PROPS_FILE);){
                Properties sslProperties = new Properties();
                sslProperties.load(is);
                String trustStorePath = sslProperties.getProperty("trustStore");
                String trustStorePassword = sslProperties.getProperty("trustStorePassword");
                this.setTrustStore(trustStorePath, trustStorePassword);
                this.enableSSL();
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Unable to access TLS/SSL configuration: " + ex.getMessage());
            }
        }
        this.m_username = username == null ? "" : username;
        this.m_password = password == null ? "" : password;
        this.m_listener = listener;
        this.m_cleartext = cleartext;
        this.m_hashScheme = scheme;
    }

    public void setProcedureCallTimeout(long ms) {
        this.m_procedureCallTimeoutNanos = ms > 0L ? TimeUnit.MILLISECONDS.toNanos(ms) : Long.MAX_VALUE;
    }

    public void setConnectionResponseTimeout(long ms) {
        this.m_connectionResponseTimeoutMS = ms > 0L ? ms : Long.MAX_VALUE;
    }

    public void setHeavyweight(boolean heavyweight) {
        this.m_heavyweight = heavyweight;
    }

    public void setMaxOutstandingTxns(int maxOutstanding) {
        this.m_maxOutstandingTxns = maxOutstanding > 0 ? maxOutstanding : 3000;
    }

    public int getMaxOutstandingTxns() {
        return this.m_maxOutstandingTxns;
    }

    public void setMaxTransactionsPerSecond(int maxTxnsPerSecond) {
        if (this.m_nonblocking) {
            throw new IllegalStateException("Cannot set limit on TPS with non-blocking async");
        }
        this.m_maxTransactionsPerSecond = Math.max(1, maxTxnsPerSecond);
    }

    public void setNonblockingAsync() {
        this.setNonblockingAsync(500000L);
    }

    public void setNonblockingAsync(long blockingTimeout) {
        if (this.m_maxTransactionsPerSecond != Integer.MAX_VALUE) {
            throw new IllegalStateException("Cannot set non-blocking with limit on TPS");
        }
        this.m_nonblocking = true;
        this.m_asyncBlockingTimeout = Math.max(0L, blockingTimeout);
    }

    public long getNonblockingAsync() {
        return this.m_nonblocking ? this.m_asyncBlockingTimeout : -1L;
    }

    public void setBackpressureQueueThresholds(int reqLimit, int byteLimit) {
        this.m_backpressureQueueRequestLimit = reqLimit > 0 ? reqLimit : 100;
        this.m_backpressureQueueByteLimit = byteLimit > 0 ? byteLimit : 262144;
    }

    public int[] getBackpressureQueueThresholds() {
        return new int[]{this.m_backpressureQueueRequestLimit, this.m_backpressureQueueByteLimit};
    }

    public void setTopologyChangeAware(boolean enabled) {
        this.m_topologyChangeAware = enabled;
    }

    public void setInitialConnectionRetryInterval(long ms) {
        this.m_initialConnectionRetryIntervalMS = ms;
    }

    public void setMaxConnectionRetryInterval(long ms) {
        this.m_maxConnectionRetryIntervalMS = ms;
    }

    public void enableKerberosAuthentication(Subject subject) {
        this.m_subject = subject;
    }

    public void enableKerberosAuthentication(String loginContextEntryKey) {
        try {
            LoginContext lc = new LoginContext(loginContextEntryKey);
            lc.login();
            this.m_subject = lc.getSubject();
        }
        catch (SecurityException | LoginException ex) {
            throw new IllegalArgumentException("Cannot determine client consumer's credentials: " + ex.getMessage());
        }
    }

    public static void setRoundingConfig(boolean isEnabled, RoundingMode mode) {
        VoltDecimalHelper.setRoundingConfig(isEnabled, mode);
    }

    public void setTrustStore(String pathToTrustStore, String trustStorePassword) {
        this.m_sslConfig = ClientSslSetup.createSslConfig(pathToTrustStore, trustStorePassword);
    }

    public void setTrustStoreConfigFromPropertyFile(String propFile) {
        this.m_sslConfig = propFile == null || propFile.isEmpty() ? ClientSslSetup.sslConfigFromDefaults() : ClientSslSetup.sslConfigFromPropertyFile(propFile);
    }

    public void setTrustStoreConfigFromFile(String filename) {
        this.m_sslConfig = filename == null || filename.isEmpty() ? ClientSslSetup.sslConfigFromDefaults() : ClientSslSetup.sslConfigTrustStoreGeneric(filename);
    }

    public void setTrustStoreConfigFromDefault() {
        this.m_sslConfig = ClientSslSetup.sslConfigFromDefaults();
    }

    public void enableSSL() {
        this.m_enableSSL = true;
        if (this.m_sslConfig == null) {
            this.m_sslConfig = ClientSslSetup.sslConfigFromDefaults();
        }
    }

    public void enableSSLHostCheck() {
        this.m_enableSSLHostCheck = true;
    }

    public void setRequestPriority(int prio) {
        if (prio < 1 || prio > 8) {
            String err = String.format("Invalid request priority %d; range is %d to %d", prio, 1, 8);
            throw new IllegalArgumentException(err);
        }
        this.m_requestPriority = prio;
    }
}

