/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

public class ClientAffinityStats {
    private int m_partitionId;
    private long m_affinityWrites;
    private long m_rrWrites;
    private long m_affinityReads;
    private long m_rrReads;

    ClientAffinityStats(int partitionId) {
        this.m_partitionId = partitionId;
    }

    ClientAffinityStats(int partitionId, long affinityWrites, long rrWrites, long affinityReads, long rrReads) {
        this.m_partitionId = partitionId;
        this.m_affinityWrites = affinityWrites;
        this.m_rrWrites = rrWrites;
        this.m_affinityReads = affinityReads;
        this.m_rrReads = rrReads;
    }

    public static ClientAffinityStats diff(ClientAffinityStats newer, ClientAffinityStats older) {
        if (newer.m_partitionId != older.m_partitionId) {
            throw new IllegalArgumentException("Can't diff these ClientAffinityStats instances.");
        }
        ClientAffinityStats retval = new ClientAffinityStats(older.m_partitionId, newer.m_affinityWrites - older.m_affinityWrites, newer.m_rrWrites - older.m_rrWrites, newer.m_affinityReads - older.m_affinityReads, newer.m_rrReads - older.m_rrReads);
        return retval;
    }

    protected Object clone() {
        return new ClientAffinityStats(this.m_partitionId, this.m_affinityWrites, this.m_rrWrites, this.m_affinityReads, this.m_rrReads);
    }

    void addAffinityWrite() {
        ++this.m_affinityWrites;
    }

    public long getAffinityWrites() {
        return this.m_affinityWrites;
    }

    void addRrWrite() {
        ++this.m_rrWrites;
    }

    public long getRrWrites() {
        return this.m_rrWrites;
    }

    void addAffinityRead() {
        ++this.m_affinityReads;
    }

    public long getAffinityReads() {
        return this.m_affinityReads;
    }

    void addRrRead() {
        ++this.m_rrReads;
    }

    public long getRrReads() {
        return this.m_rrReads;
    }

    public String toString() {
        String afdisplay = "Partition ID %d:  %d affinity writes, %d affinity reads, %d round-robin writes, %d round-robin reads";
        return String.format(afdisplay, this.m_partitionId, this.m_affinityWrites, this.m_affinityReads, this.m_rrWrites, this.m_rrReads);
    }
}

