/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.voltdb.client.AllPartitionProcedureCallback;
import org.voltdb.client.Client;
import org.voltdb.client.Client2;
import org.voltdb.client.Client2CallOptions;
import org.voltdb.client.Client2Config;
import org.voltdb.client.Client2Impl;
import org.voltdb.client.ClientConfig;
import org.voltdb.client.ClientResponse;
import org.voltdb.client.ClientResponseWithPartitionKey;
import org.voltdb.client.ClientStats;
import org.voltdb.client.ClientStatsContext;
import org.voltdb.client.ClientStatsUtil;
import org.voltdb.client.ClientStatusListenerExt;
import org.voltdb.client.ProcCallException;
import org.voltdb.client.ProcedureCallback;
import org.voltdb.client.RequestLimitException;
import org.voltdb.client.UpdateClasses;
import org.voltdb.client.VoltBulkLoader.BulkLoaderFailureCallBack;
import org.voltdb.client.VoltBulkLoader.BulkLoaderSuccessCallback;
import org.voltdb.client.VoltBulkLoader.VoltBulkLoader;

public class ClientAdapter
implements Client {
    private Client2 client;
    private boolean autoConnect;
    private int maxOutstandingTxns;
    private int maxTransactionsPerSecond;

    public ClientAdapter(ClientConfig config) {
        this.client = new Client2Impl(this.convertConfig(config));
        this.autoConnect = config.m_topologyChangeAware;
        this.maxOutstandingTxns = config.m_maxOutstandingTxns;
        this.maxTransactionsPerSecond = config.m_maxTransactionsPerSecond;
    }

    @Override
    public void createConnection(String server) throws IOException {
        this.client.connectSync(server);
    }

    @Override
    public void createConnection(String host, int port) throws IOException {
        this.client.connectSync(host, port);
    }

    @Override
    public void createAnyConnection(String serverList) throws IOException {
        this.client.connectSync(serverList);
    }

    @Override
    public void createAnyConnection(String serverList, long timeout, long delay) throws IOException {
        this.client.connectSync(serverList, timeout, delay, TimeUnit.MILLISECONDS);
    }

    @Override
    public ClientResponse callProcedure(String procName, Object ... parameters) throws IOException, ProcCallException {
        return this.client.callProcedureSync(procName, parameters);
    }

    @Override
    public boolean callProcedure(ProcedureCallback callback, String procName, Object ... parameters) {
        AtomicBoolean refused = new AtomicBoolean();
        ((CompletableFuture)this.client.callProcedureAsync(procName, parameters).thenAccept(r -> this.callback((ClientResponse)r, callback))).exceptionally(x -> this.except((Throwable)x, refused));
        return !refused.get();
    }

    @Override
    public ClientResponse callProcedureWithTimeout(int queryTimeout, String procName, Object ... parameters) throws IOException, ProcCallException {
        Client2CallOptions opts = new Client2CallOptions().queryTimeout(queryTimeout, TimeUnit.MILLISECONDS);
        return this.client.callProcedureSync(opts, procName, parameters);
    }

    @Override
    public boolean callProcedureWithTimeout(ProcedureCallback callback, int queryTimeout, String procName, Object ... parameters) {
        AtomicBoolean refused = new AtomicBoolean();
        Client2CallOptions opts = new Client2CallOptions().queryTimeout(queryTimeout, TimeUnit.MILLISECONDS);
        ((CompletableFuture)this.client.callProcedureAsync(opts, procName, parameters).thenAccept(r -> this.callback((ClientResponse)r, callback))).exceptionally(x -> this.except((Throwable)x, refused));
        return !refused.get();
    }

    @Override
    public ClientResponse callProcedureWithClientTimeout(int queryTimeout, String procName, long clientTimeout, TimeUnit unit, Object ... parameters) throws IOException, ProcCallException {
        Client2CallOptions opts = new Client2CallOptions().queryTimeout(queryTimeout, TimeUnit.MILLISECONDS).clientTimeout(clientTimeout, unit);
        return this.client.callProcedureSync(opts, procName, parameters);
    }

    @Override
    public boolean callProcedureWithClientTimeout(ProcedureCallback callback, int queryTimeout, String procName, long clientTimeout, TimeUnit unit, Object ... parameters) {
        AtomicBoolean refused = new AtomicBoolean();
        Client2CallOptions opts = new Client2CallOptions().queryTimeout(queryTimeout, TimeUnit.MILLISECONDS).clientTimeout(clientTimeout, unit);
        ((CompletableFuture)this.client.callProcedureAsync(opts, procName, parameters).thenAccept(r -> this.callback((ClientResponse)r, callback))).exceptionally(x -> this.except((Throwable)x, refused));
        return !refused.get();
    }

    @Override
    public ClientResponseWithPartitionKey[] callAllPartitionProcedure(String procName, Object ... params) throws IOException, ProcCallException {
        return this.client.callAllPartitionProcedureSync(null, procName, params);
    }

    @Override
    public boolean callAllPartitionProcedure(AllPartitionProcedureCallback callback, String procName, Object ... params) {
        AtomicBoolean refused = new AtomicBoolean();
        ((CompletableFuture)this.client.callAllPartitionProcedureAsync(null, procName, params).thenAccept(r -> this.callback((ClientResponseWithPartitionKey[])r, callback))).exceptionally(x -> this.except((Throwable)x, refused));
        return !refused.get();
    }

    @Override
    public void drain() throws InterruptedException {
        this.client.drain();
    }

    @Override
    public void close() throws InterruptedException {
        this.client.close();
    }

    @Override
    public void backpressureBarrier() throws InterruptedException {
        throw new UnsupportedOperationException("unsupported: ClientAdapter.backpressureBarrier");
    }

    @Override
    public ClientStatsContext createStatsContext() {
        return this.client.createStatsContext();
    }

    @Override
    public Object[] getInstanceId() {
        return this.client.clusterInstanceId();
    }

    @Override
    public String getBuildString() {
        return this.client.clusterBuildString();
    }

    @Override
    public int[] getThroughputAndOutstandingTxnLimits() {
        return new int[]{this.maxTransactionsPerSecond, this.maxOutstandingTxns};
    }

    @Override
    public List<InetSocketAddress> getConnectedHostList() {
        return this.client.connectedHosts();
    }

    @Override
    public boolean isAutoReconnectEnabled() {
        return this.autoConnect;
    }

    @Override
    public boolean isTopologyChangeAwareEnabled() {
        return this.autoConnect;
    }

    @Override
    public void writeSummaryCSV(String statsRowName, ClientStats stats, String path) throws IOException {
        if (path != null && !path.isEmpty()) {
            ClientStatsUtil.writeSummaryCSV(statsRowName, stats, path);
        }
    }

    @Override
    public void writeSummaryCSV(ClientStats stats, String path) throws IOException {
        this.writeSummaryCSV(null, stats, path);
    }

    @Override
    public ClientResponse updateClasses(File jarPath, String classesToDelete) throws IOException, ProcCallException {
        return UpdateClasses.update(this, jarPath, classesToDelete);
    }

    @Override
    public boolean updateClasses(ProcedureCallback callback, File jarPath, String classesToDelete) throws IOException {
        return UpdateClasses.update(this, callback, jarPath, classesToDelete);
    }

    @Override
    public VoltBulkLoader getNewBulkLoader(String tableName, int maxBatchSize, BulkLoaderFailureCallBack failureCallback) throws Exception {
        return this.getNewBulkLoader(tableName, maxBatchSize, false, failureCallback, null);
    }

    @Override
    public VoltBulkLoader getNewBulkLoader(String tableName, int maxBatchSize, boolean upsertMode, BulkLoaderFailureCallBack failureCallback) throws Exception {
        return this.getNewBulkLoader(tableName, maxBatchSize, upsertMode, failureCallback, null);
    }

    @Override
    public VoltBulkLoader getNewBulkLoader(String tableName, int maxBatchSize, boolean upsertMode, BulkLoaderFailureCallBack failureCallback, BulkLoaderSuccessCallback successCallback) throws Exception {
        return this.client.newBulkLoader(tableName, maxBatchSize, upsertMode, failureCallback, successCallback);
    }

    @Override
    public boolean waitForTopology(long timeout) {
        return this.client.waitForTopology(timeout, TimeUnit.MILLISECONDS);
    }

    private Void callback(ClientResponse resp, ProcedureCallback cb) {
        try {
            cb.clientCallback(resp);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return null;
    }

    private Void callback(ClientResponseWithPartitionKey[] resp, AllPartitionProcedureCallback cb) {
        try {
            cb.clientCallback(resp);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return null;
    }

    private Void except(Throwable th, AtomicBoolean refused) {
        if (th instanceof RequestLimitException) {
            refused.set(true);
            return null;
        }
        throw new RuntimeException(th);
    }

    private Client2Config convertConfig(ClientConfig c1) {
        Client2Config c2 = new Client2Config();
        c2.username(c1.m_username);
        if (c1.m_password != null && !c1.m_password.isEmpty()) {
            if (c1.m_cleartext) {
                c2.password(c1.m_password);
            } else {
                c2.hashedPassword(c1.m_password, c1.m_hashScheme);
            }
        } else if (c1.m_subject != null) {
            c2.authenticatedSubject(c1.m_subject);
        }
        if (c1.m_enableSSL) {
            c2.sslConfig = c1.m_sslConfig;
            c2.enableSSL();
        }
        if (c1.m_enableSSLHostCheck) {
            c2.enableSSLHostCheck();
        }
        c2.procedureCallTimeout(c1.m_procedureCallTimeoutNanos, TimeUnit.NANOSECONDS).outstandingTransactionLimit(c1.m_maxOutstandingTxns).clientRequestBackpressureLevel(c1.m_backpressureQueueRequestLimit, (int)(1.25 * (double)c1.m_backpressureQueueRequestLimit)).connectionResponseTimeout(c1.m_connectionResponseTimeoutMS, TimeUnit.MILLISECONDS).reconnectDelay(c1.m_initialConnectionRetryIntervalMS, c1.m_maxConnectionRetryIntervalMS, TimeUnit.MILLISECONDS);
        if (!c1.m_topologyChangeAware) {
            c2.disableConnectionMgmt();
        }
        if (c1.m_maxTransactionsPerSecond < 0x3FFFFFFF) {
            c2.transactionRateLimit(c1.m_maxTransactionsPerSecond);
        }
        if (c1.m_heavyweight) {
            throw new UnsupportedOperationException("unsupported: heavyweight clients");
        }
        if (c1.m_listener != null) {
            c2.connectFailureHandler((host, port) -> c1.m_listener.connectionCreated(host, port, ClientStatusListenerExt.AutoConnectionStatus.UNABLE_TO_CONNECT));
            c2.connectionUpHandler((host, port) -> c1.m_listener.connectionCreated(host, port, ClientStatusListenerExt.AutoConnectionStatus.SUCCESS));
            c2.connectionDownHandler((host, port) -> c1.m_listener.connectionLost(host, port, this.client.connectedHosts().size(), ClientStatusListenerExt.DisconnectCause.CONNECTION_CLOSED));
            c2.requestBackpressureHandler(c1.m_listener::backpressure);
            c2.lateResponseHandler(c1.m_listener::lateProcedureResponse);
        }
        if (c1.m_requestPriority > 0) {
            c2.requestPriority(c1.m_requestPriority);
        }
        return c2;
    }
}

