/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Client2RequestGate {
    private boolean closed = false;

    public synchronized void waitOpen() throws InterruptedException {
        while (this.closed) {
            this.wait();
        }
    }

    public synchronized void waitOpen(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        if (this.closed) {
            long start;
            long tmoNs = unit.toNanos(timeout);
            long now = start = System.nanoTime();
            while (this.closed) {
                long remaining = tmoNs - (now - start);
                if (remaining <= 0L) {
                    throw new TimeoutException("request gate wait timed out");
                }
                this.wait(remaining);
                now = System.nanoTime();
            }
        }
    }

    public synchronized void operate(boolean closing) {
        this.closed = closing;
        if (!this.closed) {
            this.notifyAll();
        }
    }
}

