/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import java.math.RoundingMode;
import java.security.Principal;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.voltdb.client.Client2Impl;
import org.voltdb.client.Client2Notification;
import org.voltdb.client.ClientAuthScheme;
import org.voltdb.client.ClientSslSetup;
import org.voltdb.client.DelegatePrincipal;
import org.voltdb.types.VoltDecimalHelper;

public class Client2Config {
    public static final long DEFAULT_CONNECTION_SETUP_TIMEOUT = Client2Impl.DEFAULT_CONNECTION_SETUP_TIMEOUT;
    public static final long DEFAULT_CONNECTION_RESPONSE_TIMEOUT = Client2Impl.DEFAULT_CONNECTION_RESPONSE_TIMEOUT;
    public static final long DEFAULT_PROCEDURE_TIMEOUT = Client2Impl.DEFAULT_PROCEDURE_TIMEOUT;
    public static final int DEFAULT_CLIENT_REQUEST_HARD_LIMIT = 1000;
    public static final int DEFAULT_CLIENT_REQUEST_WARNING_LEVEL = 800;
    public static final int DEFAULT_CLIENT_REQUEST_RESUME_LEVEL = 200;
    public static final int DEFAULT_OUTSTANDING_TRANSACTION_LIMIT = 100;
    public static final int DEFAULT_NETWORK_BACKPRESSURE_LEVEL = 100;
    public static final long DEFAULT_RECONNECT_DELAY = Client2Impl.DEFAULT_RECONNECT_DELAY;
    public static final long DEFAULT_RECONNECT_RETRY_DELAY = Client2Impl.DEFAULT_RECONNECT_RETRY_DELAY;
    public static final int DEFAULT_REQUEST_PRIORITY = 4;
    public static final int DEFAULT_RESPONSE_THREADS = 4;
    public static final int HIGHEST_PRIORITY = 1;
    public static final int LOWEST_PRIORITY = 8;
    String username = "";
    String password = "";
    boolean cleartext = true;
    ClientAuthScheme hashScheme = ClientAuthScheme.HASH_SHA256;
    Subject subject = null;
    ClientSslSetup.SslConfig sslConfig = null;
    boolean enableSsl = false;
    boolean enableSslHostCheck = false;
    long connectionSetupTimeout = DEFAULT_CONNECTION_SETUP_TIMEOUT;
    long connectionResponseTimeout = DEFAULT_CONNECTION_RESPONSE_TIMEOUT;
    long procedureCallTimeout = DEFAULT_PROCEDURE_TIMEOUT;
    int requestHardLimit = 1000;
    int requestWarningLevel = 800;
    int requestResumeLevel = 200;
    int outstandingTxnLimit = 100;
    int txnPerSecRateLimit = 0;
    int networkBackpressureLevel = 100;
    long reconnectDelay = DEFAULT_RECONNECT_DELAY;
    long reconnectRetryDelay = DEFAULT_RECONNECT_RETRY_DELAY;
    boolean disableConnectionMgmt = false;
    int requestPriority = 4;
    Client2Notification.ConnectionStatus notificationConnectFailure = null;
    Client2Notification.ConnectionStatus notificationConnectionUp = null;
    Client2Notification.ConnectionStatus notificationConnectionDown = null;
    Client2Notification.LateResponse notificationLateResponse = null;
    Client2Notification.RequestBackpressure notificationRequestBackpressure = null;
    Client2Notification.ErrorLog notificationErrorLog = null;
    int responseThreadCount = 4;
    ExecutorService responseExecutorService = null;
    boolean stopResponseServiceOnClose = true;

    public Client2Config username(String username) {
        this.subject = null;
        this.username = Client2Config.notNull(username);
        return this;
    }

    public Client2Config password(String password) {
        this.password = Client2Config.notNull(password);
        this.cleartext = true;
        this.hashScheme = ClientAuthScheme.HASH_SHA256;
        return this;
    }

    public Client2Config hashedPassword(String password) {
        this.password = Client2Config.notNull(password);
        this.cleartext = false;
        this.hashScheme = ClientAuthScheme.HASH_SHA256;
        return this;
    }

    public Client2Config hashedPassword(String password, ClientAuthScheme hashScheme) {
        this.password = Client2Config.notNull(password);
        this.cleartext = false;
        this.hashScheme = hashScheme;
        return this;
    }

    public Client2Config authenticatedSubject(Subject subject) {
        this.subject = subject;
        this.username = Client2Config.getUserNameFromSubject(subject);
        this.password = "";
        this.cleartext = true;
        this.hashScheme = ClientAuthScheme.HASH_SHA256;
        return this;
    }

    public Client2Config loginContext(String name) {
        try {
            LoginContext lc = new LoginContext(name);
            lc.login();
            return this.authenticatedSubject(lc.getSubject());
        }
        catch (SecurityException | LoginException ex) {
            throw new IllegalArgumentException("Cannot determine client consumer's credentials: " + ex.getMessage());
        }
    }

    public Client2Config connectionSetupTimeout(long timeout, TimeUnit unit) {
        this.connectionSetupTimeout = timeout > 0L ? unit.toNanos(timeout) : Long.MAX_VALUE;
        return this;
    }

    public Client2Config connectionResponseTimeout(long timeout, TimeUnit unit) {
        this.connectionResponseTimeout = timeout > 0L ? unit.toNanos(timeout) : Long.MAX_VALUE;
        return this;
    }

    public Client2Config procedureCallTimeout(long timeout, TimeUnit unit) {
        this.procedureCallTimeout = timeout > 0L ? unit.toNanos(timeout) : Long.MAX_VALUE;
        return this;
    }

    public Client2Config clientRequestLimit(int limit) {
        this.requestHardLimit = Math.max(1, limit);
        return this;
    }

    public Client2Config clientRequestBackpressureLevel(int warning, int resume) {
        this.requestWarningLevel = Math.max(1, warning);
        this.requestResumeLevel = Math.max(this.requestWarningLevel, resume);
        return this;
    }

    public Client2Config outstandingTransactionLimit(int limit) {
        this.outstandingTxnLimit = Math.max(1, limit);
        return this;
    }

    public Client2Config transactionRateLimit(int tpsLimit) {
        this.txnPerSecRateLimit = Math.max(1, tpsLimit);
        return this;
    }

    public Client2Config networkBackpressureLevel(int level) {
        this.networkBackpressureLevel = Math.max(1, level);
        return this;
    }

    public Client2Config reconnectDelay(long initialDelay, long retryDelay, TimeUnit unit) {
        this.reconnectDelay = unit.toNanos(Math.max(1L, initialDelay));
        this.reconnectRetryDelay = unit.toNanos(Math.max(1L, retryDelay));
        return this;
    }

    public Client2Config disableConnectionMgmt() {
        this.disableConnectionMgmt = true;
        return this;
    }

    public Client2Config requestPriority(int prio) {
        this.requestPriority = Client2Config.checkRequestPriority(prio);
        return this;
    }

    public Client2Config trustStoreFromPropertyFile(String path) {
        this.sslConfig = path == null || path.isEmpty() ? ClientSslSetup.sslConfigFromDefaults() : ClientSslSetup.sslConfigFromPropertyFile(path);
        return this;
    }

    public Client2Config trustStoreFromFile(String path) {
        this.sslConfig = path == null || path.isEmpty() ? ClientSslSetup.sslConfigFromDefaults() : ClientSslSetup.sslConfigTrustStoreGeneric(path);
        return this;
    }

    public Client2Config defaultTrustStore() {
        this.sslConfig = ClientSslSetup.sslConfigFromDefaults();
        return this;
    }

    public Client2Config trustStore(String path, String password) {
        this.sslConfig = ClientSslSetup.createSslConfig(path, password);
        return this;
    }

    public Client2Config enableSSL() {
        this.enableSsl = true;
        if (this.sslConfig == null) {
            this.sslConfig = ClientSslSetup.sslConfigFromDefaults();
        }
        return this;
    }

    public Client2Config enableSSLHostCheck() {
        this.enableSslHostCheck = true;
        return this;
    }

    public Client2Config connectFailureHandler(Client2Notification.ConnectionStatus handler) {
        this.notificationConnectFailure = handler;
        return this;
    }

    public Client2Config connectionUpHandler(Client2Notification.ConnectionStatus handler) {
        this.notificationConnectionUp = handler;
        return this;
    }

    public Client2Config connectionDownHandler(Client2Notification.ConnectionStatus handler) {
        this.notificationConnectionDown = handler;
        return this;
    }

    public Client2Config lateResponseHandler(Client2Notification.LateResponse handler) {
        this.notificationLateResponse = handler;
        return this;
    }

    public Client2Config requestBackpressureHandler(Client2Notification.RequestBackpressure handler) {
        this.notificationRequestBackpressure = handler;
        return this;
    }

    public Client2Config errorLogHandler(Client2Notification.ErrorLog handler) {
        this.notificationErrorLog = handler;
        return this;
    }

    public Client2Config responseThreadCount(int count) {
        this.responseThreadCount = Math.max(1, count);
        return this;
    }

    public Client2Config responseExecutorService(ExecutorService execService, boolean stopOnClose) {
        this.responseExecutorService = execService;
        this.stopResponseServiceOnClose = stopOnClose;
        return this;
    }

    public Client2Config roundingMode(boolean enable, RoundingMode mode) {
        VoltDecimalHelper.setRoundingConfig(enable, mode);
        return this;
    }

    private static String notNull(String str) {
        return str != null ? str : "";
    }

    private static String getUserNameFromSubject(Subject subject) {
        if (subject == null) {
            throw new IllegalArgumentException("Null subject");
        }
        Iterator<Principal> piter = subject.getPrincipals().iterator();
        if (!piter.hasNext()) {
            throw new IllegalArgumentException("Subject does not contain principals");
        }
        Principal principal = piter.next();
        String username = principal.getName();
        while (piter.hasNext()) {
            principal = piter.next();
            if (!(principal instanceof DelegatePrincipal)) continue;
            username = principal.getName();
            break;
        }
        return username;
    }

    static int checkRequestPriority(int prio) {
        if (prio < 1 || prio > 8) {
            String err = String.format("Invalid request priority %d; range is %d to %d", prio, 1, 8);
            throw new IllegalArgumentException(err);
        }
        return prio;
    }
}

