/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

public enum BatchTimeoutOverrideType {
    NO_OVERRIDE_FOR_BATCH_TIMEOUT(-1),
    HAS_OVERRIDE_FOR_BATCH_TIMEOUT(1);

    private final byte m_value;
    public static final int BATCH_TIMEOUT_VERSION = 1;
    public static final int NO_TIMEOUT = -1;
    public static final int DEFAULT_TIMEOUT = 10000;

    private BatchTimeoutOverrideType(byte val) {
        this.m_value = val;
    }

    public byte getValue() {
        return this.m_value;
    }

    public static BatchTimeoutOverrideType typeFromByte(byte b) {
        switch (b) {
            case -1: {
                return NO_OVERRIDE_FOR_BATCH_TIMEOUT;
            }
            case 1: {
                return HAS_OVERRIDE_FOR_BATCH_TIMEOUT;
            }
        }
        throw new RuntimeException("Unknown BatchTimeoutType " + b);
    }

    public static boolean isUserSetTimeout(int timeout) {
        return timeout >= 0;
    }

    public String toString() {
        return "BatchTimeoutType." + this.name();
    }

    public static String toString(int timeout) {
        if (timeout > 0) {
            return HAS_OVERRIDE_FOR_BATCH_TIMEOUT.toString() + " with value(millis): " + timeout;
        }
        if (timeout == 0) {
            return HAS_OVERRIDE_FOR_BATCH_TIMEOUT.toString() + " with infinite time";
        }
        return NO_OVERRIDE_FOR_BATCH_TIMEOUT.toString();
    }
}

