/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import org.json_voltpatches.JSONException;
import org.json_voltpatches.JSONStringer;
import org.voltdb.VoltTable;
import org.voltdb.VoltType;
import org.voltdb.types.GeographyPointValue;
import org.voltdb.types.GeographyValue;
import org.voltdb.types.TimestampType;
import org.voltdb.types.VoltDecimalHelper;
import org.voltdb.utils.Encoder;
import org.voltdb.utils.VoltTypeUtil;

public abstract class VoltTableRow {
    public static final int MAX_TUPLE_LENGTH = 0x200000;
    public static final String MAX_TUPLE_LENGTH_STR = String.valueOf(2048) + "k";
    static final int ROW_HEADER_SIZE = 4;
    static final int ROW_COUNT_SIZE = 4;
    static final int STRING_LEN_SIZE = 4;
    static final int VARBINARY_LEN_SIZE = 4;
    static final int INVALID_ROW_INDEX = -1;
    ByteBuffer m_buffer;
    boolean m_wasNull = false;
    int m_position = -1;
    int[] m_offsets;
    boolean m_hasCalculatedOffsets = false;
    int m_activeRowIndex = -1;
    static final String GEOJSON_TYPE_KEY = "type";
    static final String GEOJSON_COORDS_KEY = "coordinates";
    static final String GEOJSON_POINT_TYPE_SIGIL = "Point";
    static final String GEOJSON_POLYGON_TYPE_SIGIL = "Polygon";

    VoltTableRow() {
    }

    public abstract VoltType getColumnType(int var1);

    public abstract int getColumnIndex(String var1);

    public abstract int getColumnCount();

    abstract int getRowCount();

    abstract int getRowStart();

    abstract byte[] getSchemaString();

    public abstract VoltTableRow cloneRow();

    private final void ensureCalculatedOffsets() {
        if (this.m_hasCalculatedOffsets) {
            return;
        }
        this.m_offsets[0] = this.m_position;
        for (int i = 1; i < this.getColumnCount(); ++i) {
            VoltType type = this.getColumnType(i - 1);
            if (type.isVariableLength()) {
                int len = this.m_buffer.getInt(this.m_offsets[i - 1]);
                if (len == -1) {
                    this.m_offsets[i] = this.m_offsets[i - 1] + 4;
                    continue;
                }
                if (len < 0) {
                    throw new RuntimeException("Invalid object length for column: " + i);
                }
                this.m_offsets[i] = this.m_offsets[i - 1] + len + 4;
                continue;
            }
            this.m_offsets[i] = this.m_offsets[i - 1] + type.getLengthInBytesForFixedTypes();
        }
        this.m_hasCalculatedOffsets = true;
    }

    public final int getOffset(int index) {
        this.ensureCalculatedOffsets();
        assert (index >= 0);
        assert (index < this.m_offsets.length);
        return this.m_offsets[index];
    }

    public void resetRowPosition() {
        this.m_activeRowIndex = -1;
    }

    public int getActiveRowIndex() {
        return this.m_activeRowIndex;
    }

    public boolean advanceRow() {
        return this.advanceToRow(this.m_activeRowIndex + 1);
    }

    public boolean advanceToRow(int rowIndex) {
        int rows_to_move = rowIndex - this.m_activeRowIndex;
        this.m_activeRowIndex = rowIndex;
        if (this.m_activeRowIndex >= this.getRowCount()) {
            return false;
        }
        if (rows_to_move < 0) {
            return false;
        }
        this.m_hasCalculatedOffsets = false;
        if (this.m_offsets == null) {
            this.m_offsets = new int[this.getColumnCount()];
        }
        if (this.m_activeRowIndex == 0) {
            this.m_position = this.getRowStart() + 4 + 4;
        } else {
            if (rows_to_move > 0 && this.m_position < 0) {
                throw new RuntimeException("VoltTableRow is in an invalid state. Consider calling advanceRow().");
            }
            for (int i = 0; i < rows_to_move; ++i) {
                int rowlength = this.m_buffer.getInt(this.m_position - 4);
                if (rowlength <= 0) {
                    throw new RuntimeException("Invalid row length.");
                }
                this.m_position += rowlength + 4;
            }
            if (this.m_position >= this.m_buffer.limit()) {
                throw new RuntimeException("Row length exceeds table boundary.");
            }
        }
        return true;
    }

    public final Object get(int columnIndex, VoltType type) {
        Object ret = null;
        switch (type) {
            case TINYINT: {
                ret = (byte)this.getLong(columnIndex);
                break;
            }
            case SMALLINT: {
                ret = (short)this.getLong(columnIndex);
                break;
            }
            case INTEGER: {
                ret = (int)this.getLong(columnIndex);
                break;
            }
            case BIGINT: {
                ret = this.getLong(columnIndex);
                break;
            }
            case FLOAT: {
                ret = this.getDouble(columnIndex);
                break;
            }
            case STRING: {
                ret = this.getString(columnIndex);
                break;
            }
            case VARBINARY: {
                ret = this.getVarbinary(columnIndex);
                break;
            }
            case TIMESTAMP: {
                ret = this.getTimestampAsTimestamp(columnIndex);
                break;
            }
            case DECIMAL: {
                ret = this.getDecimalAsBigDecimal(columnIndex);
                break;
            }
            case GEOGRAPHY_POINT: {
                ret = this.getGeographyPointValue(columnIndex);
                break;
            }
            case GEOGRAPHY: {
                ret = this.getGeographyValue(columnIndex);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type '" + type + "'");
            }
        }
        return ret;
    }

    public final Object get(String columnName, VoltType type) {
        int colIndex = this.getColumnIndex(columnName);
        return this.get(colIndex, type);
    }

    public final Object[] getRowObjects() {
        if (this.m_activeRowIndex == -1) {
            throw new RuntimeException("VoltTableRow.advanceRow() must be called to advance to the first row before any access.");
        }
        Object[] row = new Object[this.getColumnCount()];
        for (int i = 0; i < row.length; ++i) {
            row[i] = this.get0(i);
        }
        return row;
    }

    public final Object get(int columnIndex) {
        if (this.m_activeRowIndex == -1) {
            throw new RuntimeException("VoltTableRow.advanceRow() must be called to advance to the first row before any access.");
        }
        Object value = this.get0(columnIndex);
        this.m_wasNull = value == null;
        return value;
    }

    private Object get0(int columnIndex) {
        VoltType type = this.getColumnType(columnIndex);
        switch (type) {
            case TINYINT: {
                byte value = this.m_buffer.get(this.getOffset(columnIndex));
                return value == -128 ? null : Byte.valueOf(value);
            }
            case SMALLINT: {
                short value = this.m_buffer.getShort(this.getOffset(columnIndex));
                return value == Short.MIN_VALUE ? null : Short.valueOf(value);
            }
            case INTEGER: {
                int value = this.m_buffer.getInt(this.getOffset(columnIndex));
                return value == Integer.MIN_VALUE ? null : Integer.valueOf(value);
            }
            case BIGINT: {
                long value = this.m_buffer.getLong(this.getOffset(columnIndex));
                return value == Long.MIN_VALUE ? null : Long.valueOf(value);
            }
            case FLOAT: {
                double value = this.m_buffer.getDouble(this.getOffset(columnIndex));
                return value == -1.7E308 ? null : Double.valueOf(value);
            }
            case TIMESTAMP: {
                long value = this.m_buffer.getLong(this.getOffset(columnIndex));
                return value == Long.MIN_VALUE ? null : new TimestampType(value);
            }
            case DECIMAL: {
                return this.getDecimalAsBigDecimal0(columnIndex);
            }
            case STRING: {
                return this.readString(this.getOffset(columnIndex), VoltTable.ROWDATA_ENCODING);
            }
            case VARBINARY: {
                return this.getVarbinary(columnIndex);
            }
            case GEOGRAPHY_POINT: {
                return GeographyPointValue.unflattenFromBuffer(this.m_buffer, this.getOffset(columnIndex));
            }
            case GEOGRAPHY: {
                return this.getGeographyValue0(columnIndex);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    public final long getLong(int columnIndex) {
        if (columnIndex < 0) {
            throw new IndexOutOfBoundsException("Column index " + columnIndex + " is negative");
        }
        if (columnIndex >= this.getColumnCount()) {
            throw new IndexOutOfBoundsException("Column index " + columnIndex + " is beyond number of columns " + this.getColumnCount());
        }
        VoltType type = this.getColumnType(columnIndex);
        if (this.m_activeRowIndex == -1) {
            throw new RuntimeException("VoltTableRow.advanceRow() must be called to advance to the first row before any access.");
        }
        switch (type) {
            case TINYINT: {
                byte value1 = this.m_buffer.get(this.getOffset(columnIndex));
                this.m_wasNull = value1 == -128;
                return value1;
            }
            case SMALLINT: {
                short value2 = this.m_buffer.getShort(this.getOffset(columnIndex));
                this.m_wasNull = value2 == Short.MIN_VALUE;
                return value2;
            }
            case INTEGER: {
                int value3 = this.m_buffer.getInt(this.getOffset(columnIndex));
                this.m_wasNull = value3 == Integer.MIN_VALUE;
                return value3;
            }
            case BIGINT: {
                long value4 = this.m_buffer.getLong(this.getOffset(columnIndex));
                this.m_wasNull = value4 == Long.MIN_VALUE;
                return value4;
            }
        }
        throw new IllegalArgumentException("getLong() called on non-integral column.");
    }

    public final long getLong(String columnName) {
        int colIndex = this.getColumnIndex(columnName);
        return this.getLong(colIndex);
    }

    public final boolean wasNull() {
        return this.m_wasNull;
    }

    public final ByteBuffer getRawRow() {
        int rowSize = this.m_buffer.getInt(this.m_position - 4);
        int pos = this.m_buffer.position();
        this.m_buffer.position(this.m_position - 4);
        ByteBuffer retval = this.m_buffer.slice();
        this.m_buffer.position(pos);
        retval.limit(4 + rowSize);
        return retval;
    }

    final byte[] getRaw(int columnIndex) {
        int pos = this.m_buffer.position();
        int offset = this.getOffset(columnIndex);
        VoltType type = this.getColumnType(columnIndex);
        switch (type) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case TIMESTAMP: 
            case DECIMAL: 
            case GEOGRAPHY_POINT: {
                int length = type.getLengthInBytesForFixedTypesWithoutCheck();
                byte[] retval = new byte[length];
                this.m_buffer.position(offset);
                this.m_buffer.get(retval);
                this.m_buffer.position(pos);
                return retval;
            }
            case STRING: 
            case VARBINARY: 
            case GEOGRAPHY: {
                int length = this.m_buffer.getInt(offset);
                if (length == -1) {
                    length = 0;
                }
                byte[] retval = new byte[length += 4];
                this.m_buffer.position(offset);
                this.m_buffer.get(retval);
                this.m_buffer.position(pos);
                return retval;
            }
        }
        throw new RuntimeException("Unknown type");
    }

    public final double getDouble(int columnIndex) {
        this.validateColumnType(columnIndex, VoltType.FLOAT);
        double value = this.m_buffer.getDouble(this.getOffset(columnIndex));
        this.m_wasNull = value <= -1.7E308;
        return value;
    }

    public final double getDouble(String columnName) {
        int colIndex = this.getColumnIndex(columnName);
        return this.getDouble(colIndex);
    }

    public final String getString(int columnIndex) {
        this.validateColumnType(columnIndex, VoltType.STRING);
        String retval = this.readString(this.getOffset(columnIndex), VoltTable.ROWDATA_ENCODING);
        this.m_wasNull = retval == null;
        return retval;
    }

    public final String getString(String columnName) {
        int colIndex = this.getColumnIndex(columnName);
        return this.getString(colIndex);
    }

    public final byte[] getStringAsBytes(int columnIndex) {
        this.validateColumnType(columnIndex, VoltType.STRING);
        int pos = this.m_buffer.position();
        this.m_buffer.position(this.getOffset(columnIndex));
        int len = this.m_buffer.getInt();
        if (len == -1) {
            this.m_wasNull = true;
            this.m_buffer.position(pos);
            return null;
        }
        this.m_wasNull = false;
        byte[] data = new byte[len];
        this.m_buffer.get(data);
        this.m_buffer.position(pos);
        return data;
    }

    public final byte[] getStringAsBytes(String columnName) {
        int colIndex = this.getColumnIndex(columnName);
        return this.getStringAsBytes(colIndex);
    }

    public final byte[] getVarbinary(int columnIndex) {
        this.validateColumnType(columnIndex, VoltType.VARBINARY);
        int pos = this.m_buffer.position();
        this.m_buffer.position(this.getOffset(columnIndex));
        if (4 > this.m_buffer.remaining()) {
            throw new RuntimeException(String.format("VoltTableRow::getVarbinary: Can't read varbinary size as %d byte integer from buffer with %d bytes remaining.", 4, this.m_buffer.remaining()));
        }
        int len = this.m_buffer.getInt();
        if (len == -1) {
            this.m_wasNull = true;
            this.m_buffer.position(pos);
            return null;
        }
        if (len > this.m_buffer.remaining()) {
            throw new RuntimeException(String.format("VoltTableRow::getVarbinary: Can't read %d byte varbinary from buffer with %d bytes remaining.", len, this.m_buffer.remaining()));
        }
        this.m_wasNull = false;
        byte[] data = new byte[len];
        this.m_buffer.get(data);
        this.m_buffer.position(pos);
        return data;
    }

    public final int getVarbinaryLen(int columnIndex) {
        this.validateColumnType(columnIndex, VoltType.VARBINARY);
        int offset = this.getOffset(columnIndex);
        if (4 > this.m_buffer.limit() - offset) {
            throw new RuntimeException(String.format("VoltTableRow::getVarbinary: Can't read varbinary size as %d byte integer from buffer with %d bytes remaining.", 4, this.m_buffer.limit() - offset));
        }
        return this.m_buffer.getInt(offset);
    }

    public final byte[] getVarbinary(String columnName) {
        int colIndex = this.getColumnIndex(columnName);
        return this.getVarbinary(colIndex);
    }

    public final GeographyPointValue getGeographyPointValue(int columnIndex) {
        this.validateColumnType(columnIndex, VoltType.GEOGRAPHY_POINT);
        GeographyPointValue pt = GeographyPointValue.unflattenFromBuffer(this.m_buffer, this.getOffset(columnIndex));
        this.m_wasNull = pt == null;
        return pt;
    }

    public final GeographyPointValue getGeographyPointValue(String columnName) {
        int colIndex = this.getColumnIndex(columnName);
        return this.getGeographyPointValue(colIndex);
    }

    public final GeographyValue getGeographyValue(int columnIndex) {
        this.validateColumnType(columnIndex, VoltType.GEOGRAPHY);
        GeographyValue gv = this.getGeographyValue0(columnIndex);
        this.m_wasNull = gv == null;
        return gv;
    }

    private GeographyValue getGeographyValue0(int columnIndex) {
        int offset = this.getOffset(columnIndex);
        int len = this.m_buffer.getInt(offset);
        if (len == -1) {
            this.m_wasNull = true;
            return null;
        }
        this.m_wasNull = false;
        GeographyValue gv = GeographyValue.unflattenFromBuffer(this.m_buffer, offset += 4);
        return gv;
    }

    public final GeographyValue getGeographyValue(String columnName) {
        int colIndex = this.getColumnIndex(columnName);
        return this.getGeographyValue(colIndex);
    }

    public final long getTimestampAsLong(int columnIndex) {
        this.validateColumnType(columnIndex, VoltType.TIMESTAMP);
        long value = this.m_buffer.getLong(this.getOffset(columnIndex));
        this.m_wasNull = value == Long.MIN_VALUE;
        return value;
    }

    public final long getTimestampAsLong(String columnName) {
        int colIndex = this.getColumnIndex(columnName);
        return this.getTimestampAsLong(colIndex);
    }

    public final TimestampType getTimestampAsTimestamp(int columnIndex) {
        long timestamp = this.getTimestampAsLong(columnIndex);
        if (this.m_wasNull) {
            return null;
        }
        return new TimestampType(timestamp);
    }

    public final TimestampType getTimestampAsTimestamp(String columnName) {
        int colIndex = this.getColumnIndex(columnName);
        return this.getTimestampAsTimestamp(colIndex);
    }

    public final Timestamp getTimestampAsSqlTimestamp(int columnIndex) {
        long timestamp = this.getTimestampAsLong(columnIndex);
        if (this.m_wasNull) {
            return null;
        }
        return VoltTypeUtil.getSqlTimestampFromMicrosSinceEpoch(timestamp);
    }

    public Timestamp getTimestampAsSqlTimestamp(String columnName) {
        int colIndex = this.getColumnIndex(columnName);
        return this.getTimestampAsSqlTimestamp(colIndex);
    }

    public final BigDecimal getDecimalAsBigDecimal(int columnIndex) {
        this.validateColumnType(columnIndex, VoltType.DECIMAL);
        BigDecimal bd = this.getDecimalAsBigDecimal0(columnIndex);
        this.m_wasNull = bd == null;
        return bd;
    }

    private BigDecimal getDecimalAsBigDecimal0(int columnIndex) {
        int position = this.m_buffer.position();
        this.m_buffer.position(this.getOffset(columnIndex));
        BigDecimal bd = VoltDecimalHelper.deserializeBigDecimal(this.m_buffer);
        this.m_buffer.position(position);
        return bd;
    }

    public BigDecimal getDecimalAsBigDecimal(String columnName) {
        int colIndex = this.getColumnIndex(columnName);
        return this.getDecimalAsBigDecimal(colIndex);
    }

    void putJSONRep(int columnIndex, JSONStringer js) throws JSONException {
        VoltType columnType = this.getColumnType(columnIndex);
        switch (columnType) {
            case TINYINT: {
                long value = this.getLong(columnIndex);
                if (this.wasNull()) {
                    js.valueNull();
                    break;
                }
                js.value(value);
                break;
            }
            case SMALLINT: {
                long value = this.getLong(columnIndex);
                if (this.wasNull()) {
                    js.valueNull();
                    break;
                }
                js.value(value);
                break;
            }
            case INTEGER: {
                long value = this.getLong(columnIndex);
                if (this.wasNull()) {
                    js.valueNull();
                    break;
                }
                js.value(value);
                break;
            }
            case BIGINT: {
                long value = this.getLong(columnIndex);
                if (this.wasNull()) {
                    js.valueNull();
                    break;
                }
                js.value(value);
                break;
            }
            case TIMESTAMP: {
                long value = this.getTimestampAsLong(columnIndex);
                if (this.wasNull()) {
                    js.valueNull();
                    break;
                }
                js.value(value);
                break;
            }
            case FLOAT: {
                double dvalue = this.getDouble(columnIndex);
                if (this.wasNull()) {
                    js.valueNull();
                    break;
                }
                if (Double.isNaN(dvalue)) {
                    js.value(Double.toString(dvalue));
                    break;
                }
                if (Double.isInfinite(dvalue)) {
                    js.value(Double.toString(dvalue));
                    break;
                }
                js.value(dvalue);
                break;
            }
            case STRING: {
                js.value(this.getString(columnIndex));
                break;
            }
            case VARBINARY: {
                byte[] bin = this.getVarbinary(columnIndex);
                js.value(Encoder.hexEncode(bin));
                break;
            }
            case DECIMAL: {
                BigDecimal dec = this.getDecimalAsBigDecimal(columnIndex);
                if (this.wasNull()) {
                    js.valueNull();
                    break;
                }
                js.value(((Object)dec).toString());
                break;
            }
            case GEOGRAPHY_POINT: {
                GeographyPointValue pt = this.getGeographyPointValue(columnIndex);
                if (this.wasNull()) {
                    js.valueNull();
                    break;
                }
                js.value(pt.toString());
                break;
            }
            case GEOGRAPHY: {
                GeographyValue gv = this.getGeographyValue(columnIndex);
                if (this.wasNull()) {
                    js.valueNull();
                    break;
                }
                js.value(gv.toString());
                break;
            }
            case INVALID: {
                break;
            }
            case NULL: {
                break;
            }
            case NUMERIC: {
                break;
            }
            case BOOLEAN: {
                break;
            }
        }
    }

    final void validateColumnType(int columnIndex, VoltType ... types) {
        if (this.m_position < 0) {
            throw new RuntimeException("VoltTableRow is in an invalid state. Consider calling advanceRow().");
        }
        if (columnIndex >= this.getColumnCount() || columnIndex < 0) {
            throw new IndexOutOfBoundsException("Column index " + columnIndex + " is greater than the number of columns");
        }
        VoltType columnType = this.getColumnType(columnIndex);
        for (VoltType type : types) {
            if (columnType != type) continue;
            return;
        }
        throw new IllegalArgumentException("Column index " + columnIndex + " is type " + columnType);
    }

    final String readString(int position, Charset encoding) {
        if (4 > this.m_buffer.limit() - position) {
            throw new RuntimeException(String.format("VoltTableRow::readString: Can't read string size as %d byte integer from buffer with %d bytes remaining.", 4, this.m_buffer.limit() - position));
        }
        int len = this.m_buffer.getInt(position);
        if (len == -1) {
            return null;
        }
        if (len < 0) {
            throw new RuntimeException("Invalid object length.");
        }
        if (position + 4 + len > this.m_buffer.limit()) {
            throw new RuntimeException(String.format("VoltTableRow::readString: Can't read %d byte string from buffer with %d bytes remaining.", len, this.m_buffer.limit() - position - 4));
        }
        byte[] stringData = new byte[len];
        int oldPos = this.m_buffer.position();
        this.m_buffer.position(position + 4);
        this.m_buffer.get(stringData);
        this.m_buffer.position(oldPos);
        return new String(stringData, encoding);
    }

    public String getRow() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            switch (this.getColumnType(i)) {
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case BIGINT: {
                    long lval = this.getLong(i);
                    if (this.wasNull()) {
                        buffer.append("NULL");
                        break;
                    }
                    buffer.append(lval);
                    break;
                }
                case FLOAT: {
                    double dval = this.getDouble(i);
                    if (this.wasNull()) {
                        buffer.append("NULL");
                        break;
                    }
                    buffer.append(dval);
                    break;
                }
                case TIMESTAMP: {
                    TimestampType tstamp = this.getTimestampAsTimestamp(i);
                    if (this.wasNull()) {
                        buffer.append("NULL");
                        assert (tstamp == null);
                        break;
                    }
                    buffer.append(tstamp);
                    break;
                }
                case STRING: {
                    String string = this.getString(i);
                    if (this.wasNull()) {
                        buffer.append("NULL");
                        assert (string == null);
                        break;
                    }
                    buffer.append(string);
                    break;
                }
                case VARBINARY: {
                    byte[] bin = this.getVarbinary(i);
                    if (this.wasNull()) {
                        buffer.append("NULL");
                        assert (bin == null);
                        break;
                    }
                    buffer.append(VoltTable.varbinaryToPrintableString(bin));
                    break;
                }
                case DECIMAL: {
                    BigDecimal bd = this.getDecimalAsBigDecimal(i);
                    if (this.wasNull()) {
                        buffer.append("NULL");
                        assert (bd == null);
                        break;
                    }
                    buffer.append(bd.toString());
                    break;
                }
                case GEOGRAPHY_POINT: {
                    GeographyPointValue pt = this.getGeographyPointValue(i);
                    if (this.wasNull()) {
                        buffer.append("NULL");
                        break;
                    }
                    buffer.append(pt.toString());
                    break;
                }
                case GEOGRAPHY: {
                    GeographyValue gv = this.getGeographyValue(i);
                    if (this.wasNull()) {
                        buffer.append("NULL");
                        break;
                    }
                    buffer.append(gv.toString());
                    break;
                }
                default: {
                    throw new IllegalStateException("Table column had unexpected type.");
                }
            }
            if (i >= this.getColumnCount() - 1) continue;
            buffer.append(",");
        }
        buffer.append("\n");
        return buffer.toString();
    }
}

