/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb;

import java.nio.ByteBuffer;
import org.voltdb.VoltTable;

public abstract class PrivateVoltTableFactory {
    public static VoltTable createUninitializedVoltTable() {
        return new VoltTable();
    }

    public static VoltTable createVoltTableFromSchemaBytes(byte[] schema) {
        ByteBuffer buffer = ByteBuffer.allocate(schema.length + 4);
        buffer.put(schema);
        buffer.putInt(0);
        buffer.rewind();
        return PrivateVoltTableFactory.createVoltTableFromBuffer(buffer, false);
    }

    public static VoltTable createVoltTableFromBuffer(ByteBuffer backing, boolean readOnly) {
        return PrivateVoltTableFactory.createVoltTableFromBuffer(backing, readOnly, false);
    }

    public static VoltTable createVoltTableFromBuffer(ByteBuffer backing, boolean readOnly, boolean rejoin) {
        return new VoltTable(backing, readOnly, rejoin);
    }

    public static VoltTable createVoltTableFromSharedBuffer(ByteBuffer shared) {
        VoltTable vt = new VoltTable();
        vt.initFromBuffer(shared);
        return vt;
    }

    public static VoltTable createVoltTableFromByteArray(byte[] backingBuff, int position, int len) {
        VoltTable vt = new VoltTable();
        vt.initFromByteArray(backingBuff, position, len);
        return vt;
    }

    public static ByteBuffer getTableDataReference(VoltTable vt) {
        ByteBuffer buf = vt.m_buffer.duplicate();
        buf.rewind();
        return buf;
    }

    public static byte[] getSchemaBytes(VoltTable vt) {
        if (vt.getRowCount() > 0) {
            throw new RuntimeException("getSchemaBytes() Only works if the table is empty");
        }
        ByteBuffer dup = vt.m_buffer.duplicate();
        dup.limit(dup.limit() - 4);
        dup.position(0);
        byte[] retvalBytes = new byte[dup.remaining()];
        dup.get(retvalBytes);
        return retvalBytes;
    }

    public static int getUnderlyingBufferSize(VoltTable vt) {
        return vt.m_buffer.position();
    }
}

