/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.voltdb.AvroCodec;
import org.voltdb.ParameterSet;
import org.voltdb.VoltTable;
import org.voltdb.VoltType;
import org.voltdb.VoltTypeException;
import org.voltdb.messaging.FastSerializer;
import org.voltdb.parser.SQLParser;
import org.voltdb.types.GeographyPointValue;
import org.voltdb.types.GeographyValue;
import org.voltdb.types.TimestampType;
import org.voltdb.types.VoltDecimalHelper;
import org.voltdb.utils.Encoder;

public class ParameterConverter {
    private static final AvroCodec AVRO_CODEC = AvroCodec.getSafe();

    private static boolean isByteClass(Class<?> clz) {
        return clz == Byte.class || clz == Byte.TYPE;
    }

    private static boolean isShortClass(Class<?> clz) {
        return clz == Short.class || clz == Short.TYPE;
    }

    private static boolean isIntClass(Class<?> clz) {
        return clz == Integer.class || clz == Integer.TYPE;
    }

    private static boolean isLongClass(Class<?> clz) {
        return clz == Long.class || clz == Long.TYPE;
    }

    private static boolean isDoubleClass(Class<?> clz) {
        return clz == Double.class || clz == Double.TYPE;
    }

    private static boolean isByteArrayClass(Class<?> clz) {
        return clz == Byte[].class || clz == byte[].class;
    }

    private static Object nullValueForType(Class<?> expectedClz) {
        if (expectedClz == Long.TYPE) {
            return Long.MIN_VALUE;
        }
        if (expectedClz == Integer.TYPE) {
            return Integer.MIN_VALUE;
        }
        if (expectedClz == Short.TYPE) {
            return (short)Short.MIN_VALUE;
        }
        if (expectedClz == Byte.TYPE) {
            return (byte)-128;
        }
        if (expectedClz == Double.TYPE) {
            return -1.7E308;
        }
        return null;
    }

    public static boolean verifyParameterConversion(Object value, Class<?> expectedClz) {
        if (expectedClz == Long.TYPE) {
            assert (value != null);
            assert (value.getClass() == Long.class);
        } else if (expectedClz == Integer.TYPE) {
            assert (value != null);
            assert (value.getClass() == Integer.class);
        } else if (expectedClz == Short.TYPE) {
            assert (value != null);
            assert (value.getClass() == Short.class);
        } else if (expectedClz == Byte.TYPE) {
            assert (value != null);
            assert (value.getClass() == Byte.class);
        } else if (expectedClz == Double.TYPE) {
            assert (value != null);
            assert (value.getClass() == Double.class);
        } else if (value != null) {
            Class<?> clz = value.getClass();
            if (ByteBuffer.class.isAssignableFrom(clz) && ByteBuffer.class.isAssignableFrom(expectedClz)) {
                return true;
            }
            if (byte[].class.isAssignableFrom(expectedClz) && VoltType.isAvroRecord(clz)) {
                return true;
            }
            if (clz != expectedClz) {
                return expectedClz.getSimpleName().equals("SystemProcedureExecutionContext") && expectedClz.isAssignableFrom(clz);
            }
            if (expectedClz.isArray()) assert (clz.getComponentType() == expectedClz.getComponentType());
        }
        return true;
    }

    private static Object convertStringToPrimitiveOrPrimitiveWrapper(String value, Class<?> expectedClz) throws VoltTypeException {
        block10: {
            if ((value = value.trim()).equals("\\N")) {
                return ParameterConverter.nullValueForType(expectedClz);
            }
            String commaFreeValue = value.contains(",") ? value.replace(",", "") : value;
            try {
                if (ParameterConverter.isLongClass(expectedClz)) {
                    return Long.parseLong(commaFreeValue);
                }
                if (ParameterConverter.isIntClass(expectedClz)) {
                    return Integer.parseInt(commaFreeValue);
                }
                if (ParameterConverter.isShortClass(expectedClz)) {
                    return Short.parseShort(commaFreeValue);
                }
                if (ParameterConverter.isByteClass(expectedClz)) {
                    return Byte.parseByte(commaFreeValue);
                }
                if (ParameterConverter.isDoubleClass(expectedClz)) {
                    return Double.parseDouble(commaFreeValue);
                }
            }
            catch (NumberFormatException nfe) {
                String hexDigits;
                if (expectedClz == Double.TYPE || (hexDigits = SQLParser.getDigitsFromHexLiteral(value)) == null) break block10;
                try {
                    return SQLParser.hexDigitsToLong(hexDigits);
                }
                catch (SQLParser.Exception exception) {
                    // empty catch block
                }
            }
        }
        throw new VoltTypeException("Unable to convert string " + value + " to " + expectedClz.getName() + " value for target parameter.");
    }

    private static Object tryToMakeCompatibleArray(Class<?> expectedComponentClz, Class<?> inputComponentClz, Object param, boolean keepParamsImmutable) throws VoltTypeException {
        int inputLength = Array.getLength(param);
        if (inputLength == 0) {
            return Array.newInstance(expectedComponentClz, 0);
        }
        if (inputComponentClz == expectedComponentClz) {
            VoltType type;
            if (!keepParamsImmutable) {
                return param;
            }
            try {
                type = VoltType.typeFromClass(inputComponentClz);
            }
            catch (VoltTypeException e) {
                Object obj = ParameterSet.getAKosherArray((Object[])param);
                type = VoltType.typeFromClass(obj.getClass().getComponentType());
            }
            switch (type) {
                case TINYINT: {
                    if (param instanceof Byte[]) {
                        return Arrays.copyOf((Byte[])param, inputLength);
                    }
                    return Arrays.copyOf((byte[])param, inputLength);
                }
                case SMALLINT: {
                    if (param instanceof Short[]) {
                        return Arrays.copyOf((Short[])param, inputLength);
                    }
                    return Arrays.copyOf((short[])param, inputLength);
                }
                case INTEGER: {
                    if (param instanceof Integer[]) {
                        return Arrays.copyOf((Integer[])param, inputLength);
                    }
                    return Arrays.copyOf((int[])param, inputLength);
                }
                case BIGINT: {
                    if (param instanceof Long[]) {
                        return Arrays.copyOf((Long[])param, inputLength);
                    }
                    return Arrays.copyOf((long[])param, inputLength);
                }
                case FLOAT: {
                    if (param instanceof Double[]) {
                        return Arrays.copyOf((Double[])param, inputLength);
                    }
                    return Arrays.copyOf((double[])param, inputLength);
                }
                case STRING: {
                    return param;
                }
                case DECIMAL: {
                    return Arrays.copyOf((BigDecimal[])param, inputLength);
                }
                case VOLTTABLE: {
                    return Arrays.copyOf((VoltTable[])param, inputLength);
                }
                case VARBINARY: {
                    if (param instanceof Byte[][]) {
                        Byte[][] obj = new Byte[inputLength][];
                        for (int ii = 0; ii < inputLength; ++ii) {
                            obj[ii] = Arrays.copyOf(((Byte[][])param)[ii], ((Byte[][])param)[ii].length);
                        }
                        return obj;
                    }
                    byte[][] obj = new byte[inputLength][];
                    for (int ii = 0; ii < inputLength; ++ii) {
                        obj[ii] = Arrays.copyOf(((byte[][])param)[ii], ((byte[][])param)[ii].length);
                    }
                    return obj;
                }
                case GEOGRAPHY_POINT: {
                    return Arrays.copyOf((GeographyPointValue[])param, inputLength);
                }
                case GEOGRAPHY: {
                    return Arrays.copyOf((GeographyValue[])param, inputLength);
                }
            }
            return param;
        }
        if (ParameterConverter.isByteArrayClass(inputComponentClz) && expectedComponentClz == String.class) {
            String[] values = new String[inputLength];
            for (int i = 0; i < inputLength; ++i) {
                values[i] = new String((byte[])Array.get(param, i), StandardCharsets.UTF_8);
            }
            return values;
        }
        if (inputComponentClz == String.class && expectedComponentClz == byte[].class) {
            byte[][] values = new byte[inputLength][];
            for (int i = 0; i < inputLength; ++i) {
                values[i] = Encoder.hexDecode((String)Array.get(param, i));
            }
            return values;
        }
        if (inputComponentClz == String.class && expectedComponentClz == Byte[].class) {
            Byte[][] boxvalues = new Byte[inputLength][];
            for (int i = 0; i < inputLength; ++i) {
                boxvalues[i] = ArrayUtils.toObject((byte[])Encoder.hexDecode((String)Array.get(param, i)));
            }
            return boxvalues;
        }
        throw new VoltTypeException("tryScalarMakeCompatible: Unable to match parameter array:" + expectedComponentClz.getName() + " to provided " + inputComponentClz.getName());
    }

    public static Object tryToMakeCompatible(Class<?> expectedClz, Object param) throws VoltTypeException {
        return ParameterConverter.tryToMakeCompatible(expectedClz, param, false);
    }

    public static Object tryToMakeCompatible(Class<?> expectedClz, Object param, boolean keepParamsImmutable) throws VoltTypeException {
        if (param == null) {
            return ParameterConverter.nullValueForType(expectedClz);
        }
        Class<?> inputClz = param.getClass();
        Number numberParam = null;
        if (inputClz == Long.class) {
            if (expectedClz == Long.TYPE) {
                return param;
            }
            if ((Long)param == Long.MIN_VALUE) {
                return ParameterConverter.nullValueForType(expectedClz);
            }
            if (expectedClz == Long.class) {
                return param;
            }
            numberParam = (Number)param;
        } else if (inputClz == Integer.class) {
            if (expectedClz == Integer.TYPE) {
                return param;
            }
            if ((Integer)param == Integer.MIN_VALUE) {
                return ParameterConverter.nullValueForType(expectedClz);
            }
            if (expectedClz == Integer.class) {
                return param;
            }
            if (ParameterConverter.isLongClass(expectedClz)) {
                return ((Integer)param).longValue();
            }
            numberParam = (Number)param;
        } else if (inputClz == Short.class) {
            if (expectedClz == Short.TYPE) {
                return param;
            }
            if ((Short)param == Short.MIN_VALUE) {
                return ParameterConverter.nullValueForType(expectedClz);
            }
            if (expectedClz == Short.class) {
                return param;
            }
            if (ParameterConverter.isLongClass(expectedClz)) {
                return ((Short)param).longValue();
            }
            if (ParameterConverter.isIntClass(expectedClz)) {
                return ((Short)param).intValue();
            }
            numberParam = (Number)param;
        } else if (inputClz == Byte.class) {
            if (expectedClz == Byte.TYPE) {
                return param;
            }
            if ((Byte)param == -128) {
                return ParameterConverter.nullValueForType(expectedClz);
            }
            if (expectedClz == Byte.class) {
                return param;
            }
            if (ParameterConverter.isLongClass(expectedClz)) {
                return ((Byte)param).longValue();
            }
            if (ParameterConverter.isIntClass(expectedClz)) {
                return ((Byte)param).intValue();
            }
            if (ParameterConverter.isShortClass(expectedClz)) {
                return ((Byte)param).shortValue();
            }
            numberParam = (Number)param;
        } else if (inputClz == Double.class) {
            if (expectedClz == Double.TYPE) {
                return param;
            }
            if ((Double)param == -1.7E308) {
                return ParameterConverter.nullValueForType(expectedClz);
            }
            if (expectedClz == Double.class) {
                return param;
            }
        } else if (inputClz == String.class) {
            String stringParam = (String)param;
            if (stringParam.equals("\\N")) {
                return ParameterConverter.nullValueForType(expectedClz);
            }
            if (expectedClz == String.class) {
                return param;
            }
            if (ParameterConverter.isByteArrayClass(expectedClz)) {
                String hexDigits;
                if ((stringParam.startsWith("X") || stringParam.startsWith("x")) && (hexDigits = SQLParser.getDigitsFromHexLiteral(stringParam)) != null) {
                    stringParam = hexDigits;
                }
                byte[] inpArray = Encoder.hexDecode(stringParam);
                if (expectedClz == byte[].class) {
                    return inpArray;
                }
                if (expectedClz == Byte[].class) {
                    return ArrayUtils.toObject((byte[])inpArray);
                }
            }
            if (expectedClz.isPrimitive() || expectedClz == Long.class || expectedClz == Integer.class || expectedClz == Byte.class || expectedClz == Double.class || expectedClz == Short.class) {
                return ParameterConverter.convertStringToPrimitiveOrPrimitiveWrapper(stringParam, expectedClz);
            }
        } else if (inputClz == byte[].class) {
            if (expectedClz == Byte[].class) {
                return ArrayUtils.toObject((byte[])((byte[])param));
            }
            if (expectedClz == String.class) {
                String value = new String((byte[])param, StandardCharsets.UTF_8);
                if (value.equals("\\N")) {
                    return ParameterConverter.nullValueForType(expectedClz);
                }
                return value;
            }
            if (ByteBuffer.class.isAssignableFrom(expectedClz)) {
                return ByteBuffer.wrap((byte[])param);
            }
            if (VoltType.isAvroRecord(expectedClz)) {
                return AVRO_CODEC.deserialize((byte[])param);
            }
        } else {
            if (param == VoltType.NULL_TIMESTAMP || param == VoltType.NULL_STRING_OR_VARBINARY || param == VoltType.NULL_GEOGRAPHY || param == VoltType.NULL_POINT || param == VoltType.NULL_DECIMAL) {
                return ParameterConverter.nullValueForType(expectedClz);
            }
            if (inputClz == BigDecimal.class) {
                BigDecimal pBigDecimal = (BigDecimal)param;
                if (expectedClz == BigDecimal.class) {
                    return VoltDecimalHelper.setDefaultScale(pBigDecimal);
                }
                if (ParameterConverter.isLongClass(expectedClz)) {
                    try {
                        long result = pBigDecimal.longValueExact();
                        return result;
                    }
                    catch (ArithmeticException result) {}
                } else if (ParameterConverter.isDoubleClass(expectedClz)) {
                    double result = pBigDecimal.doubleValue();
                    if (result != Double.POSITIVE_INFINITY && result != Double.NEGATIVE_INFINITY) {
                        return result;
                    }
                } else if (ParameterConverter.isIntClass(expectedClz)) {
                    try {
                        int result = pBigDecimal.intValueExact();
                        return result;
                    }
                    catch (ArithmeticException result) {}
                } else if (ParameterConverter.isShortClass(expectedClz)) {
                    try {
                        short result = pBigDecimal.shortValueExact();
                        return result;
                    }
                    catch (ArithmeticException result) {}
                } else if (ParameterConverter.isByteClass(expectedClz)) {
                    try {
                        byte result22 = pBigDecimal.byteValueExact();
                        return result22;
                    }
                    catch (ArithmeticException result22) {
                        // empty catch block
                    }
                }
                throw new VoltTypeException("The provided value: (" + param.toString() + ") of type: " + inputClz.getName() + " is out of range for the target parameter type: " + expectedClz.getName());
            }
        }
        if (expectedClz.isArray() != inputClz.isArray()) {
            throw new VoltTypeException(String.format("Array / Scalar parameter mismatch (%s to %s)", inputClz.getName(), expectedClz.getName()));
        }
        if (expectedClz.isArray()) {
            return ParameterConverter.tryToMakeCompatibleArray(expectedClz.getComponentType(), inputClz.getComponentType(), param, keepParamsImmutable);
        }
        if (ParameterConverter.isIntClass(expectedClz) && numberParam != null) {
            long val = numberParam.longValue();
            if (val == Integer.MIN_VALUE) {
                throw new VoltTypeException("The provided long value: (" + param.toString() + ") might be interpreted as integer null. Try explicitly using a int parameter.");
            }
            if (val <= Integer.MAX_VALUE && val >= Integer.MIN_VALUE) {
                return numberParam.intValue();
            }
        } else if (ParameterConverter.isShortClass(expectedClz) && numberParam != null) {
            if (inputClz == Long.class || inputClz == Integer.class) {
                long val = numberParam.longValue();
                if (val == -32768L) {
                    throw new VoltTypeException("The provided int or long value: (" + param.toString() + ") might be interpreted as smallint null. Try explicitly using a short parameter.");
                }
                if (val <= 32767L && val >= -32768L) {
                    return numberParam.shortValue();
                }
            }
        } else if (ParameterConverter.isByteClass(expectedClz) && numberParam != null) {
            if (inputClz == Long.class || inputClz == Integer.class || inputClz == Short.class) {
                long val = numberParam.longValue();
                if (val == -128L) {
                    throw new VoltTypeException("The provided short, int or long value: (" + param.toString() + ") might be interpreted as tinyint null. Try explicitly using a byte parameter.");
                }
                if (val <= 127L && val >= -128L) {
                    return numberParam.byteValue();
                }
            }
        } else {
            if (ParameterConverter.isDoubleClass(expectedClz) && numberParam != null) {
                return numberParam.doubleValue();
            }
            if (expectedClz == TimestampType.class) {
                if (inputClz == Integer.class) {
                    return new TimestampType(((Integer)param).intValue());
                }
                if (inputClz == Long.class) {
                    return new TimestampType((Long)param);
                }
                if (inputClz == TimestampType.class) {
                    return param;
                }
                if (inputClz == java.util.Date.class) {
                    return new TimestampType((java.util.Date)param);
                }
                if (inputClz == String.class) {
                    String timestring = ((String)param).trim();
                    try {
                        return new TimestampType(Long.parseLong(timestring));
                    }
                    catch (IllegalArgumentException result22) {
                        try {
                            return SQLParser.parseDate(timestring);
                        }
                        catch (IllegalArgumentException result22) {}
                    }
                }
            } else if (expectedClz == Timestamp.class) {
                if (param instanceof Timestamp) {
                    return param;
                }
                if (param instanceof java.util.Date) {
                    return new Timestamp(((java.util.Date)param).getTime());
                }
                if (param instanceof TimestampType) {
                    return ((TimestampType)param).asJavaTimestamp();
                }
                if (inputClz == String.class) {
                    String longtime = ((String)param).trim();
                    try {
                        return new Timestamp(Long.parseLong(longtime));
                    }
                    catch (IllegalArgumentException result22) {
                        try {
                            return Timestamp.valueOf(longtime);
                        }
                        catch (IllegalArgumentException result22) {}
                    }
                }
            } else if (expectedClz == Date.class) {
                if (param instanceof Date) {
                    return param;
                }
                if (param instanceof java.util.Date) {
                    return new Date(((java.util.Date)param).getTime());
                }
                if (param instanceof TimestampType) {
                    return ((TimestampType)param).asExactJavaSqlDate();
                }
                if (inputClz == String.class) {
                    try {
                        return new Date(TimestampType.millisFromJDBCformat((String)param));
                    }
                    catch (IllegalArgumentException longtime) {}
                }
            } else if (expectedClz == java.util.Date.class) {
                if (param instanceof java.util.Date) {
                    return param;
                }
                if (param instanceof TimestampType) {
                    return ((TimestampType)param).asExactJavaDate();
                }
                if (inputClz == String.class) {
                    try {
                        return new java.util.Date(TimestampType.millisFromJDBCformat((String)param));
                    }
                    catch (IllegalArgumentException longtime) {}
                }
            } else {
                if (expectedClz == BigDecimal.class) {
                    BigDecimal bd;
                    if (numberParam != null) {
                        bd = VoltDecimalHelper.stringToDecimal(param.toString());
                        return bd;
                    }
                    if (inputClz == BigDecimal.class) {
                        bd = (BigDecimal)param;
                        bd = VoltDecimalHelper.setDefaultScale(bd);
                        return bd;
                    }
                    if (inputClz == Float.class || inputClz == Double.class) {
                        try {
                            return VoltDecimalHelper.deserializeBigDecimalFromString(String.format("%.12f", param));
                        }
                        catch (IOException ex) {
                            throw new VoltTypeException(String.format("deserialize Float from string failed. (%s to %s)", inputClz.getName(), expectedClz.getName()));
                        }
                    }
                    try {
                        return VoltDecimalHelper.deserializeBigDecimalFromString(String.valueOf(param));
                    }
                    catch (IOException ex) {
                        throw new VoltTypeException(String.format("deserialize BigDecimal from string failed. (%s to %s)", inputClz.getName(), expectedClz.getName()));
                    }
                }
                if (expectedClz == GeographyPointValue.class) {
                    if (inputClz == GeographyPointValue.class) {
                        return param;
                    }
                    if (inputClz == String.class) {
                        try {
                            GeographyPointValue pt = GeographyPointValue.fromWKT((String)param);
                            return pt;
                        }
                        catch (IllegalArgumentException e) {
                            throw new VoltTypeException(String.format("deserialize GeographyPointValue from string failed (string %s)", (String)param));
                        }
                    }
                } else if (expectedClz == GeographyValue.class) {
                    if (inputClz == GeographyValue.class) {
                        return param;
                    }
                    if (inputClz == String.class) {
                        String paramStr = (String)param;
                        try {
                            GeographyValue gv = GeographyValue.fromWKT(paramStr);
                            return gv;
                        }
                        catch (IllegalArgumentException e) {
                            throw new VoltTypeException(String.format("deserialize GeographyValue from string failed (string %s)", paramStr));
                        }
                    }
                } else {
                    if (expectedClz == VoltTable.class && inputClz == VoltTable.class) {
                        return param;
                    }
                    if (expectedClz == String.class) {
                        if (!param.getClass().isArray()) {
                            return String.valueOf(param);
                        }
                    } else if (expectedClz == ParameterSet.class && inputClz == ParameterSet.class) {
                        return param;
                    }
                }
            }
        }
        if (expectedClz.getSimpleName().equals("SystemProcedureExecutionContext") && expectedClz.isAssignableFrom(inputClz)) {
            return param;
        }
        throw new VoltTypeException("The provided value: (" + param.toString() + ") of type: " + inputClz.getName() + " is not a match or is out of range for the target parameter type: " + expectedClz.getName());
    }

    public static final VoltTable[] getResultsFromRawResults(String procedureName, Object result) throws InvocationTargetException {
        if (result == null) {
            return new VoltTable[0];
        }
        if (result instanceof VoltTable[]) {
            VoltTable[] retval;
            for (VoltTable table : retval = (VoltTable[])result) {
                if (table == null) {
                    RuntimeException e = new RuntimeException("VoltTable arrays with non-zero length cannot contain null values.");
                    throw new InvocationTargetException(e);
                }
                table.convertToHeapBuffer();
            }
            return retval;
        }
        if (result instanceof VoltTable) {
            VoltTable vt = (VoltTable)result;
            vt.convertToHeapBuffer();
            return new VoltTable[]{vt};
        }
        if (result instanceof Long) {
            VoltTable t = new VoltTable(new VoltTable.ColumnInfo("", VoltType.BIGINT), new VoltTable.ColumnInfo[0]);
            t.addRow(result);
            return new VoltTable[]{t};
        }
        if (VoltType.isAvroRecord(result.getClass())) {
            VoltTable[] voltTableArray;
            VoltTable t = new VoltTable(new VoltTable.ColumnInfo("avro", VoltType.VARBINARY), new VoltTable.ColumnInfo[0]);
            FastSerializer sf = new FastSerializer();
            try {
                AVRO_CODEC.serialize(sf, result);
                t.addRow(sf.getBuffer());
                voltTableArray = new VoltTable[]{t};
            }
            catch (Throwable throwable) {
                try {
                    try {
                        sf.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            sf.close();
            return voltTableArray;
        }
        throw new RuntimeException(String.format("Procedure %s unsupported procedure return type %s.", procedureName, result.getClass().getSimpleName()));
    }
}

