/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.json_voltpatches.JSONException;
import org.json_voltpatches.JSONString;
import org.json_voltpatches.JSONStringer;
import org.voltcore.utils.Pair;
import org.voltdb.VoltTable;
import org.voltdb.VoltType;
import org.voltdb.client.ClientResponse;
import org.voltdb.utils.SerializationHelper;

public class ClientResponseImpl
implements ClientResponse,
JSONString {
    private boolean setProperly = false;
    private byte status = 0;
    private String statusString = null;
    private byte[] encodedStatusString;
    private byte appStatus = (byte)-128;
    private String appStatusString = null;
    private byte[] encodedAppStatusString;
    private VoltTable[] results = new VoltTable[0];
    private int[] m_hashes = null;
    private int clusterRoundTripTime = 0;
    private int clientRoundTripTime = 0;
    private long clientRoundTripTimeNanos = 0L;
    static final String JSON_STATUS_KEY = "status";
    static final String JSON_STATUSSTRING_KEY = "statusstring";
    static final String JSON_APPSTATUS_KEY = "appstatus";
    static final String JSON_APPSTATUSSTRING_KEY = "appstatusstring";
    static final String JSON_RESULTS_KEY = "results";
    static final String JSON_TYPE_KEY = "type";
    static final String JSON_EXCEPTION_KEY = "exception";
    public static final String IGNORED_TRANSACTION = "Ignored replayed transaction";
    private long clientHandle = -1L;

    public ClientResponseImpl() {
    }

    public ClientResponseImpl(byte status, byte appStatus, String appStatusString, VoltTable[] results, String statusString) {
        this(status, appStatus, appStatusString, results, statusString, -1L);
    }

    public ClientResponseImpl(byte status, VoltTable[] results, String statusString) {
        this(status, -128, null, results, statusString, -1L);
    }

    public ClientResponseImpl(byte status, VoltTable[] results, String statusString, long handle) {
        this(status, -128, null, results, statusString, handle);
    }

    public ClientResponseImpl(byte status, byte appStatus, String appStatusString, VoltTable[] results, String statusString, long handle) {
        this.appStatus = appStatus;
        this.appStatusString = appStatusString;
        this.setResults(status, results, statusString);
        this.clientHandle = handle;
    }

    public Pair<Long, byte[]> getMispartitionedResult() {
        if (this.results.length != 1 || !this.results[0].advanceRow()) {
            throw new IllegalArgumentException("No hashinator config in result");
        }
        if (this.results[0].getColumnCount() != 2 || this.results[0].getColumnType(0) != VoltType.BIGINT || this.results[0].getColumnType(1) != VoltType.VARBINARY) {
            throw new IllegalArgumentException("Malformed hashinator result, expecting two columns of types INTEGER and VARBINARY");
        }
        Pair<Long, byte[]> hashinator = Pair.of(this.results[0].getLong("HASHINATOR_VERSION"), this.results[0].getVarbinary("HASHINATOR_CONFIG_BYTES"));
        this.results[0].resetRowPosition();
        return hashinator;
    }

    public void setMispartitionedResult(Pair<Long, byte[]> hashinatorConfig) {
        VoltTable vt = new VoltTable(new VoltTable.ColumnInfo("HASHINATOR_VERSION", VoltType.BIGINT), new VoltTable.ColumnInfo("HASHINATOR_CONFIG_BYTES", VoltType.VARBINARY));
        vt.addRow(hashinatorConfig.getFirst(), hashinatorConfig.getSecond());
        this.setResults((byte)-10, new VoltTable[]{vt}, "Transaction mispartitioned");
    }

    private void setResults(byte status, VoltTable[] results, String statusString) {
        this.setResultTables(results);
        this.status = status;
        this.statusString = statusString;
        this.setProperly = true;
    }

    public void setResultTables(VoltTable[] results) {
        assert (results != null);
        for (VoltTable result : results) {
            assert (result != null);
        }
        this.results = results;
    }

    public void setHashes(int[] hashes) {
        this.m_hashes = hashes;
    }

    @Override
    public byte getStatus() {
        return this.status;
    }

    @Override
    public VoltTable[] getResults() {
        return this.results;
    }

    @Override
    public String getStatusString() {
        return this.statusString;
    }

    public void setClientHandle(long aHandle) {
        this.clientHandle = aHandle;
    }

    public void setAppStatusString(String appStatusString) {
        this.appStatusString = appStatusString;
    }

    public long getClientHandle() {
        return this.clientHandle;
    }

    public int[] getHashes() {
        return this.m_hashes;
    }

    public void initFromBuffer(ByteBuffer buf) throws IOException {
        int tableCount;
        buf.get();
        this.clientHandle = buf.getLong();
        byte presentFields = buf.get();
        this.status = buf.get();
        this.statusString = (presentFields & 0x20) != 0 ? SerializationHelper.getString(buf) : null;
        this.appStatus = buf.get();
        this.appStatusString = (presentFields & 0x80) != 0 ? SerializationHelper.getString(buf) : null;
        this.clusterRoundTripTime = buf.getInt();
        if ((presentFields & 0x40) != 0) {
            throw new RuntimeException("Use of deprecated exception in Client Response serialization.");
        }
        if ((presentFields & 0x10) != 0) {
            int hashArrayLen = buf.getShort();
            this.m_hashes = new int[hashArrayLen];
            for (int i = 0; i < hashArrayLen; ++i) {
                this.m_hashes[i] = buf.getInt();
            }
        } else {
            this.m_hashes = null;
        }
        if ((tableCount = buf.getShort()) < 0) {
            throw new IOException("Table count is negative: " + tableCount);
        }
        this.setProperly = true;
        int count = 0;
        try {
            this.results = new VoltTable[tableCount];
            int i = 0;
            while (i < tableCount) {
                int tableSize = buf.getInt();
                int originalLimit = buf.limit();
                buf.limit(buf.position() + tableSize);
                ByteBuffer slice = buf.slice();
                buf.position(buf.position() + tableSize);
                buf.limit(originalLimit);
                this.results[i] = new VoltTable(slice, false);
                count = i++;
            }
        }
        catch (Throwable t) {
            StringBuilder builder = new StringBuilder("Unexpected errors in response. status: ");
            builder.append(this.getStatus());
            builder.append(this.statusString == null ? "" : this.statusString);
            builder.append(" appStatus:");
            builder.append(this.getAppStatus());
            builder.append((String)(this.getAppStatusString() == null ? "" : " " + this.getAppStatusString()));
            builder.append(" table count:");
            builder.append(tableCount + "\n");
            while (count > 0) {
                builder.append(this.results[count--].toFormattedString());
            }
            this.dropResultTable();
            throw new IOException(builder.toString());
        }
    }

    public int getSerializedSize() {
        int msgsize = 18;
        if (this.appStatusString != null) {
            this.encodedAppStatusString = this.appStatusString.getBytes(StandardCharsets.UTF_8);
            msgsize += this.encodedAppStatusString.length + 4;
        }
        if (this.statusString != null) {
            this.encodedStatusString = this.statusString.getBytes(StandardCharsets.UTF_8);
            msgsize += this.encodedStatusString.length + 4;
        }
        if (this.m_hashes != null) {
            msgsize += 2;
            msgsize += this.m_hashes.length * 4;
        }
        for (VoltTable vt : this.results) {
            msgsize += vt.getSerializedSize();
        }
        return msgsize;
    }

    public ByteBuffer flattenToBuffer(ByteBuffer buf) {
        assert (this.setProperly);
        buf.put((byte)0);
        buf.putLong(this.clientHandle);
        byte presentFields = 0;
        if (this.appStatusString != null) {
            presentFields = (byte)(presentFields | 0x80);
        }
        if (this.statusString != null) {
            presentFields = (byte)(presentFields | 0x20);
        }
        if (this.m_hashes != null) {
            presentFields = (byte)(presentFields | 0x10);
        }
        buf.put(presentFields);
        buf.put(this.status);
        if (this.statusString != null) {
            buf.putInt(this.encodedStatusString.length);
            buf.put(this.encodedStatusString);
        }
        buf.put(this.appStatus);
        if (this.appStatusString != null) {
            buf.putInt(this.encodedAppStatusString.length);
            buf.put(this.encodedAppStatusString);
        }
        buf.putInt(this.clusterRoundTripTime);
        if (this.m_hashes != null) {
            assert (this.m_hashes.length <= Short.MAX_VALUE) : "CRI hash array length overflow";
            buf.putShort((short)this.m_hashes.length);
            for (int hash : this.m_hashes) {
                buf.putInt(hash);
            }
        }
        buf.putShort((short)this.results.length);
        for (VoltTable vt : this.results) {
            vt.flattenToBuffer(buf);
        }
        return buf;
    }

    @Override
    public int getClusterRoundtrip() {
        return this.clusterRoundTripTime;
    }

    public void setClusterRoundtrip(int time) {
        this.clusterRoundTripTime = time;
    }

    @Override
    public int getClientRoundtrip() {
        return this.clientRoundTripTime;
    }

    @Override
    public long getClientRoundtripNanos() {
        return this.clientRoundTripTimeNanos;
    }

    public void setClientRoundtrip(long timeNanos) {
        this.clientRoundTripTimeNanos = timeNanos;
        this.clientRoundTripTime = (int)TimeUnit.NANOSECONDS.toMillis(timeNanos);
    }

    @Override
    public byte getAppStatus() {
        return this.appStatus;
    }

    @Override
    public String getAppStatusString() {
        return this.appStatusString;
    }

    public boolean isTransactionallySuccessful() {
        return ClientResponseImpl.isTransactionallySuccessful(this.status);
    }

    public static boolean isTransactionallySuccessful(byte status) {
        return status == 1 || status == -9;
    }

    public String toStatusJSONString() {
        JSONStringer js = new JSONStringer();
        try {
            js.object();
            js.keySymbolValuePair(JSON_STATUS_KEY, this.status);
            js.keySymbolValuePair(JSON_APPSTATUS_KEY, this.appStatus);
            js.keySymbolValuePair(JSON_STATUSSTRING_KEY, this.statusString);
            js.keySymbolValuePair(JSON_APPSTATUSSTRING_KEY, this.appStatusString);
            js.endObject();
        }
        catch (JSONException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to serialize a parameter set to JSON.", e);
        }
        return js.toString();
    }

    @Override
    public String toJSONString() {
        JSONStringer js = new JSONStringer();
        try {
            js.object();
            js.keySymbolValuePair(JSON_STATUS_KEY, this.status);
            js.keySymbolValuePair(JSON_APPSTATUS_KEY, this.appStatus);
            js.keySymbolValuePair(JSON_STATUSSTRING_KEY, this.statusString);
            js.keySymbolValuePair(JSON_APPSTATUSSTRING_KEY, this.appStatusString);
            js.key(JSON_RESULTS_KEY);
            js.array();
            for (VoltTable o : this.results) {
                js.value(o);
            }
            js.endArray();
            js.endObject();
        }
        catch (JSONException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to serialize a parameter set to JSON.", e);
        }
        return js.toString();
    }

    public void dropResultTable() {
        this.results = new VoltTable[0];
    }

    public static boolean aborted(byte status) {
        return status == -1 || status == -17;
    }

    public boolean aborted() {
        return ClientResponseImpl.aborted(this.status);
    }

    public static boolean failed(byte status) {
        return status != 1 && !ClientResponseImpl.aborted(status);
    }

    public boolean failed() {
        return ClientResponseImpl.failed(this.status);
    }
}

