/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.utils;

import org.voltcore.logging.Level;
import org.voltcore.logging.VoltLogger;

public class RateLimitedLogger {
    private volatile long m_lastLogTime = 0L;
    private final long m_maxLogIntervalMillis;
    private final VoltLogger m_logger;
    private final Level m_level;

    public RateLimitedLogger(long maxLogIntervalMillis, VoltLogger logger, Level level) {
        this.m_maxLogIntervalMillis = maxLogIntervalMillis;
        this.m_logger = logger;
        this.m_level = level;
    }

    public void log(String message, long now) {
        this.log(message, now, this.m_level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String message, long now, Level level) {
        if (now - this.m_lastLogTime > this.m_maxLogIntervalMillis) {
            RateLimitedLogger rateLimitedLogger = this;
            synchronized (rateLimitedLogger) {
                if (now - this.m_lastLogTime > this.m_maxLogIntervalMillis) {
                    this.m_logger.log(level, message, null);
                    this.m_lastLogTime = now;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(long now, Level level, Throwable cause, String format, Object ... args) {
        if (now - this.m_lastLogTime > this.m_maxLogIntervalMillis) {
            RateLimitedLogger rateLimitedLogger = this;
            synchronized (rateLimitedLogger) {
                if (now - this.m_lastLogTime > this.m_maxLogIntervalMillis) {
                    if (this.m_logger.isEnabledFor(level)) {
                        this.m_logger.logFmt(level, cause, (Object)format, args);
                    }
                    this.m_lastLogTime = now;
                }
            }
        }
    }
}

