/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatencyWatchdog
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger((String)"HOST");
    private static ThreadLocal<AtomicLong> sLatencyVal = new ThreadLocal<AtomicLong>(){

        @Override
        public AtomicLong initialValue() {
            AtomicLong retval = new AtomicLong();
            sLatencyMap.put(Thread.currentThread(), retval);
            return retval;
        }
    };
    private static ConcurrentHashMap<Thread, AtomicLong> sLatencyMap = new ConcurrentHashMap();
    private static final long WATCHDOG_THRESHOLD = Long.getLong("WATCHDOG_THRESHOLD", 100L);
    private static final long WAKEUP_INTERVAL = Long.getLong("WAKEUP_INTERVAL", 25L);
    private static final long MIN_LOG_INTERVAL_SEC = Long.getLong("MIN_LOG_INTERVAL", 10L);
    static LatencyWatchdog sWatchdog;
    public static final boolean sEnable;

    public static void pet() {
        if (!sEnable) {
            return;
        }
        LatencyWatchdog.petImpl();
    }

    private static void petImpl() {
        sLatencyVal.get().lazySet(System.currentTimeMillis());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        Thread.currentThread().setName("Latency Watchdog");
        LatencyWatchdog.LOG.info(String.format("Latency Watchdog enabled -- threshold:%d(ms) wakeup_interval:%d(ms) min_log_interval:%d(sec)\n", new Object[]{LatencyWatchdog.WATCHDOG_THRESHOLD, LatencyWatchdog.WAKEUP_INTERVAL, LatencyWatchdog.MIN_LOG_INTERVAL_SEC}));
        while (true) lbl-1000:
        // 5 sources

        {
            for (Map.Entry<Thread, AtomicLong> entry : LatencyWatchdog.sLatencyMap.entrySet()) {
                t = entry.getKey();
                timestamp = entry.getValue().get();
                now = System.currentTimeMillis();
                if (now - timestamp <= LatencyWatchdog.WATCHDOG_THRESHOLD || t.getState() == Thread.State.TERMINATED) continue;
                sb = new StringBuilder();
                format = "{} has been delayed for more than {}milliseconds\n{}";
                for (StackTraceElement ste : t.getStackTrace()) {
                    sb.append(ste);
                    sb.append("\n");
                }
                LatencyWatchdog.LOG.warn(format, new Object[]{t.getName(), LatencyWatchdog.WATCHDOG_THRESHOLD, sb});
            }
            try {
                Thread.sleep(LatencyWatchdog.WAKEUP_INTERVAL);
                ** continue;
            }
            catch (Exception e) {
                LatencyWatchdog.LOG.debug("Sleep interrupted.", (Throwable)e);
                continue;
            }
            break;
        }
    }

    static {
        sEnable = Boolean.getBoolean("ENABLE_LATENCY_WATCHDOG");
        if (sEnable) {
            sWatchdog = new LatencyWatchdog();
            sWatchdog.start();
        }
    }
}

