/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.utils;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.voltcore.logging.VoltLogger;
import org.voltcore.utils.EstTime;

public class EstTimeUpdater {
    public static final long maxErrorReportInterval = 60000L;
    public static long lastErrorReport = System.currentTimeMillis() - 60000L;
    public static final int ESTIMATED_TIME_UPDATE_FREQUENCY = Integer.getInteger("ESTIMATED_TIME_UPDATE_FREQUENCY", 5);
    public static final int ESTIMATED_TIME_WARN_INTERVAL = Integer.getInteger("ESTIMATED_TIME_WARN_INTERVAL", 2000);
    public static volatile boolean s_pause = false;
    public static final AtomicBoolean s_done = new AtomicBoolean(true);
    private static final VoltLogger hostLog = new VoltLogger("HOST");
    private static final Runnable updaterRunnable = new Runnable(){

        @Override
        public void run() {
            EstTimeUpdater.update(System.currentTimeMillis());
            while (true) {
                Long delta;
                block3: {
                    try {
                        Thread.sleep(ESTIMATED_TIME_UPDATE_FREQUENCY);
                    }
                    catch (InterruptedException e) {
                        if (!s_done.get()) break block3;
                        EstTimeUpdater.update(Long.MIN_VALUE);
                        return;
                    }
                }
                if (s_pause || (delta = EstTimeUpdater.update(System.currentTimeMillis())) == null) continue;
                hostLog.warnFmt("The internal time-keeper thread has not been updated for %,.3f seconds. This could be caused by contention, swapping, sleeping, or other environmental issues, and may lead to long transaction processing times and even node timeouts.", (double)delta.longValue() / 1000.0);
            }
        }
    };
    private static final AtomicReference<Thread> updater = new AtomicReference();

    public static synchronized void stop() {
        Thread updaterThread;
        if (s_done.compareAndSet(false, true) && updater.compareAndSet(updaterThread = updater.get(), null)) {
            updaterThread.interrupt();
            try {
                updaterThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static synchronized void start() {
        if (s_done.compareAndSet(true, false) && updater.compareAndSet(null, new Thread(updaterRunnable))) {
            updater.get().setDaemon(true);
            updater.get().setName("Estimated Time Updater");
            updater.get().start();
        }
    }

    public static Long update(long now) {
        long estNow = EstTime.m_now;
        if (estNow == now) {
            return null;
        }
        EstTime.m_now = now;
        if (now - estNow > (long)ESTIMATED_TIME_WARN_INTERVAL) {
            if (lastErrorReport > now) {
                lastErrorReport = now;
            }
            if (now - lastErrorReport > 60000L) {
                lastErrorReport = now;
                return now - estNow;
            }
        }
        return null;
    }
}

