/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.utils;

import com.google_voltpatches.common.base.Preconditions;
import com.google_voltpatches.common.base.Supplier;
import com.google_voltpatches.common.base.Suppliers;
import com.google_voltpatches.common.collect.ImmutableCollection;
import com.google_voltpatches.common.collect.ImmutableList;
import com.google_voltpatches.common.collect.ImmutableMap;
import com.google_voltpatches.common.collect.Sets;
import com.google_voltpatches.common.util.concurrent.ListenableFuture;
import com.google_voltpatches.common.util.concurrent.ListenableFutureTask;
import com.google_voltpatches.common.util.concurrent.ListeningExecutorService;
import com.google_voltpatches.common.util.concurrent.MoreExecutors;
import com.google_voltpatches.common.util.concurrent.SettableFuture;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.voltcore.logging.Level;
import org.voltcore.logging.VoltLogger;
import org.voltcore.network.ReverseDNSCache;

public class CoreUtils {
    public static final int SMALL_STACK_SIZE = 262144;
    public static final int MEDIUM_STACK_SIZE = 524288;
    public static volatile Runnable m_threadLocalDeallocator = () -> {};
    public static final ExecutorService SAMETHREADEXECUTOR = new ExecutorService(){

        @Override
        public void execute(Runnable command) {
            if (command == null) {
                throw new NullPointerException();
            }
            command.run();
        }

        @Override
        public void shutdown() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) {
            return true;
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            Preconditions.checkNotNull(task);
            FutureTask<T> retval = new FutureTask<T>(task);
            retval.run();
            return retval;
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            Preconditions.checkNotNull(task);
            FutureTask<T> retval = new FutureTask<T>(task, result);
            retval.run();
            return retval;
        }

        @Override
        public Future<?> submit(Runnable task) {
            Preconditions.checkNotNull(task);
            FutureTask<Object> retval = new FutureTask<Object>(task, null);
            retval.run();
            return retval;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
            Preconditions.checkNotNull(tasks);
            ArrayList<Future<T>> retval = new ArrayList<Future<T>>(tasks.size());
            for (Callable<T> c : tasks) {
                FutureTask<T> ft = new FutureTask<T>(c);
                retval.add(new FutureTask<T>(c));
                ft.run();
            }
            return retval;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
            FutureTask ft;
            int ii;
            Preconditions.checkNotNull(tasks);
            Preconditions.checkNotNull(unit);
            long end = System.nanoTime() + unit.toNanos(timeout);
            ArrayList<Future<T>> retval = new ArrayList<Future<T>>(tasks.size());
            for (Callable<T> c : tasks) {
                retval.add(new FutureTask<T>(c));
            }
            int size = retval.size();
            for (ii = 0; ii < size; ++ii) {
                ft = (FutureTask)retval.get(ii);
                ft.run();
                if (System.nanoTime() > end) break;
            }
            while (ii < size) {
                ft = (FutureTask)retval.get(ii);
                ft.cancel(false);
                ++ii;
            }
            return retval;
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws ExecutionException {
            T retval = null;
            Throwable lastException = null;
            boolean haveRetval = false;
            for (Callable<T> c : tasks) {
                try {
                    retval = c.call();
                    haveRetval = true;
                    break;
                }
                catch (Throwable t) {
                    lastException = t;
                }
            }
            if (haveRetval) {
                return retval;
            }
            throw new ExecutionException(lastException);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws ExecutionException, TimeoutException {
            long end = System.nanoTime() + unit.toNanos(timeout);
            T retval = null;
            Throwable lastException = null;
            boolean haveRetval = false;
            for (Callable<T> c : tasks) {
                if (System.nanoTime() > end) {
                    throw new TimeoutException("CoreUtils.ExecutorService.invokeAny()");
                }
                try {
                    retval = c.call();
                    haveRetval = true;
                    break;
                }
                catch (Throwable t) {
                    lastException = t;
                }
            }
            if (haveRetval) {
                return retval;
            }
            throw new ExecutionException(lastException);
        }
    };
    public static final ListeningExecutorService LISTENINGSAMETHREADEXECUTOR = new ListeningExecutorService(){

        @Override
        public void execute(Runnable command) {
            if (command == null) {
                throw new NullPointerException();
            }
            command.run();
        }

        @Override
        public void shutdown() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) {
            return true;
        }

        @Override
        public <T> ListenableFuture<T> submit(Callable<T> task) {
            Preconditions.checkNotNull(task);
            ListenableFutureTask<T> retval = ListenableFutureTask.create(task);
            retval.run();
            return retval;
        }

        @Override
        public <T> ListenableFuture<T> submit(Runnable task, T result) {
            Preconditions.checkNotNull(task);
            ListenableFutureTask<T> retval = ListenableFutureTask.create(task, result);
            retval.run();
            return retval;
        }

        @Override
        public ListenableFuture<?> submit(Runnable task) {
            Preconditions.checkNotNull(task);
            ListenableFutureTask<Object> retval = ListenableFutureTask.create(task, null);
            retval.run();
            return retval;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
            Preconditions.checkNotNull(tasks);
            ArrayList<Future<T>> retval = new ArrayList<Future<T>>(tasks.size());
            for (Callable<T> c : tasks) {
                FutureTask<T> ft = new FutureTask<T>(c);
                retval.add(new FutureTask<T>(c));
                ft.run();
            }
            return retval;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
            FutureTask ft;
            int ii;
            Preconditions.checkNotNull(tasks);
            Preconditions.checkNotNull(unit);
            long end = System.nanoTime() + unit.toNanos(timeout);
            ArrayList<Future<T>> retval = new ArrayList<Future<T>>(tasks.size());
            for (Callable<T> c : tasks) {
                retval.add(new FutureTask<T>(c));
            }
            int size = retval.size();
            for (ii = 0; ii < size; ++ii) {
                ft = (FutureTask)retval.get(ii);
                ft.run();
                if (System.nanoTime() > end) break;
            }
            while (ii < size) {
                ft = (FutureTask)retval.get(ii);
                ft.cancel(false);
                ++ii;
            }
            return retval;
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws ExecutionException {
            T retval = null;
            Throwable lastException = null;
            boolean haveRetval = false;
            for (Callable<T> c : tasks) {
                try {
                    retval = c.call();
                    haveRetval = true;
                    break;
                }
                catch (Throwable t) {
                    lastException = t;
                }
            }
            if (haveRetval) {
                return retval;
            }
            throw new ExecutionException(lastException);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws ExecutionException, TimeoutException {
            long end = System.nanoTime() + unit.toNanos(timeout);
            T retval = null;
            Throwable lastException = null;
            boolean haveRetval = false;
            for (Callable<T> c : tasks) {
                if (System.nanoTime() > end) {
                    throw new TimeoutException("CoreUtils.ListeningExecutorService.invokeAny()");
                }
                try {
                    retval = c.call();
                    haveRetval = true;
                    break;
                }
                catch (Throwable t) {
                    lastException = t;
                }
            }
            if (haveRetval) {
                return retval;
            }
            throw new ExecutionException(lastException);
        }
    };
    public static final ListenableFuture<Object> COMPLETED_FUTURE = new ListenableFuture<Object>(){

        @Override
        public void addListener(Runnable listener, Executor executor) {
            executor.execute(listener);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public Object get() {
            return null;
        }

        @Override
        public Object get(long timeout, TimeUnit unit) {
            return null;
        }
    };
    public static final Runnable EMPTY_RUNNABLE = () -> {};
    private static final Supplier<InetAddress> m_localAddressSupplier = Suppliers.memoizeWithExpiration(() -> {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                if (interfaces == null) {
                    return null;
                }
                NetworkInterface intf = interfaces.nextElement();
                Enumeration<InetAddress> addresses = intf.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (!(address instanceof Inet4Address)) continue;
                    return address;
                }
                addresses = intf.getInetAddresses();
                if (addresses.hasMoreElements()) {
                    return addresses.nextElement();
                }
                return null;
            }
            catch (SocketException e1) {
                return null;
            }
        }
    }, 1L, TimeUnit.DAYS);
    public static final long LOCK_SPIN_MICROSECONDS = TimeUnit.MICROSECONDS.toNanos(Integer.getInteger("LOCK_SPIN_MICROS", 0).intValue());
    public static final long QUEUE_SPIN_MICROSECONDS = TimeUnit.MICROSECONDS.toNanos(Integer.getInteger("QUEUE_SPIN_MICROS", 0).intValue());

    public static ListeningExecutorService getCachedSingleThreadExecutor(String name, long keepAlive) {
        return MoreExecutors.listeningDecorator(new ThreadPoolExecutor(0, 1, keepAlive, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), CoreUtils.getThreadFactory(null, name, 262144, false)));
    }

    public static ExecutorService getSingleThreadExecutor(String name) {
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), CoreUtils.getThreadFactory(null, name, 262144, false));
    }

    public static ExecutorService getSingleThreadExecutor(String name, int size) {
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), CoreUtils.getThreadFactory(null, name, size, false));
    }

    public static ListeningExecutorService getListeningSingleThreadExecutor(String name) {
        ThreadPoolExecutor ste = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), CoreUtils.getThreadFactory(null, name, 262144, false));
        return MoreExecutors.listeningDecorator(ste);
    }

    public static ListeningExecutorService getListeningSingleThreadExecutor(String name, int size) {
        ThreadPoolExecutor ste = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), CoreUtils.getThreadFactory(null, name, size, false));
        return MoreExecutors.listeningDecorator(ste);
    }

    public static ListeningExecutorService getBoundedSingleThreadExecutor(String name, int capacity) {
        LinkedBlockingQueue<Runnable> lbq = new LinkedBlockingQueue<Runnable>(capacity);
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, lbq, CoreUtils.getThreadFactory(name));
        return MoreExecutors.listeningDecorator(tpe);
    }

    public static ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor(String name, int poolSize, int stackSize) {
        ScheduledThreadPoolExecutor ses = new ScheduledThreadPoolExecutor(poolSize, CoreUtils.getThreadFactory(null, name, stackSize, poolSize > 1));
        ses.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        ses.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        return ses;
    }

    public static ListeningExecutorService getListeningExecutorService(String name, int threads) {
        return CoreUtils.getListeningExecutorService(name, threads, new LinkedTransferQueue<Runnable>());
    }

    private static ListeningExecutorService getListeningExecutorService(String name, int threads, BlockingQueue<Runnable> queue) {
        if (threads < 1) {
            throw new IllegalArgumentException("Must specify > 0 threads");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        return MoreExecutors.listeningDecorator(new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MILLISECONDS, queue, CoreUtils.getThreadFactory(null, name, 262144, threads > 1)));
    }

    public static ThreadPoolExecutor getBoundedThreadPoolExecutor(int maxPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory tFactory) {
        return new ThreadPoolExecutor(0, maxPoolSize, keepAliveTime, unit, new SynchronousQueue<Runnable>(), tFactory);
    }

    public static ExecutorService getQueueingExecutorService(final Queue<Runnable> taskQueue) {
        return new ExecutorService(){

            @Override
            public void execute(Runnable command) {
                taskQueue.offer(command);
            }

            @Override
            public void shutdown() {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<Runnable> shutdownNow() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isShutdown() {
                return false;
            }

            @Override
            public boolean isTerminated() {
                return false;
            }

            @Override
            public boolean awaitTermination(long timeout, TimeUnit unit) {
                return true;
            }

            @Override
            public <T> Future<T> submit(Callable<T> task) {
                Preconditions.checkNotNull(task);
                FutureTask<T> retval = new FutureTask<T>(task);
                taskQueue.offer(retval);
                return retval;
            }

            @Override
            public <T> Future<T> submit(Runnable task, T result) {
                Preconditions.checkNotNull(task);
                FutureTask<T> retval = new FutureTask<T>(task, result);
                taskQueue.offer(retval);
                return retval;
            }

            @Override
            public Future<?> submit(Runnable task) {
                Preconditions.checkNotNull(task);
                ListenableFutureTask<Object> retval = ListenableFutureTask.create(task, null);
                taskQueue.offer(retval);
                return retval;
            }

            @Override
            public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T> T invokeAny(Collection<? extends Callable<T>> tasks) {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static ThreadFactory getThreadFactory(String name) {
        return CoreUtils.getThreadFactory(null, name, 262144, true);
    }

    public static ThreadFactory getThreadFactory(String groupName, String name) {
        return CoreUtils.getThreadFactory(groupName, name, 262144, true);
    }

    public static ThreadFactory getThreadFactory(String name, int stackSize) {
        return CoreUtils.getThreadFactory(null, name, stackSize, true);
    }

    public static ThreadFactory getThreadFactory(String groupName, final String name, final int stackSize, final boolean incrementThreadNames) {
        ThreadGroup group = null;
        if (groupName != null) {
            group = new ThreadGroup(Thread.currentThread().getThreadGroup(), groupName);
        }
        final ThreadGroup finalGroup = group;
        return new ThreadFactory(){
            private final AtomicLong m_createdThreadCount = new AtomicLong(0L);
            private final ThreadGroup m_group = finalGroup;

            @Override
            public synchronized Thread newThread(Runnable r) {
                String threadName = name + (String)(incrementThreadNames ? " - " + this.m_createdThreadCount.getAndIncrement() : "");
                Runnable runnable = () -> {
                    try {
                        r.run();
                    }
                    catch (Throwable t) {
                        new VoltLogger("HOST").error("Exception thrown in thread " + threadName, t);
                    }
                    finally {
                        m_threadLocalDeallocator.run();
                    }
                };
                Thread t = new Thread(this.m_group, runnable, threadName, stackSize);
                t.setDaemon(true);
                return t;
            }
        };
    }

    public static String getHostnameOrAddress() {
        InetAddress addr = m_localAddressSupplier.get();
        if (addr == null) {
            return "";
        }
        return ReverseDNSCache.hostnameOrAddress(addr);
    }

    public static String getHostnameAndAddress() {
        return CoreUtils.addressToString(m_localAddressSupplier.get());
    }

    public static String addressToString(InetAddress addr) {
        if (addr == null) {
            return "";
        }
        StringBuilder hostnameAndAddress = new StringBuilder();
        String address = addr.getHostAddress();
        String hostnameOrAddress = ReverseDNSCache.hostnameOrAddress(addr);
        if (!hostnameOrAddress.equals(address)) {
            hostnameAndAddress.append(hostnameOrAddress);
        }
        hostnameAndAddress.append('/').append(address);
        return hostnameAndAddress.toString();
    }

    public static InetAddress getLocalAddress() {
        return m_localAddressSupplier.get();
    }

    public static long getHSIdFromHostAndSite(int host, int site) {
        long HSId = site;
        HSId = (HSId << 32) + (long)host;
        return HSId;
    }

    public static int getHostIdFromHSId(long HSId) {
        return (int)HSId;
    }

    public static Set<Integer> getHostIdsFromHSIDs(Collection<Long> hsids) {
        HashSet<Integer> hosts = Sets.newHashSet();
        for (Long id : hsids) {
            hosts.add(CoreUtils.getHostIdFromHSId(id));
        }
        return hosts;
    }

    public static String hsIdToString(long hsId) {
        return CoreUtils.hsIdToString(hsId, ":");
    }

    public static String hsIdToString(long hsId, String delimiter) {
        return (int)hsId + delimiter + (int)(hsId >> 32);
    }

    public static void hsIdToString(long hsId, StringBuilder sb) {
        sb.append((int)hsId).append(":").append((int)(hsId >> 32));
    }

    public static String hsIdCollectionToString(Collection<Long> ids) {
        ArrayList<String> idstrings = new ArrayList<String>();
        for (Long id : ids) {
            idstrings.add(CoreUtils.hsIdToString(id));
        }
        Collections.sort(idstrings);
        StringBuilder sb = new StringBuilder();
        boolean first = false;
        for (String id : idstrings) {
            if (!first) {
                first = true;
            } else {
                sb.append(", ");
            }
            sb.append(id);
        }
        return sb.toString();
    }

    public static int getSiteIdFromHSId(long siteId) {
        return (int)(siteId >> 32);
    }

    public static int hsIdToInt(long hsId) {
        int hostId = CoreUtils.getHostIdFromHSId(hsId);
        return Integer.parseInt((hostId > 0 ? String.valueOf(CoreUtils.getHostIdFromHSId(hsId)) : "") + CoreUtils.getHostIdFromHSId(hsId));
    }

    public static <K, V> ImmutableMap<K, ImmutableList<V>> unmodifiableMapCopy(Map<K, List<V>> m) {
        ImmutableMap.Builder<K, ImmutableCollection> builder = ImmutableMap.builder();
        for (Map.Entry<K, List<V>> e : m.entrySet()) {
            builder.put(e.getKey(), ((ImmutableList.Builder)ImmutableList.builder().addAll(e.getValue())).build());
        }
        return builder.build();
    }

    public static byte[] urlToBytes(String url) {
        ByteArrayOutputStream baos = CoreUtils.urlToStream(url);
        return baos == null ? null : baos.toByteArray();
    }

    public static String urlToString(String url) {
        ByteArrayOutputStream baos = CoreUtils.urlToStream(url);
        try {
            return baos == null ? null : baos.toString(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static ByteArrayOutputStream urlToStream(String url) {
        if (url == null) {
            return null;
        }
        try {
            int read;
            InputStream input;
            try {
                URL inputURL = new URL(url);
                input = inputURL.openStream();
            }
            catch (MalformedURLException ex) {
                try {
                    input = new FileInputStream(url);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (IOException ioex) {
                throw new RuntimeException(ioex);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] readBytes = new byte[8192];
            while ((read = input.read(readBytes)) != -1) {
                baos.write(readBytes, 0, read);
            }
            return baos;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String throwableToString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public static String hsIdKeyMapToString(Map<Long, ?> m) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean first = true;
        for (Map.Entry<Long, ?> entry : m.entrySet()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(CoreUtils.hsIdToString(entry.getKey()));
            sb.append("->").append(entry.getValue());
        }
        sb.append('}');
        return sb.toString();
    }

    public static String hsIdValueMapToString(Map<?, Long> m) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean first = true;
        for (Map.Entry<?, Long> entry : m.entrySet()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(entry.getKey()).append("->");
            sb.append(CoreUtils.hsIdToString(entry.getValue()));
        }
        sb.append('}');
        return sb.toString();
    }

    public static String hsIdMapToString(Map<Long, Long> m) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean first = true;
        for (Map.Entry<Long, Long> entry : m.entrySet()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(CoreUtils.hsIdToString(entry.getKey())).append(" -> ");
            sb.append(CoreUtils.hsIdToString(entry.getValue()));
        }
        sb.append('}');
        return sb.toString();
    }

    public static int availableProcessors() {
        return Math.max(1, Runtime.getRuntime().availableProcessors());
    }

    public static <T> ListenableFuture<T> retryHelper(ScheduledExecutorService ses, ExecutorService es, Callable<T> callable, long maxAttempts, long startInterval, TimeUnit startUnit, long maxInterval, TimeUnit maxUnit) {
        SettableFuture future = SettableFuture.create();
        CoreUtils.retryHelper(ses, es, callable, maxAttempts, startInterval, startUnit, maxInterval, maxUnit, future);
        return future;
    }

    public static <T> void retryHelper(ScheduledExecutorService ses, ExecutorService es, Callable<T> callable, long maxAttempts, long startInterval, TimeUnit startUnit, long maxInterval, TimeUnit maxUnit, SettableFuture<T> future) {
        Preconditions.checkNotNull(maxUnit);
        Preconditions.checkNotNull(startUnit);
        Preconditions.checkArgument(startUnit.toMillis(startInterval) >= 1L);
        Preconditions.checkArgument(maxUnit.toMillis(maxInterval) >= 1L);
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(future);
        es.execute(() -> {
            try {
                future.set(callable.call());
            }
            catch (RetryException e) {
                CoreUtils.retryHelper(ses, es, callable, maxAttempts - 1L, startInterval, startUnit, maxInterval, maxUnit, 0L, future);
            }
            catch (Exception e) {
                future.setException(e);
            }
        });
    }

    private static <T> void retryHelper(ScheduledExecutorService ses, ExecutorService es, Callable<T> callable, long maxAttempts, long startInterval, TimeUnit startUnit, long maxInterval, TimeUnit maxUnit, long ii, SettableFuture<T> retval) {
        if (maxAttempts == 0L) {
            retval.setException(new RuntimeException("Max attempts reached"));
            return;
        }
        long intervalMax = maxUnit.toMillis(maxInterval);
        long interval = Math.min(intervalMax, startUnit.toMillis(startInterval) * 2L);
        ses.schedule(() -> {
            Runnable task = () -> {
                if (retval.isCancelled()) {
                    return;
                }
                try {
                    retval.set(callable.call());
                }
                catch (RetryException e) {
                    CoreUtils.retryHelper(ses, es, callable, maxAttempts - 1L, interval, TimeUnit.MILLISECONDS, maxInterval, maxUnit, ii + 1L, retval);
                }
                catch (Exception e3) {
                    retval.setException(e3);
                }
            };
            if (ses == es) {
                task.run();
            } else {
                es.execute(task);
            }
        }, interval, TimeUnit.MILLISECONDS);
    }

    public static void spinLock(ReentrantLock lock) {
        if (LOCK_SPIN_MICROSECONDS > 0L) {
            long nanos = -1L;
            while (true) {
                if (lock.tryLock()) {
                    return;
                }
                if (nanos == -1L) {
                    nanos = System.nanoTime();
                    continue;
                }
                if (System.nanoTime() - nanos > LOCK_SPIN_MICROSECONDS) break;
            }
            lock.lock();
            return;
        }
        lock.lock();
    }

    public static <T> T queueSpinTake(BlockingQueue<T> queue) throws InterruptedException {
        if (QUEUE_SPIN_MICROSECONDS > 0L) {
            long nanos = -1L;
            while (true) {
                Object retval;
                if ((retval = queue.poll()) != null) {
                    return (T)retval;
                }
                if (nanos == -1L) {
                    nanos = System.nanoTime();
                    continue;
                }
                if (System.nanoTime() - nanos > QUEUE_SPIN_MICROSECONDS) break;
            }
            return queue.take();
        }
        return queue.take();
    }

    public static boolean isStoredProcThrowableFatalToServer(Throwable th) {
        if (th instanceof LinkageError || th instanceof AssertionError) {
            return false;
        }
        return !(th instanceof Exception);
    }

    public static <K extends Comparable<? super K>, V extends Comparable<? super V>> List<Map.Entry<K, V>> sortKeyValuePairByValue(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        entries.sort((o1, o2) -> {
            if (!((Comparable)o1.getValue()).equals(o2.getValue())) {
                return ((Comparable)o1.getValue()).compareTo(o2.getValue());
            }
            return ((Comparable)o1.getKey()).compareTo(o2.getKey());
        });
        return entries;
    }

    public static void logProcedureInvocation(VoltLogger log, String userName, String where, String procedure) {
        String msg = "User " + userName + " from " + where + " issued a " + procedure;
        if ("@PrepareShutdown".equals(procedure)) {
            VoltLogger.logWithEmphasis(log, msg, Level.INFO);
        } else {
            log.info(msg);
        }
    }

    public static boolean isJunitTest() {
        if ("true".equalsIgnoreCase(System.getenv().get("VOLT_JUSTATEST"))) {
            return true;
        }
        return "true".equalsIgnoreCase(System.getProperty("VOLT_JUSTATEST"));
    }

    public static final class RetryException
    extends Exception {
        private static final long serialVersionUID = 3651804109132974056L;

        public RetryException() {
        }

        public RetryException(Throwable cause) {
            super(cause);
        }

        public RetryException(String errMsg) {
            super(errMsg);
        }
    }

    public static class ErrorHandlingScheduledThreadPool
    extends ScheduledThreadPoolExecutor {
        private static final VoltLogger s_logger = new VoltLogger("HOST");
        private volatile Consumer<Throwable> m_consumer;

        public ErrorHandlingScheduledThreadPool(int corePoolSize) {
            super(corePoolSize);
        }

        public ErrorHandlingScheduledThreadPool(int corePoolSize, RejectedExecutionHandler handler) {
            super(corePoolSize, handler);
        }

        public ErrorHandlingScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory) {
            super(corePoolSize, threadFactory);
        }

        public ErrorHandlingScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, threadFactory, handler);
        }

        public ErrorHandlingScheduledThreadPool setConsumer(Consumer<Throwable> consumer) {
            this.m_consumer = consumer;
            return this;
        }

        @Override
        protected void afterExecute(Runnable runnable, Throwable throwable) {
            super.afterExecute(runnable, throwable);
            assert (throwable == null);
            assert (runnable instanceof ScheduledFuture);
            try {
                ((Future)((Object)runnable)).get();
            }
            catch (CancellationException ce) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug("Task Cancelled: ", ce);
                }
            }
            catch (ExecutionException ee) {
                throwable = ee.getCause();
            }
            catch (InterruptedException ie) {
                throwable = ie;
            }
            if (throwable != null) {
                if (this.m_consumer == null) {
                    s_logger.error("Error from ErrorHandlingScheduledThreadPool thread", throwable);
                } else {
                    this.m_consumer.accept(throwable);
                }
            }
        }
    }
}

