/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.utils;

import com.google_voltpatches.common.base.Preconditions;
import com.google_voltpatches.common.collect.ForwardingNavigableSet;
import com.google_voltpatches.common.collect.ImmutableSet;
import com.google_voltpatches.common.collect.ImmutableSortedSet;
import java.util.Collection;
import java.util.NavigableSet;
import java.util.concurrent.atomic.AtomicReference;

public class COWNavigableSet<E extends Comparable<E>>
extends ForwardingNavigableSet<E> {
    private final AtomicReference<ImmutableSortedSet<E>> m_set;

    public COWNavigableSet() {
        this.m_set = new AtomicReference(ImmutableSortedSet.of());
    }

    public COWNavigableSet(Collection<E> c) {
        Preconditions.checkNotNull(c);
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        for (Comparable e : c) {
            builder.add(e);
        }
        this.m_set = new AtomicReference<ImmutableSet>(builder.build());
    }

    @Override
    protected NavigableSet<E> delegate() {
        return this.m_set.get();
    }

    @Override
    public E pollFirst() {
        Comparable first;
        ImmutableSortedSet.Builder builder;
        ImmutableSortedSet<E> snapshot;
        do {
            snapshot = this.m_set.get();
            first = null;
            if (snapshot.size() <= 0) {
                return null;
            }
            first = (Comparable)snapshot.first();
            builder = ImmutableSortedSet.naturalOrder();
            builder.addAll((Iterable)snapshot.tailSet(first, false));
        } while (!this.m_set.compareAndSet(snapshot, (ImmutableSortedSet<E>)builder.build()));
        return (E)first;
    }

    @Override
    public E pollLast() {
        Comparable last;
        ImmutableSortedSet.Builder builder;
        ImmutableSortedSet<E> snapshot;
        do {
            snapshot = this.m_set.get();
            last = null;
            if (snapshot.size() <= 0) {
                return null;
            }
            last = (Comparable)snapshot.last();
            builder = ImmutableSortedSet.naturalOrder();
            builder.addAll((Iterable)snapshot.headSet(last, false));
        } while (!this.m_set.compareAndSet(snapshot, (ImmutableSortedSet<E>)builder.build()));
        return (E)last;
    }

    @Override
    public boolean add(E e) {
        ImmutableSortedSet.Builder builder;
        ImmutableSortedSet<E> snapshot;
        do {
            if ((snapshot = this.m_set.get()).contains(e)) {
                return false;
            }
            builder = ImmutableSortedSet.naturalOrder();
            builder.addAll(snapshot);
            builder.add((Object)e);
        } while (!this.m_set.compareAndSet(snapshot, (ImmutableSortedSet<E>)builder.build()));
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        block2: {
            ImmutableSortedSet.Builder builder;
            ImmutableSortedSet<E> snapshot;
            do {
                snapshot = this.m_set.get();
                builder = ImmutableSortedSet.naturalOrder();
                boolean hadValues = false;
                for (Comparable e : c) {
                    if (snapshot.contains(e)) continue;
                    builder.add(e);
                    hadValues = true;
                }
                if (!hadValues) break block2;
                builder.addAll(snapshot);
            } while (!this.m_set.compareAndSet(snapshot, (ImmutableSortedSet<E>)builder.build()));
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.m_set.set(ImmutableSortedSet.of());
    }

    @Override
    public boolean remove(Object o) {
        ImmutableSortedSet.Builder builder;
        ImmutableSortedSet<E> snapshot;
        do {
            if (!(snapshot = this.m_set.get()).contains(o)) {
                return false;
            }
            builder = ImmutableSortedSet.naturalOrder();
            for (Comparable e : snapshot) {
                if (e.equals(o)) continue;
                builder.add(e);
            }
        } while (!this.m_set.compareAndSet(snapshot, (ImmutableSortedSet<E>)builder.build()));
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        block3: {
            ImmutableSortedSet.Builder builder;
            ImmutableSortedSet<E> snapshot;
            do {
                snapshot = this.m_set.get();
                builder = ImmutableSortedSet.naturalOrder();
                boolean hadValues = false;
                for (Comparable e : snapshot) {
                    if (c.contains(e)) {
                        hadValues = true;
                        continue;
                    }
                    builder.add(e);
                }
                if (!hadValues) break block3;
            } while (!this.m_set.compareAndSet(snapshot, (ImmutableSortedSet<E>)builder.build()));
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        block3: {
            ImmutableSortedSet.Builder builder;
            ImmutableSortedSet<E> snapshot;
            do {
                snapshot = this.m_set.get();
                builder = ImmutableSortedSet.naturalOrder();
                boolean removedValues = false;
                for (Comparable e : snapshot) {
                    if (c.contains(e)) {
                        builder.add(e);
                        continue;
                    }
                    removedValues = true;
                }
                if (!removedValues) break block3;
            } while (!this.m_set.compareAndSet(snapshot, (ImmutableSortedSet<E>)builder.build()));
            return true;
        }
        return false;
    }
}

