/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.utils;

import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.FileChannel;
import org.voltcore.logging.VoltLogger;
import org.voltcore.memory.DBBPool;
import org.voltdb.utils.PosixAdvise;
import org.voltdb.utils.PosixAdviseNative;
import sun.misc.Unsafe;

public final class Bits {
    public static final Unsafe unsafe;
    private static final int PAGE_SIZE;
    private static byte unused;

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                Field f = Unsafe.class.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                return (Unsafe)f.get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException("Cannot get instance of Unsafe", e);
            }
        }
    }

    public static int pageSize() {
        return PAGE_SIZE;
    }

    public static int numPages(int size) {
        return (size + PAGE_SIZE - 1) / PAGE_SIZE;
    }

    public static int roundupToPage(int value) {
        return value + PAGE_SIZE - 1 & ~(PAGE_SIZE - 1);
    }

    public static void readEveryPage(DBBPool.BBContainer cont) {
        long address = cont.address();
        int offset = (int)(address % (long)Bits.pageSize());
        address -= (long)offset;
        int numPages = Bits.numPages(cont.b().remaining() + offset);
        byte checksum = 0;
        for (int ii = 0; ii < numPages; ++ii) {
            checksum = (byte)(checksum ^ unsafe.getByte(address));
            address += (long)PAGE_SIZE;
        }
        if (unused != 0) {
            unused = checksum;
        }
    }

    public static long sync_file_range(VoltLogger logger, FileDescriptor fd, FileChannel fc, long syncStart, long positionAtSync) throws IOException {
        long syncedBytes = positionAtSync / (long)Bits.pageSize() * (long)Bits.pageSize();
        if (PosixAdvise.SYNC_FILE_RANGE_SUPPORTED) {
            long retval = PosixAdviseNative.sync_file_range(fd, syncStart, syncedBytes - syncStart, 7);
            if (retval != 0L) {
                logger.error("Error sync_file_range snapshot data: " + retval);
                logger.error("Params offset " + syncedBytes + " length " + (syncedBytes - syncStart) + " flags 7");
                fc.force(false);
            }
        } else {
            fc.force(false);
        }
        return syncedBytes;
    }

    static {
        Unsafe unsafeTemp = null;
        try {
            unsafeTemp = Bits.getUnsafe();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        unsafe = unsafeTemp;
        PAGE_SIZE = unsafe.pageSize();
    }
}

