/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network.util.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import org.voltcore.network.CipherExecutor;
import org.voltcore.network.util.ssl.MessagingChannel;
import org.voltcore.network.util.ssl.SSLBufferDecrypter;
import org.voltcore.network.util.ssl.SSLBufferEncrypter;

public class TLSMessagingChannel
extends MessagingChannel {
    private final SSLEngine m_engine;
    private final CipherExecutor m_ce;
    private final SSLBufferDecrypter m_decrypter;
    private final SSLBufferEncrypter m_encrypter;
    private static final int NOT_AVAILABLE = -1;

    public TLSMessagingChannel(SocketChannel socketChannel, SSLEngine engine) {
        super(socketChannel);
        this.m_engine = engine;
        this.m_ce = CipherExecutor.valueOf(engine);
        this.m_decrypter = new SSLBufferDecrypter(this.m_engine);
        this.m_encrypter = new SSLBufferEncrypter(this.m_engine);
    }

    private int packetBufferSize() {
        return this.m_engine.getSession().getPacketBufferSize();
    }

    private int applicationBufferSize() {
        return this.m_engine.getSession().getApplicationBufferSize();
    }

    private int validateLength(int sz) throws IOException {
        if (sz < 1 || sz > 0x2000000) {
            throw new IOException("Invalid message length header value: " + sz + ". It must be between 1 and 33554432");
        }
        return sz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer readBytes(int numBytes) throws IOException {
        int appsz = this.applicationBufferSize();
        ByteBuf readbuf = this.m_ce.allocator().ioBuffer(this.packetBufferSize());
        CompositeByteBuf msgbb = Unpooled.compositeBuffer();
        try {
            ByteBuf clear = this.doUnwrap(readbuf, appsz);
            msgbb.addComponent(true, clear);
            int needed = numBytes;
            if (numBytes == -1) {
                needed = msgbb.readableBytes() >= 4 ? this.validateLength(msgbb.readInt()) : -1;
            }
            while (msgbb.readableBytes() < (needed == -1 ? 4 : needed)) {
                clear = this.doUnwrap(readbuf, appsz);
                msgbb.addComponent(true, clear);
                if (needed != -1 || msgbb.readableBytes() < 4) continue;
                needed = this.validateLength(msgbb.readInt());
            }
            ByteBuffer retbb = ByteBuffer.allocate(needed);
            msgbb.readBytes(retbb);
            msgbb.discardReadComponents();
            assert (!msgbb.isReadable()) : "read from unblocked channel that received multiple messages?";
            ByteBuffer byteBuffer = retbb.flip();
            return byteBuffer;
        }
        finally {
            readbuf.release();
            msgbb.release();
        }
    }

    private ByteBuf doUnwrap(ByteBuf readbuf, int appsz) throws IOException {
        ByteBuffer src;
        PooledByteBufAllocator allocator = this.m_ce.allocator();
        ByteBuf clear = allocator.buffer(appsz);
        do {
            readbuf.clear();
            if (SSLBufferDecrypter.readTLSFrame(this.m_socketChannel, readbuf)) continue;
            return null;
        } while (!(clear = this.m_decrypter.tlsunwrap(src = readbuf.nioBuffer(), clear, allocator)).isReadable());
        return clear;
    }

    @Override
    public ByteBuffer readMessage() throws IOException {
        return this.readBytes(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int writeMessage(ByteBuffer message) throws IOException {
        if (!message.hasRemaining()) {
            return 0;
        }
        int bytesWritten = 0;
        ByteBuf outputBuf = this.m_encrypter.tlswrap(message, (ByteBufAllocator)this.m_ce.allocator());
        try {
            while (outputBuf.isReadable()) {
                bytesWritten += outputBuf.readBytes((GatheringByteChannel)this.m_socketChannel, outputBuf.readableBytes());
            }
        }
        finally {
            outputBuf.release();
        }
        return bytesWritten;
    }
}

