/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network.util.ssl;

import io.netty.handler.ssl.CipherSuiteFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class SSLConfiguration {
    private static final boolean PRINT_CIPHERS = Boolean.valueOf(System.getenv("VOLTDB_PRINT_CIPHERS"));
    private static final String[] DEFAULT_ENABLED_PROTOCOLS = new String[]{"TLSv1.3", "TLSv1.2"};
    public static final List<String> ENABLED_PROTOCOLS = SSLConfiguration.makeList("TLS_ENABLED_PROTOCOLS", DEFAULT_ENABLED_PROTOCOLS);
    private static final String[] DEFAULT_EXCLUDED_CIPHERS = new String[]{"^SSL_.*$", "^.*_(MD5|SHA|SHA1)$", "^TLS_RSA_.*$"};
    public static final List<String> EXCLUDED_CIPHERS = SSLConfiguration.makeList("TLS_EXCLUDED_CIPHERS", DEFAULT_EXCLUDED_CIPHERS);
    private static final String[] DEFAULT_PREFERRED_CIPHERS = new String[]{"TLS_AES_256_GCM_SHA384", "TLS_AES_128_GCM_SHA256", "TLS_CHACHA20_POLY1305_SHA256", "TLS_AES_128_CCM_8_SHA256", "TLS_AES_128_CCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_CHACHA20-POLY1305_SHA256", "TLS_ECDHE_RSA_WITH_CHACHA20-POLY1305_SHA256", "TLS_DHE_RSA_WITH_CHACHA20-POLY1305_SHA256", "TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_DSS_WITH_AES_256_GCM_SHA384", "TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_DSS_WITH_AES_128_GCM_SHA256"};
    public static final List<String> PREFERRED_CIPHERS = SSLConfiguration.makeList("TLS_PREFERRED_CIPHERS", DEFAULT_PREFERRED_CIPHERS);
    public static final CipherSuiteFilter CIPHER_FILTER;

    private static List<String> makeList(String property, String[] defaults) {
        String[] values = defaults;
        String propVal = System.getenv(property);
        if (propVal != null && !propVal.isEmpty()) {
            values = propVal.split("\\s*,\\s*");
        }
        return Collections.unmodifiableList(Arrays.asList(values));
    }

    static {
        if (PRINT_CIPHERS) {
            HashSet<String> dups = new HashSet<String>(PREFERRED_CIPHERS);
            dups.retainAll(EXCLUDED_CIPHERS);
            if (!dups.isEmpty()) {
                System.out.printf("Ambiguous cipher configuration:\n\t%s\n", String.join((CharSequence)"\n\t", dups));
            }
        }
        CIPHER_FILTER = new CipherSuiteFilter(){
            private volatile String[] m_cache;

            public String[] filterCipherSuites(Iterable<String> ciphers, List<String> defaultCiphers, Set<String> supportedCiphers) {
                if (this.m_cache == null) {
                    this.populateCache(ciphers, this.tlsSubset(supportedCiphers));
                }
                return (String[])this.m_cache.clone();
            }

            private synchronized void populateCache(Iterable<String> ciphers, Set<String> supportedCiphers) {
                if (this.m_cache == null) {
                    Iterable<String> preferred = ciphers != null ? ciphers : PREFERRED_CIPHERS;
                    String[] selected = this.selectSupported(preferred, supportedCiphers);
                    if (selected.length == 0) {
                        throw new IllegalStateException(String.format("Could not find suitable TLS cipher suites. No preferred cipher suite is supported by the TLS provider.\n-- preferred: %s\n-- supported: %s\n-- enabled protocols: %s\nConsider changing preferences.", preferred, supportedCiphers, ENABLED_PROTOCOLS));
                    }
                    this.m_cache = selected;
                }
            }

            private String[] selectSupported(Iterable<String> ciphers, Set<String> supportedCiphers) {
                if (PRINT_CIPHERS) {
                    this.dumpCiphers("Filter inputs", ciphers, supportedCiphers);
                }
                LinkedHashSet<String> ciphersToUse = new LinkedHashSet<String>();
                for (String cipher : ciphers) {
                    if (!supportedCiphers.contains(cipher)) continue;
                    ciphersToUse.add(cipher);
                }
                if (PRINT_CIPHERS) {
                    this.dumpCiphers("Filter results", ciphersToUse, supportedCiphers);
                }
                return ciphersToUse.toArray(new String[ciphersToUse.size()]);
            }

            private void dumpCiphers(String caption, Iterable<String> ciphers, Set<String> supportedCiphers) {
                System.out.printf("%s:\n", caption);
                int total = 0;
                for (String cipher : ciphers) {
                    Object tag = "";
                    if (!supportedCiphers.contains(cipher)) {
                        tag = (String)tag + ", unsupported";
                    }
                    if (PREFERRED_CIPHERS.contains(cipher)) {
                        tag = (String)tag + ", preferred";
                    }
                    System.out.printf("\t%s%s\n", cipher, tag);
                    ++total;
                }
                System.out.printf("\t%d ciphers\n", total);
            }

            private Set<String> tlsSubset(Set<String> ciphers) {
                LinkedHashSet<String> tls = new LinkedHashSet<String>();
                for (String cipher : ciphers) {
                    if (cipher == null || !cipher.startsWith("TLS_")) continue;
                    tls.add(cipher);
                }
                return tls;
            }
        };
    }
}

