/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network.util.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.ScatteringByteChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.voltcore.network.TLSException;

public class SSLBufferDecrypter {
    public static final int TLS_HEADER_SIZE = 5;
    private final SSLEngine m_sslEngine;

    public SSLBufferDecrypter(SSLEngine sslEngine) {
        this.m_sslEngine = sslEngine;
    }

    public static boolean readTLSFrame(ScatteringByteChannel chn, ByteBuf buf) throws IOException {
        int widx = buf.writerIndex();
        ByteBuf header = buf.slice(widx, 5).clear();
        int rc = 0;
        while ((rc = header.writeBytes(chn, header.writableBytes())) > 0 && header.isWritable()) {
        }
        if (rc < 0) {
            throw new IOException("channel closed while reading tls frame header");
        }
        if (rc == 0) {
            return false;
        }
        short framesz = header.getShort(3);
        if (framesz + header.capacity() > buf.writableBytes()) {
            throw new IOException("destination buffer is too small to contain the whole frame");
        }
        buf.writerIndex(buf.writerIndex() + header.writerIndex());
        ByteBuf frame = buf.slice(buf.writerIndex(), (int)framesz).clear();
        while (frame.isWritable()) {
            if (frame.writeBytes(chn, frame.writableBytes()) >= 0) continue;
            throw new IOException("channel closed while reading tls frame header");
        }
        buf.writerIndex(buf.writerIndex() + framesz);
        return true;
    }

    public int getPacketBufferSize() {
        return this.m_sslEngine.getSession().getPacketBufferSize();
    }

    public ByteBuf tlsunwrap(ByteBuffer srcBuffer, PooledByteBufAllocator allocator) throws TLSException {
        int size = this.m_sslEngine.getSession().getApplicationBufferSize();
        return this.tlsunwrap(srcBuffer, allocator.buffer(size), allocator);
    }

    public ByteBuf tlsunwrap(ByteBuffer srcBuffer, ByteBuf dstBuf, PooledByteBufAllocator allocator) throws TLSException {
        int writerIndex = dstBuf.writerIndex();
        ByteBuffer byteBuffer = dstBuf.nioBuffer(writerIndex, dstBuf.writableBytes());
        block9: while (true) {
            SSLEngineResult result;
            try {
                result = this.m_sslEngine.unwrap(srcBuffer, byteBuffer);
            }
            catch (IllegalArgumentException | IllegalStateException | ReadOnlyBufferException | SSLException e) {
                dstBuf.release();
                throw new TLSException("ssl engine unwrap fault", e);
            }
            catch (Throwable t) {
                dstBuf.release();
                throw t;
            }
            switch (result.getStatus()) {
                case OK: {
                    int bytesProduced = result.bytesProduced();
                    if (bytesProduced > 0) {
                        writerIndex += result.bytesProduced();
                    }
                    if (bytesProduced <= 0 || srcBuffer.hasRemaining()) continue block9;
                    dstBuf.writerIndex(writerIndex);
                    return dstBuf;
                }
                case BUFFER_OVERFLOW: {
                    dstBuf.release();
                    if (this.m_sslEngine.getSession().getApplicationBufferSize() > dstBuf.writableBytes()) {
                        int size = this.m_sslEngine.getSession().getApplicationBufferSize();
                        dstBuf = allocator.buffer(size);
                        writerIndex = dstBuf.writerIndex();
                        byteBuffer = dstBuf.nioBuffer(writerIndex, dstBuf.writableBytes());
                        continue block9;
                    }
                    throw new TLSException("SSL engine unexpectedly overflowed when decrypting");
                }
                case BUFFER_UNDERFLOW: {
                    if (srcBuffer.hasRemaining()) {
                        dstBuf.release();
                        throw new TLSException("SSL engine unexpectedly underflowed when decrypting");
                    }
                    return dstBuf;
                }
                case CLOSED: {
                    dstBuf.release();
                    throw new TLSException("SSL engine is closed on ssl unwrap of buffer.").setClosed();
                }
            }
        }
    }
}

