/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network.util.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import org.voltcore.network.util.ssl.TLSMessagingChannel;

public class MessagingChannel {
    protected final SocketChannel m_socketChannel;

    public static MessagingChannel get(SocketChannel socketChannel, SSLEngine sslEngine) {
        if (sslEngine == null) {
            return new MessagingChannel(socketChannel);
        }
        return new TLSMessagingChannel(socketChannel, sslEngine);
    }

    MessagingChannel(SocketChannel socketChannel) {
        this.m_socketChannel = socketChannel;
    }

    public SocketChannel getSocketChannel() {
        return this.m_socketChannel;
    }

    public ByteBuffer readBytes(int numBytes) throws IOException {
        ByteBuffer message = ByteBuffer.allocate(numBytes);
        while (message.hasRemaining()) {
            int read = this.m_socketChannel.read(message);
            if (read != -1) continue;
            throw new IOException("Failed to read message");
        }
        assert (message.position() == numBytes) : "Bytes read is at an unexpected position. " + numBytes + "!=" + message.position();
        message.flip();
        return message;
    }

    public ByteBuffer readMessage() throws IOException {
        ByteBuffer lengthBuffer = ByteBuffer.allocate(4);
        for (int i = 0; i < 4 && lengthBuffer.hasRemaining(); ++i) {
            int read = this.m_socketChannel.read(lengthBuffer);
            if (read != -1) continue;
            throw new IOException("Failed to read message length");
        }
        lengthBuffer.flip();
        int len = lengthBuffer.getInt();
        if (len <= 0) {
            throw new IOException("Packet size is invalid");
        }
        if (len > 0x3200000) {
            throw new IOException("Packet exceeds maximum allowed size");
        }
        return this.readBytes(len);
    }

    public int writeMessage(ByteBuffer message) throws IOException {
        int bytesWritten = 0;
        for (int i = 0; i < 4 && message.hasRemaining(); ++i) {
            bytesWritten += this.m_socketChannel.write(message);
        }
        if (message.hasRemaining()) {
            throw new IOException("Unable to write message");
        }
        return bytesWritten;
    }

    public void cleanUp() {
    }
}

