/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network.util;

import com.google_voltpatches.common.base.Preconditions;
import com.google_voltpatches.common.util.concurrent.ListenableFuture;
import com.google_voltpatches.common.util.concurrent.ListenableFutureTask;
import com.google_voltpatches.common.util.concurrent.ListeningExecutorService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreUtils {
    private static final Logger log = LoggerFactory.getLogger(CoreUtils.class);
    public static final int SMALL_STACK_SIZE = 262144;
    public static final int MEDIUM_STACK_SIZE = 524288;
    public static final ListeningExecutorService LISTENINGSAMETHREADEXECUTOR = new ListeningExecutorService(){

        @Override
        public void execute(Runnable command) {
            if (command == null) {
                throw new NullPointerException();
            }
            command.run();
        }

        @Override
        public void shutdown() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) {
            return true;
        }

        @Override
        public <T> ListenableFuture<T> submit(Callable<T> task) {
            Preconditions.checkNotNull(task);
            ListenableFutureTask<T> retval = ListenableFutureTask.create(task);
            retval.run();
            return retval;
        }

        @Override
        public <T> ListenableFuture<T> submit(Runnable task, T result) {
            Preconditions.checkNotNull(task);
            ListenableFutureTask<T> retval = ListenableFutureTask.create(task, result);
            retval.run();
            return retval;
        }

        @Override
        public ListenableFuture<?> submit(Runnable task) {
            Preconditions.checkNotNull(task);
            ListenableFutureTask<Object> retval = ListenableFutureTask.create(task, null);
            retval.run();
            return retval;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
            Preconditions.checkNotNull(tasks);
            ArrayList<Future<T>> retval = new ArrayList<Future<T>>(tasks.size());
            for (Callable<T> c : tasks) {
                FutureTask<T> ft = new FutureTask<T>(c);
                retval.add(new FutureTask<T>(c));
                ft.run();
            }
            return retval;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
            FutureTask ft;
            int ii;
            Preconditions.checkNotNull(tasks);
            Preconditions.checkNotNull(unit);
            long end = System.nanoTime() + unit.toNanos(timeout);
            ArrayList<Future<T>> retval = new ArrayList<Future<T>>(tasks.size());
            for (Callable<T> c : tasks) {
                retval.add(new FutureTask<T>(c));
            }
            int size = retval.size();
            for (ii = 0; ii < size; ++ii) {
                ft = (FutureTask)retval.get(ii);
                ft.run();
                if (System.nanoTime() > end) break;
            }
            while (ii < size) {
                ft = (FutureTask)retval.get(ii);
                ft.cancel(false);
                ++ii;
            }
            return retval;
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws ExecutionException {
            T retval = null;
            Throwable lastException = null;
            boolean haveRetval = false;
            for (Callable<T> c : tasks) {
                try {
                    retval = c.call();
                    haveRetval = true;
                    break;
                }
                catch (Throwable t) {
                    lastException = t;
                }
            }
            if (haveRetval) {
                return retval;
            }
            throw new ExecutionException(lastException);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws ExecutionException, TimeoutException {
            long end = System.nanoTime() + unit.toNanos(timeout);
            T retval = null;
            Throwable lastException = null;
            boolean haveRetval = false;
            for (Callable<T> c : tasks) {
                if (System.nanoTime() > end) {
                    throw new TimeoutException("CoreUtils.ListeningExecutorService.invokeAny()");
                }
                try {
                    retval = c.call();
                    haveRetval = true;
                    break;
                }
                catch (Throwable t) {
                    lastException = t;
                }
            }
            if (haveRetval) {
                return retval;
            }
            throw new ExecutionException(lastException);
        }
    };

    public static ThreadFactory getThreadFactory(String name) {
        return CoreUtils.getThreadFactory(null, name, 262144, true);
    }

    public static ThreadFactory getThreadFactory(String groupName, String name) {
        return CoreUtils.getThreadFactory(groupName, name, 262144, true);
    }

    public static ThreadFactory getThreadFactory(String name, int stackSize) {
        return CoreUtils.getThreadFactory(null, name, stackSize, true);
    }

    public static ThreadFactory getThreadFactory(String groupName, final String name, final int stackSize, final boolean incrementThreadNames) {
        ThreadGroup group = null;
        if (groupName != null) {
            group = new ThreadGroup(Thread.currentThread().getThreadGroup(), groupName);
        }
        final ThreadGroup finalGroup = group;
        return new ThreadFactory(){
            private final AtomicLong m_createdThreadCount = new AtomicLong(0L);
            private final ThreadGroup m_group = finalGroup;

            @Override
            public synchronized Thread newThread(Runnable r) {
                String threadName = name + (String)(incrementThreadNames ? " - " + this.m_createdThreadCount.getAndIncrement() : "");
                Runnable runnable = () -> {
                    try {
                        r.run();
                    }
                    catch (Throwable t) {
                        log.error("Exception thrown in thread " + threadName, t);
                    }
                };
                Thread t = new Thread(this.m_group, runnable, threadName, stackSize);
                t.setDaemon(true);
                return t;
            }
        };
    }
}

